{include file="header.tpl" meta_tile="Deposit"}

{call name="account_heading" title="Deposit"}

{call name="content_start" section_id="account" center=1}

{if $fatal}

{if $fatal == 'one_per_month'}
You can deposit once a month only.
{/if}

{else}

{literal}
<script language="javascript"><!--
function updateCompound() {
  var id = 0;
  var tt = document.spendform.h_id.type;
  if (tt && tt.toLowerCase() == 'hidden') {
    id = document.spendform.h_id.value;
  } else {
    for (i = 0; i < document.spendform.h_id.length; i++) {
      if (document.spendform.h_id[i].checked) {
        id = document.spendform.h_id[i].value;
      }
    }
  }

  var cpObj = document.getElementById('compound_percents');
  if (cpObj) {
    while (cpObj.options.length != 0) {
      cpObj.options[0] = null;
    }
  }

  if (cps[id] && cps[id].length > 0) {
    document.getElementById('coumpond_block').style.display = '';

    for (i in cps[id]) {
      cpObj.options[cpObj.options.length] = new Option(cps[id][i]);
    }
  } else {
    document.getElementById('coumpond_block').style.display = 'none';
  }
}
var cps = {};
--></script>
{/literal}

{if $frm.say eq 'deposit_success'}
{call name="alert" type="success" text="The deposit has been successfully saved"}
{/if}

{if $frm.say eq 'deposit_saved'}
{call name="alert" type="success" text="The deposit has been saved. It will become active once the administrator confirm it"}
{/if}

{if $errors}
{if $errors.less_min}
{capture assign=note}Sorry, you can deposit not less than {$errors.less_min|fiat:$errors.less_min_ec} with selected processing{/capture}
{call name="alert" text=$note}
{/if}
{if $errors.greater_max}
{capture assign=note}Sorry, you can deposit not greater than {$errors.greater_max|fiat:$errors.greater_max_ec} with selected processing{/capture}
{call name="alert" text=$note}
{/if}
{if $errors.not_enough_funds}
{call name="alert" text="You have insufficient funds to complete the operation"}
{/if}
{if $errors.ec_forbidden}
{call name="alert" text="Sorry, deposit with selected processing is temproary forbidden"}
{/if}
{if $errors.cannot_invest_this_plan_anymore}
{call name="alert" text="Sorry, you cannot invest this plan anymore"}
{/if}
{if $errors.external_deposits_disabled}
{call name="alert" text="Deposit to this plan from external processing is forbidden"}
{/if}
{if $errors.internal_deposits_disabled}
{call name="alert" text="Deposit to this plan from balance is forbidden"}
{/if}
{if $errors.no_ps}
{call name="alert" text="Please, select funds source"}
{/if}
{if $errors.deposits_amount_exeeded}
{capture assign=note}Your total deposit in &quot;{$errors.deposits_amount_exeeded.plan|escape:html}&quot; should not more than {$errors.deposits_amount_exeeded.amount_limit|fiat}{/capture}
{call name="alert" text=$note}
{/if}
{/if}

<form method=post name="spendform" class="validate minmaxamount">
<input type=hidden name=a value=deposit>

  <div class="plan_select row justify-content-center mb-3 aos-init" data-aos="fade-up">
{if $qplans > 1}
<div class="title"><i class="bi bi-gear"></i> Select an Investment Plan</div>
{/if}


{assign var="slch" value=1}
{foreach from=$plans item=plan name=fplans}
    <input type="radio" name="h_id" value="{$plan.id}" id="inpt_plan_{$plan.id}" required onclick="updateCompound()"
             {if $frm.h_id == $plan.id || $slch}{assign var="slch" value=0}checked{/if}
             data-min-dep-val="{$plan.min_deposit}" data-min-dep-val-notice="Minimal deposit amount for {$plan.name|escape:html} is {$plan.min_deposit|fiat}"
             data-max-dep-val="{$plan.max_deposit}" data-max-dep-val-notice="Maximal deposit amount for {$plan.name|escape:html} is {$plan.max_deposit|fiat}">

    <label class="col-12 col-md-4" for="inpt_plan_{$plan.id}">
      <div class="icon"><i class="bi bi-bar-chart"></i></div>
      <h4>{$plan.name}</h4>
      <ul>
        <li><i class="bi bi-check-all"></i>
          {if $plan.period_type == 'end' || $plan.period_type == 'endh'}
           Profit after {$plan.periods} {$plan.time_units}{if $plan.periods != 1}s{/if}
          {else}
           Profit {$plan.period} for {if $plan.periods == 0}lifelong{else}{$plan.periods} {$plan.time_units}{if $plan.periods != 1}s{/if} {if $plan.work_week}(mon-fri){/if}{/if}
          {/if}
        </li>
        <li><i class="bi bi-check-all"></i> Min Deposit: {$plan.min_deposit|fiat}</li>
        <li><i class="bi bi-check-all"></i> {if $plan.max_deposit == 0}No {/if}Max Deposit {if $plan.max_deposit != 0}{$plan.max_deposit|fiat}{/if}</li>
      </ul>
      <table class="m-auto">
      {foreach from=$plan.plans item=o}
      <tr>
       <td align=left><span class="min_deposit">{$o.min_deposit|fiat}</span> - <span class="max_deposit">{if $o.max_deposit == 0}&infin;{else}{$o.max_deposit|fiat}{/if}</span></td>
       <td align=right><b>{$o.percent}%</b></td>
      </tr>
      {/foreach}
      </table>
    </label>

    <script>cps[{$plan.id}] = {$plan.compound_percents_json};</script>
{/foreach}
  </div>

  <br clear=all>
  <div class="balance_select row justify-content-center mb-3 aos-init" data-aos="fade-up">
    <div class="title"><i class="bi bi-cash-stack"></i> Select Payment System</div>

    <ul class="nav nav-pills justify-content-center mb-3" id="pills-tab" role="tablist">
      <li class="nav-item" role="presentation">
        <button class="nav-link active" id="process-tab" data-bs-toggle="pill" data-bs-target="#process-list" type="button" role="tab">Pay From Wallet</button>
      </li>
      <li class="nav-item" role="presentation">
        <button class="nav-link" id="account-tab" data-bs-toggle="pill" data-bs-target="#account-list" type="button" role="tab">Pay From Balance</button>
      </li>
    </ul>
    <div class="tab-content" id="pills-tabContent">
      <div class="tab-pane fade show active" id="process-list" role="tabpanel" tabindex="0">
        {assign var="wfch" value=1}
        {foreach from=$dps item=p}
          <input type="radio" name="type" value="process_{$p.id}" id="inpt_process_{$p.id}" data-fiat="{$p.fiat}" required
                   {if $frm.type == "process_`$p.id`" || $wfch}{assign var="wfch" value=0}checked{/if}
                   data-min-val="{$p.amount_min}" data-min-val-notice="Minimal deposit amount for {$p.name} is {$p.amount_min|fiat}"
                   data-max-val="{$p.amount_max}" data-max-val-notice="Maximal deposit amount for {$p.name} is {$p.amount_max|fiat}"
          >
          <label class="col-12 col-md-3" for="inpt_process_{$p.id}">
            <div class="icon"><img src="images/{$p.id}.gif" alt="{$p.name|escape:html}" title="{$p.name|escape:html}"></div>
            <div class="name">{$p.name|escape:html}</div>
          </label>
        {/foreach}
      </div>
      <div class="tab-pane fade" id="account-list" role="tabpanel" tabindex="1">
        {foreach from=$dps item=p}
          {if $p.available > 0}
          <input type="radio" name="type" value="account_{$p.id}" id="inpt_account_{$p.id}" data-fiat="{$p.fiat}" required
                   {if $frm.type == "account_`$p.id`"}checked{/if}
                   data-max-val="{$p.available}" data-max-val-notice="You have {$p.available|fiat} avaliable on {$p.name} balance only"
          >
          <label class="col-12 col-md-3" for="inpt_account_{$p.id}">
            <div class="icon"><img src="images/{$p.id}.gif" alt="{$p.name|escape:html}" title="{$p.name|escape:html}"></div>
            <div class="amount">
              <div class="name">{$p.name|escape:html}</div>
              <small>Balance:</small> <b style="color:green">{$p.available|fiat:$p.ec}</b>
            </div>
          </label>
          {/if}
        {/foreach}
      </div>
    </div>
  </div>

  <br clear=all>

  <div id="coumpond_block" style="display:none" class="col-10 col-md-6 m-auto mb-3 aos-init" data-aos="zoom-in">
    <div class="title text-center mt-3"><i class="bi bi-arrow-repeat"></i> Compounding %</div>

    <div class="form-floating">
      <select name="compound" class="form-control" id="compound_percents"></select>
      <label for="compound_percents"><i class="bi bi-arrow-repeat"></i> Compounding %</label>
    </div>
  </div>

  <div class="col-10 col-md-6 m-auto mb-3 aos-init" data-aos="zoom-in">
    <div class="title text-center mt-3"><i class="bi bi-cash-coin"></i> Deposit Amount</div>

    <div class="form-floating">
      <input type="text" id="inpt_amount" name="amount" value="{$frm.amount|amount_format|default:"10.00"}" class="form-control" placeholder="Deposit"
          data-v-not-zerro="" data-v-notice-not-zerro="Please, enter Amount"
      >
      <label for="inpt_amount"><i class="bi bi-cash-coin"></i> Amount</label>
      <div id="inpt_amount_err" class="invalid-feedback"></div>
    </div>
  </div>

  <div class="col-12 text-center">
    <input type=submit class="btn btn-primary" value="Deposit">
  </div>


</form>
{literal}
<script language=javascript>
updateCompound();
</script>
{/literal}

{/if}

{call name="content_end"}

{include file="footer.tpl"}