{include file="header.tpl" meta_tile="Active Deposits"}

{call name="account_heading" title="Active Deposits"}

{call name="content_start" section_id="account" center=1}


<div class="row counts">
{foreach from=$deposits item=d}
   <div class="deposit_list col-12 mb-3">
     <div class="row">
       <div class="col-12 col-md-4 deposit_plan">
         <div class="title">{$d.type.name|escape:html}</div>
         <p><b>{$d.plan_percent}% {$d.type.period}</b></p>
         {if $d.type.use_compound}
         <p>Compound: <a href="{"?a=change_compound&deposit=`$d.id`"|encurl}" class="btn btn-info btn-sm"><b>{$d.compound}%</b></a></p>
         {/if}
       </div>
       <div class="col-12 col-md-4 deposit_date">
         <div class="title">{if $d.type.periods == 0}Working {$d.duration} days{else}Expires in {$d.expire_in}{/if}</div>
         <p>Since <strong>{$d.date}</strong></p>
       </div>
       <div class="col-12 col-md-4 deposit_amount">
         <div class="title">Deposit: <b>{$d.amount|fiat:$d.ec}</b> <img src="images/{$d.ec}.gif" align=absmiddle></div>
         <p>Profit: <b>{$d.total_profit|fiat:$d.ec}</b></p>
         <p>
            {if $d.can_withdraw}
              <a href="{"?a=withdraw_principal&deposit=`$d.id`"|encurl}" class="btn btn-danger btn-sm">Release</a>
            {else}
              {if $d.pending_duration > 0}
                <a class="btn btn-secondary btn-sm">{$d.pending_duration} day(s) left till release abailable</a>
               {/if}
            {/if}
         </p>
       </div>
     </div>
   </div>
{foreachelse}
{call name="alert" type="info" text="No Active Deposits"}
{/foreach}
</div>

{call name="content_end"}

{include file="footer.tpl"}