{include file="header.tpl" meta_tile="Edit Account"}

{call name="account_heading" title="Edit Account"}

{call name="content_start" section_id="account" center=1}

<form action="" method=post name=editform class="validate">
<input type=hidden name=a value=edit_account>
<input type=hidden name=action value=edit_account>
<input type=hidden name=say value="">

{if $frm.say eq 'changed'}
{call name="alert" type="success" text="Your account data has been successfully updated"}
{/if}
{if $errors}
{if $errors.turing_image}{call name="alert" text="Invalid turing image"}{/if}
{if $errors.invalid_transaction_code}{call name="alert" text="You have provided invalid Current Transaction Code"}{/if}
{if $errors.tfa_code}{call name="alert" text="Invalid 2FA code"}{/if}
{if $errors.no_fullname}{call name="alert" text="Please enter your Full Name"}{/if}
{if $errors.password_confirm}{call name="alert" text="Please correcty confirm your password"}{/if}
{if $errors.password_too_small}{call name="alert" text="The password you provided is too small, please enter at least `$errors.password_too_small` characters!"}{/if} 
{if $errors.invalid_email}{call name="alert" text="Please enter valid email address"}{/if} 
{if $errors.email_confirm}{call name="alert" text="Please correcty confirm your email address"}{/if}
{if $errors.email_exists}{call name="alert" text="An account with this email is already exists"}{/if}
{if $errors.no_address}{call name="alert" text="Please enter your address"}{/if}
{if $errors.no_city}{call name="alert" text="Please enter your city"}{/if}
{if $errors.no_state}{call name="alert" text="Please enter your state"}{/if}
{if $errors.no_zip}{call name="alert" text="Please enter your zip"}{/if}
{if $errors.no_country}{call name="alert" text="Please enter your country"}{/if}
{if $errors.transaction_code_confirm}{call name="alert" text="Please correcty confirm your transaction code"}{/if}
{if $errors.transaction_code_too_small}{call name="alert" text="The transaction code you provided is too small, please enter at least `$errors.transaction_code_too_small` characters!"}{/if} 
{if $errors.transaction_code_vs_password}{call name="alert" text="The Transaction Code should not be equal to the Password you have defined"}{/if}
{if $errors.invalid_account_format}
 {foreach from=$errors.invalid_account_format item=err}
 {call name="alert" text=$err}
 {/foreach}
{/if}
{/if}

<div class="row">
  {call name="user_field" title="Username"  fname="username" icon="person-circle" readonly=1 value=$userinfo.username}
  {call name="user_field" title="Since"  fname="since" icon="calendar" readonly=1 value=$userinfo.date_register}
  {call name="user_field" title="Full Name" fname="fullname" icon="person" value=$frm.fullname|default:$userinfo.name|escape:html validate=[['func'=>'not-empty','notice'=>'Please, enter Full Name']]}
  {$ro = 0}{if $settings.usercanchangeemail != 1}{$ro = 1}{/if}
  {call name="user_field" title="E-mail Address" fname="email" icon="envelope-at" readonly=$ro value=$frm.email|default:$userinfo.email|escape:html validate=[['func'=>'not-empty','notice'=>'Please, enter Email address'],['func'=>'email','notice'=>'Please, enter valid email address']]}
</div>

{if $settings.use_user_location}
<div class="row">
  {if $settings.use_user_location == 1}{$val_func = 'not-empty'}{/if}
  {call name="user_field" title="Address" fname="address" icon="globe2" value=$frm.address|default:$userinfo.address|escape:html validate=[['func'=>$val_func,'notice'=>'Please, enter Address']]}
  {call name="user_field" title="City" fname="city" icon="globe2" value=$frm.city|default:$userinfo.city|escape:html validate=[['func'=>$val_func,'notice'=>'Please, enter Address']]}
  {call name="user_field" title="State" fname="state" icon="globe2" value=$frm.state|default:$userinfo.state|escape:html validate=[['func'=>$val_func,'notice'=>'Please, enter State']]}
  {call name="user_field" title="ZIP" fname="zip" icon="globe2" value=$frm.zip|default:$userinfo.zip|escape:html validate=[['func'=>$val_func,'notice'=>'Please, enter Zip']]}
  {call name="user_field" title="Country" fname="country" icon="globe2" type="country" value=$userinfo.country validate=[['func'=>$val_func,'notice'=>'Please, enter Contry']]}
</div>
{/if}


<div class="row">
  {call name="user_field" title="New Password" fname="password" icon="lock" type="password" validate=[['func'=>'skip-empty','param'=>1],['func'=>'min-len','param'=>$settings.min_user_password_length,'notice'=>"Password should contains `$settings.min_user_password_length` charaters at least"]]}
  {call name="user_field" title="Retype Password" fname="password2" icon="lock" type="password" validate=[['func'=>'equiv-to','param'=>'password','notice'=>'Please retype Password correctly']]}
</div>

{if $settings.use_transaction_code}
<div class="row">
  {call name="user_field" title="New Transaction Code" fname="transaction_code" icon="lock-fill" type="password" validate=[['func'=>'skip-empty','param'=>1],['func'=>'min-len','param'=>$settings.min_transaction_code_length,'notice'=>"Transaction Code should contains `$settings.min_transaction_code_length` charaters at least"]]}
  {call name="user_field" title="Retype Transaction Code" fname="transaction_code2" icon="lock-fill" type="password" validate=[['func'=>'equiv-to','param'=>'transaction_code','notice'=>'Please retype Transaction Code correctly']]}
</div>
{/if}

<div class="row">
{foreach from=$pay_accounts item=ps}
  {$ro = 0}{if $settings.usercanchangeegoldacc == 0 && $ps.account != ''}{$ro = 1}{/if}
  {call name="account_field" fname=$ps.name id=$ps.id account=$ps.account|escape:html readonly=$ro validate=$ps.validate}
{/foreach}
{foreach item=p from=$mpay_accounts}
{foreach item=ps from=$p.accounts}
  {$ro = 0}{if $settings.usercanchangeegoldacc == 0 && $ps.value != ''}{$ro = 1}{/if}
  {call name="account_field" fname=$p.name title=$ps.name id=$p.id subname=$ps.name|escape:html readonly=$ro account=$ps.value|escape:html}
{/foreach}
{/foreach}
</div>

{if $settings.use_rcb}
<div class="row">
  {$ro = 0}{if $userinfo.rcb_lock}{$ro = 1}{/if}
  {call name="user_field" colmd=12 title="Your RCB Percent" fname="rcb" readonly=$ro value=$frm.rcb|default:$userinfo.rcb|number_format:2 icon="question-circle" type="password" validate=[['func'=>'not-empty','notice'=>'Please, enter your current Transaction Code to verify updates']]}
</div>
{/if}

{if $userinfo.admin_auto_pay_earning == 1}
<div class="row">
  <div class="col-12 mb-3">
    <input class="form-check-input" id="inpt_auto_pay_earning" type=checkbox name="user_auto_pay_earning" value=1 {if $userinfo.user_auto_pay_earning == 1}checked{/if}>
    <label class="form-check-label" for="inpt_auto_pay_earning">Receive earnings directly to e-currency account</label>
  </div>
</div>
{/if}

{if $settings.use_transaction_code && $userinfo.transaction_code != ''}
<div class="row">
  {call name="user_field" colmd=12 title="Current Transaction Code" fname="transaction_code_current" icon="question-circle" type="password" validate=[['func'=>'not-empty','notice'=>'Please, enter your current Transaction Code to verify updates']]}
</div>
{/if}

{if $userinfo.tfa_settings.edit_account}
<div class="row">
  {call name="user_field" colmd=12 title="2FA Code" fname="tfa_code" icon="question-circle" validate=[['func'=>'not-empty','notice'=>'Please, enter 2FA code to verify updates']]}
  <input type="hidden" name="tfa_time" id="tfa_time">
</div>
{literal}
<script language=javascript>
document.getElementById('tfa_time').value = (new Date()).getTime();
</script>
{/literal}
{/if}

{include file="captcha.tpl" action="edit_account"}

  <div class="col-12">
    <input type=submit class="btn btn-primary" value="Update">
  </div>

</form>

{call name="content_end"}


{include file="footer.tpl"}