{function name="page_heading"}
<section class="page_title d-flex align-items-center">
  <div class="container position-relative">
    <div class="row justify-content-center">
      <div class="col-xl-7 col-lg-9 col-11 text-center">
        <h1>{$title}</h1>
        <h2>{$slogan}</h2>
      </div>
    </div>
  </div>
</section>
{/function}


{function name="account_heading"}
<section class="account_title d-flex align-items-center">
  <div class="container position-relative">
    <div class="row justify-content-center">
      <div class="col-xl-7 col-lg-9 col-11 text-center">
        <h1>{$title}</h1>
        <h2>{$slogan}</h2>
      </div>
    </div>
  </div>
</section>
{/function}


{function name="content_start" animation=1}
<section id="{$section_id|default:"common"}">
  <div class="container">

    <div class="row justify-content-center">
      <div class="col-md-10 col-lg-9 d-flex align-items-center aos-init"{if $animation} data-aos="fade-up" data-aos-delay="0"{/if}>
        <div class="flex-fill content-frame{if $center} text-center{/if}">
{/function}

{function name="content_end"}
        </div>
      </div>
    </div>

  </div>
</section>
{/function}


{function name="alert" type="danger"}
<div class="alert alert-{$type} error-alert{if $dismissible} alert-dismissible fade show{/if}"{if $field_id} data-error-apply="{$field_id}"{/if}>{$text}</div>
{/function}

{function name="user_field" type="input" col=12 colmd=6 mb=3}
<div class="col-{$col} col-md-{$colmd} mb-{$mb}">
  <div class="form-floating">
{if $type == "input"}
    <input type="text" id="inpt_{$fname}" name="{$fname}" value="{$frm[$fname]|default:$value|escape:html}" class="form-control"{if $readonly} readonly disabled{/if} placeholder="{$title}" {if $validate}{foreach from=$validate item=v}{if $v.func}data-v-{$v.func}="{$v.param}" data-v-notice-{$v.func}="{$v.notice|escape:html}"{/if}{/foreach}{/if}>
{elseif $type == "country"}
    <select name="country" id="inpt_{$fname}" class="form-select"{if $readonly} readonly disabled{/if}>
      <option value="">--Select Country--</option>
      {foreach from=$countries item=c}
      <option {if ($frm.country && $c.name == $frm.country) || (!$frm.country && $c.name == $value)}selected{/if}>{$c.name|escape:html}</option>
      {/foreach}
    </select>
{elseif $type == "textarea"}
    <textarea id="inpt_{$fname}" name="{$fname}" class="form-control"{if $readonly} readonly disabled{/if} placeholder="{$title}" {if $validate}{foreach from=$validate item=v}{if $v.func}data-v-{$v.func}="{$v.param}" data-v-notice-{$v.func}="{$v.notice|escape:html}"{/if}{/foreach}{/if}>{$frm[$fname]|escape:html}</textarea>
{elseif $type == "password"}
    <input type="password" id="inpt_{$fname}" name="{$fname}" value="{$frm[$fname]|escape:html}" class="form-control"{if $readonly} readonly disabled{/if} placeholder="{$title}" {if $validate}{foreach from=$validate item=v}{if $v.func}data-v-{$v.func}="{$v.param}" data-v-notice-{$v.func}="{$v.notice|escape:html}"{/if}{/foreach}{/if}>
{/if}
    <label for="inpt_{$fname}"><i class="bi bi-{$icon}"></i> {$title}</label>
    <div id="inpt_{$fname}_err" class="invalid-feedback"></div>
  </div>
</div>
{/function}

{function name="account_field"}
<div class="col-12 col-md-6 mb-3">
  <div class="form-floating">
   <input type="text" id="inpt_pa_{$id}" name="pay_account[{$id}]{if $subname}[{$subname}]{/if}" value="{$account|escape:html}" class="form-control" {if $validate}data-v-account=1 data-v-{$validate.func}="{$validate[$validate.func]}" data-v-notice-{$validate.func}="Invalid account format. Expected {$validate.notification|escape:html} f.e. {$validate.placeholder|escape:html}" placeholder="{$validate.placeholder|escape:html}"{/if}>
   <label for="inpt_pa_{$id}"><img src="images/{$id}.gif" alt="" align=absmiddle> {$fname} {$title|default:"Account"}</label>
   <div id="inpt_pa_{$id}_err" class="invalid-feedback"></div>
  </div>
</div>
{/function}