{include file="functions.tpl"}
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>{$meta_title|default:$settings.site_name}</title>
  <base href="{$settings.site_url}/" src="{$settings.site_url}/" />
  <meta content="" name="description">
  <meta content="" name="keywords">
  <link href="favicon.ico" rel="icon">
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Raleway:300,300i,400,400i,500,500i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-GLhlTQ8iRABdZLl6O3oVMWSktQOp6b7In1Zl3/Jr59b6EGGoI1aFkw7cmDA6j6gD" crossorigin="anonymous">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.3/font/bootstrap-icons.css" rel="stylesheet">
  <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
  <link href="assets/css/style.css" rel="stylesheet">
</head>
<body data-aos-easing="ease-in-out" data-aos-duration="1000" data-aos-delay="0">

{if $no_header != 1}
<header id="header" class="fixed-top">
  <div class="container d-flex align-items-center justify-content-between">
    <h1 class="logo"><a href="{"/"|encurl}">{$settings.site_name}</a></h1>
    <nav id="navbar" class="navbar">
      <ul>
{if !$userinfo.logged}
        <li><a class="nav-link" href="{"?a=home"|encurl}">Home</a></li>
        <li><a class="nav-link" href="{"?a=aboutus"|encurl}">About</a></li>
        <li><a class="nav-link" href="{"?a=faq"|encurl}">F.A.Q</a></li>
        <li><a class="nav-link" href="{"?a=rules"|encurl}">Rules</a></li>
        <li><a class="nav-link" href="{"?a=support"|encurl}">Support</a></li>
{/if}
{if $userinfo.logged}
        <li><a class="action dashboard" href="{"?a=account"|encurl}"><i class="bi bi-speedometer pe-2"></i> Dashbaord</a></li>

        <li><a class="action btn-deposit" href="{"?a=deposit"|encurl}"><i class="bi bi-wallet-fill pe-2"></i> Deposit</a></li>
        <li><a class="action btn-withdraw" href="{"?a=withdraw"|encurl}"><i class="bi bi-cash-coin pe-2"></i> Withdraw</a></li>

        <li class="dropdown">
          <a class="action actions" href="{"?a=deposit_list"|encurl}">Actions <i class="ms-2 bi bi-chevron-compact-down"></i></a>
          <ul>
            <li><a href="{"?a=deposit_list"|encurl}">Active Deposits</a></li>
            {if $settings.use_referal_program == 1}
            <li><a href="{"?a=referals"|encurl}">Referrals Info</a></li>
            <li><a href="{"?a=referallinks"|encurl}">Marketing Materials</a></li>
            {/if}
            {if $settings.tell_friend_page}
            <li><a href="{"?a=tell_friend"|encurl}">Tell a Friend</a></li>
            {/if}
            {if $settings.use_add_funds}
            <li><a href="{"?a=add_funds"|encurl}">Topup Balance</a></li>
            {/if}
            {if $settings.enable_exchange}
            <li><a href="{"?a=exchange"|encurl}">Currency Exchange</a></li>
            {/if}
            {if $settings.internal_transfer_enabled}
            <li><a href="{"?a=internal_transfer"|encurl}">Internal Transfer</a></li>
            {/if}

            <li><a href="{"?a=edit_account"|encurl}">Edit Profile</a></li>
            <li><a href="{"?a=security"|encurl}">Security Settings</a></li>
          </ul>
        </li>


        <li class="dropdown">
          <a class="action history" href="{"?a=history"|encurl}">Transactions <i class="ms-2 bi bi-chevron-compact-down"></i></a>
          <ul>
            <li><a href="{"?a=deposit_history"|encurl}">Deposits</a></li>
            <li><a href="{"?a=history&type=earning"|encurl}">Earnings</a></li>
            <li><a href="{"?a=history&type=withdrawal"|encurl}">Withdrawals</a></li>
            {if $settings.use_referal_program}
            <li><a href="{"?a=history&type=commissions"|encurl}">Commissions</a></li>
            {/if}
          </ul>
        </li>

        <li><a class="action logout" href="{"?a=logout"|encurl}">LogOut <i class="bi bi-box-arrow-right ps-2"></i></a></li>
{else}
        <li><a class="action login" href="{"?a=login"|encurl}"><i class="bi bi-box-arrow-right pe-2"></i> LogIn</a></li>
        <li><a class="action signup" href="{"?a=signup"|encurl}"><i class="bi bi-pencil-square pe-2"></i> SignUp</a></li>
{/if}
      </ul>
      <i class="bi bi-list mobile-nav-toggle"></i>
    </nav>
  </div>
</header>
{/if}