{include file="header.tpl" meta_tile="Referrals"}

{call name="account_heading" title="Referrals"}

{call name="content_start" section_id="account" center=1}

{loaddata name="user_referrals" total_direct_referrals=1 total_active_direct_referrals=1 total_commissions=1 referrals=1 var=rf}
<div class="counts row justify-content-center mb-3 aos-init" data-aos="zoom-in">

  <div class="col-12 col-md-3 mb-3 d-flex align-items-stretch align-items-center">
    <div class="count-box">
      <span>{if $userinfo.ref > 0}<a href=mailto:{$userinfo.ref_email}>{$userinfo.ref_username}</a>{else}<i>None</i>{/if}</span>
      <p>Upline</p>
    </div>
  </div>

  <div class="col-12 col-md-3 mb-3 d-flex align-items-stretch align-items-center">
    <div class="count-box">
      <span data-purecounter-start="0" data-purecounter-end="{$rf.total_direct_referrals}" data-purecounter-duration="1" class="purecounter"></span>
      <p>Direct Referrals</p>
    </div>
  </div>

  <div class="col-12 col-md-3 mb-3 d-flex align-items-stretch align-items-center">
    <div class="count-box">
      <span data-purecounter-start="0" data-purecounter-end="{$rf.total_active_direct_referrals}" data-purecounter-duration="1" class="purecounter"></span>
      <p>Active Direct Referrals</p>
    </div>
  </div>

  <div class="col-12 col-md-3 mb-3 d-flex align-items-stretch align-items-center">
    <div class="count-box">
      <span data-purecounter-start="0" data-purecounter-end="{$rf.total_commissions}" data-purecounter-currency="{fiat}" data-purecounter-duration="1" class="purecounter"></span>
      <p>Commissions Gained</p>
    </div>
  </div>

</div>

<div class="row">
{if $settings.show_refstat}
  <div class="col-12 col-md-12 mb-3">
    <div class="flex-fill content-frame text-center">

      <div class="title">Referral Clicks / Signups</div>

      <form method=post name=opts>
      <input type=hidden name=a value=referals>
      <div class="row">
       <div class="col-10 text-end">
      From: <input type="date" name="date_from" value="{$frm.date_from}" class="form-control mb-2" style="width:60%;display:inline-block;">
      <br>
      To: <input type="date" name="date_to" value="{$frm.date_to}" class="form-control mb-2" style="width:60%;display:inline-block;">
       </div>
       <div class="col-2 align-self-center">
         <input type="submit" value="Go" class="btn btn-primary">
       </div>
      </div>
      </form>

      <table class="table table-responsive table-striped align-middle">
      <thead>
      <tr>
       <th>Date</th>
       <th>Clicks</th>
       <th>Signups</th>
      </tr>
      </thead>
      {foreach from=$refstat item=s}
      <tr>
       <td><b>{$s.date}</b></td>
       <td>{$s.income}</td>
       <td>{$s.reg}</td>
      </tr>
      {foreachelse}
      <tr>
       <td align=center colspan=3>No statistics found for this period.</td>
      </tr>
      {/foreach}
      </table>

    </div>
  </div>

{/if}

{if $settings.show_referals}
  <div class="col-12 col-md-12 mb-3">
    <div class="flex-fill content-frame text-center">

      <div class="title">Your Referrals</div>

    <ul class="nav nav-pills justify-content-center mb-3" id="pills-tab" role="tablist">
    {foreach from=$rf.referrals item=r key=lvl}
      <li class="nav-item" role="presentation">
        <button class="nav-link{if $lvl == 1} active{/if}" id="process-tab" data-bs-toggle="pill" data-bs-target="#ref-list{$lvl}" type="button" role="tab">Level {$lvl}</button>
      </li>
    {/foreach}
    </ul>
    <div class="tab-content" id="pills-tabContent">
    {foreach from=$rf.referrals item=refs key=lvl}
      <div class="tab-pane fade{if $lvl == 1} show active{/if}" id="ref-list{$lvl}" role="tabpanel" tabindex="{$lvl}">

        <table class="table table-responsive table-striped align-middle">
        <thead>
        <tr>
         <th>Username</th>
         <th>Email</th>
         <th>Deposit</th>
        </tr>
        </thead>
        {foreach from=$refs item=r}
        <tr>
         <td align=left><b>{$r.username|escape:html}</b></td>
         <td><a href=mailto:{$r.email|escape:html}><i class="bi bi-envelope-at"></i></a></td>
         <td>{if $r.deposits_amount > 0}{$r.deposits_amount|fiat}{else}<i>n/a</i>{/if}</td>
        </tr>
        {if $referals[s].came_from}
        <tr><td colspan=3>
        <a href="{$r.came_from}" target=_blank>[User came from]</a>
        </td></tr>
        {/if}
        {/foreach}
        </table>
      </div>
    {/foreach}
    </div>

    </div>
  </div>
{/if}
</div>

{call name="content_end"}

{include file="footer.tpl"}
