{include file="header.tpl" meta_tile="Withdraw"}

{call name="account_heading" title="Withdrawal"}

{call name="content_start" section_id="account" center=1}

{if $say eq 'processed'}
{capture assign=note}{if $batch eq ''}Withdrawal request has been successfully saved.{else} Withdrawal has been processed. Batch id: {$batch}{/if}{/capture}
{call name="alert" type="success" text=$note}
{/if}

{if $fatals}
{if $fatal == 'times_limit' || $fatals.times_limit}
{call name="alert" type="success" text="You can withdraw `$settings.limit_withdraw_period_times` per `$settings.limit_withdraw_period_date` only."}
{/if}

{else}

{if $errors.ec_forbidden}
{call name="alert" text="Sorry, withdraw for this processing is temproary forbidden."}
{/if}
{if $errors.on_hold}
{call name="alert" text="Sorry, this amount on hold now."}
{/if}
{if $errors.zero}
{call name="alert" text="Please, enter withdraw amount"}
{/if}
{if $errors.less_min}
{capture assign=note}Sorry, you can request not less than {$fees.amount_min|fiat}{/capture}
{call name="alert" text=$note}
{/if}
{if $errors.greater_max}
{capture assign=note}Sorry, you can request not greater than {$fees.amount_max|fiat}{/capture}
{call name="alert" text=$note}
{/if}
{if $errors.daily_limit}
{call name="alert" text="Sorry, you have exceeded a daily limit"}
{/if}
{if $errors.not_enought}
{call name="alert" text="Sorry, you have requested the amount larger than the one on your balance"}
{/if}
{if $errors.invalid_transaction_code}
{call name="alert" text="You have entered the invalid transaction code"}
{/if}
{if $errors.invalid_tfa_code}
{call name="alert" text="You have entered invalid 2FA code"}
{/if}
{if $errors.no_deposits}
{call name="alert" text="You have not done any deposits yet. Withdrawal function will be available after a deposit"}
{/if}
{if $errors.no_active_deposits}
{call name="alert" text="You must have active deposit to withdraw"}
{/if}
{if $errors.no_account}
{capture assign=note}Please, provide your account to withdraw funds to first <a href="{"?a=edit_account"|encurl}">here</a>{/capture}
{call name="alert" type="success" text=$note}
{/if}
{if $errors.demo}
{call name="alert" text="Withdraw is not available for demo account"}
{/if}
{if $errors.turing_image}
{call name="alert" text="Invalid turing image"}
{/if}
{if $errors.account_suspended}
{call name="alert" text="Account is suspended"}
{/if}

{if $preview}

<form method=post name="withdraw_confirm" class="validate">
<input type=hidden name=a value=withdraw>
<input type=hidden name=action value=withdraw>
<input type=hidden name=amount value={$amount}>
<input type=hidden name=ec value={$ec}>
<input type=hidden name=comment value="{$comment|escape:html}">

<table class="table table-responsive table-striped align-middle form-list">
<tr>
 <th>Payment System:</th>
 <td><img src="images/{$ec}.gif" width=44 height=17 title="{$currency|escape:html}" alt="{$currency|escape:html}" align=absmiddle> {$currency|escape:html}</td>
</tr>
<tr>
 <th>Account:</th>
 <td>{if $account != ''}{$account|escape:html}{else}<a href="{"?a=edit_account"|encurl}"><i>not set</i></a>{/if}</td>
</tr>
<tr>
 <th>Debit Amount:</th>
 <td>{$amount|fiat:$ec}</td>
</tr>
<tr>
 <th>Withdrawal Fee:</th>
 <td>
{if $fees.fee > 0}
  {$fees.percent}% + {$fees.add_amount|fiat:$ec} (min. {$fees.fee_min|fiat:$ec} max. {if $fees.fee_max}{$fees.fee_max|fiat:$ec}{else}no{/if})
{else}
We have no fee for this operation.
{/if}
</td>
</tr>

{if $converted}
<tr>
 <th>Credit Amount:</th>
 <td>{$converted.amount|fiat:$ec}</td>
</tr>
<tr>
 <th>{$converted.fiat} Amount:</th>
 <td>{$to_withdraw}</td>
</tr>
{else}
<tr>
 <th>Credit Amount:</th>
 <td>{$to_withdraw|fiat:$ec}</td>
</tr>
{/if}

{if $comment}
<tr>
 <th>Note:</th>
 <td>{$comment|escape:html}</td>
</tr>
{/if}
{if $settings.use_transaction_code && $userinfo.transaction_code}
<tr>
 <th>Transaction Code:</th>
 <td><input type="password" name="transaction_code"  class="form-control" size=15></td>
</tr>
{/if}
{include file="captcha.tpl" action="withdrawal"}
{if $userinfo.tfa_settings.withdraw}
<tr>
 <th>2FA Code:</th>
 <td><input type="text" name="tfa_code" class="form-control" size=15> <input type="hidden" name="tfa_time" id="tfa_time"></td>
</tr>
{literal}
<script language=javascript>
document.getElementById('tfa_time').value = (new Date()).getTime();
</script>
{/literal}
{/if}
</table>

  <div class="col-12 text-center">
    <input type=submit class="btn btn-success" value="Confirm">
    <input type=submit class="btn btn-warning" name="action" value="Cancel">
  </div>

</form>


{else}


<form method=post name="withdraw" class="validate minmaxamount">
<input type=hidden name=a value=withdraw>
<input type=hidden name=action value=preview>
<input type=hidden name=say value="">

{if $have_available}

  <div class="balance_select row justify-content-center mb-3 aos-init" data-aos="fade-up">
    <div class="title text-center"><i class="bi bi-cash-stack"></i> Select Payment System</div>

    {assign var="wfch" value=1}
    {foreach from=$ps item=p}
      {if $p.available > 0}
      <input type="radio" name="ec" value="{$p.id}" id="inpt_{$p.id}" data-fiat="{$p.fiat}" required
               {if $frm.ec == $p.id || $wfch}{assign var="wfch" value=0}checked{/if}
               data-min-val="{$p.amount_min}" data-min-val-notice="Minimal withdrawal amount for {$p.name} is {$p.amount_min|fiat}"
               data-max-val="{$p.amount_max}" data-max-val-notice="Maximal withdrawal amount for {$p.name} is {$p.amount_max|fiat}">
      <label class="col-12 col-md-3" for="inpt_{$p.id}">
        <div class="icon"><img src="images/{$p.id}.gif" alt="{$p.name|escape:html}" title="{$p.name|escape:html}"></div>
        <div class="amount">
          <small>Balance:</small> <b style="color:{if $p.available > 0}green{else}gray{/if}">{$p.available|fiat:$p.ec}</b><br>
          {if $p.hold > 0}<small>On Hold:</small> <b style="color:black">{$p.hold|fiat:$p.ec}</b><br>{/if}
          <small>Pending:</small> <b style="color:{if $p.pending > 0}red{else}gray{/if}">{$p.pending|fiat:$p.ec}</b><br>
          <div style="overflow:scroll;height:35px;white-space:nowrap;"><i class="bi bi-wallet"></i> {if $p.account != ''}{$p.account|escape:html}{else}<a href="{"?a=edit_account"|encurl}"><i>not set</i></a>{/if}</div>
        </div>
      </label>
      {/if}
    {/foreach}
  </div>

  <br clear=all>
  <div class="row flex-column aos-init" data-aos="zoom-in">
    <div class="title text-center mt-3"><i class="bi bi-cash-coin"></i> Withdraw Amount</div>

    <div class="col-10 col-md-6 m-auto mb-3">
      <div class="form-floating">
        <input type="text" id="inpt_amount" name="amount" value="{$frm.amount|amount_format|default:"10.00"}" class="form-control" placeholder="Withdraw"
            data-v-min-val="0.000001" data-v-notice-min-val=""
            data-v-max-val="0" data-v-notice-max-val=""
            data-v-not-zerro="" data-v-notice-not-zerro="Please, enter an Amount"
        >
        <label for="inpt_amount"><i class="bi bi-cash-coin"></i> Amount</label>
        <div id="inpt_amount_err" class="invalid-feedback"></div>
      </div>
    </div>

    <div class="col-10 col-md-6 m-auto mb-3 aos-init" data-aos="zoom-in">
      <div class="form-floating">
        <textarea name=comment class="form-control">{$frm.comment|escape:html}</textarea>
        <label for="inpt_comment"><i class="bi bi-chat-text"></i> Comment</label>
      </div>
    </div>

    <div class="col-12 text-center">
      <input type=submit class="btn btn-primary" value="Withdraw">
    </div>

  </div>

{else}
{call name="alert" type="warning" text="You have no funds to withdraw."}
{/if}
</form>

{/if}

{/if}

{call name="content_end"}

{include file="footer.tpl"}
