// Initialize cart from localStorage or start with an empty array
let cart = JSON.parse(localStorage.getItem('cart')) || [];

// Function to render the cart
function renderCart() {
    const cartItemsContainer = document.getElementById('cart-items');
    const cartTotalsSection = document.querySelector('.cart_totals'); // Select the cart totals section
    cartItemsContainer.innerHTML = ''; // Clear previous content

    if (cart.length === 0) {
        cartItemsContainer.innerHTML = '<tr><td colspan="6"><p>Your cart is empty.</p></td></tr>';
        cartTotalsSection.style.display = 'none'; // Hide the cart totals section
        clearCheckoutData(); // Clear checkout data if cart is empty
        return;
    } else {
        cartTotalsSection.style.display = 'block'; // Show the cart totals section
    }

    cart.forEach((item, index) => {
        const cartItem = document.createElement('tr');
        cartItem.classList.add('woocommerce-cart-form__cart-item', 'cart_item');
        cartItem.innerHTML = `
            <td class="product-remove">
                <a href="#" class="remove" aria-label="Remove this item" onclick="removeFromCart(${index})">×</a>
            </td>
            <td class="product-thumbnail">
                <a href="${item.url}"><img src="${item.image}" alt="${item.product_name}" /></a>
            </td>
            <td class="product-name" data-title="Product">
                <a href="${item.url}">${item.product_name}</a>
            </td>
            <td class="product-price" data-title="Price">
                <span>$${item.price.toFixed(2)}</span>
            </td>
            <td class="product-quantity" data-title="Quantity">
                <div class="quantity sh-increase-numbers">
                    <div class="product-num-div-css">
                        <span class="sh-noselect sh-increase-number-down" onclick="decreaseQuantity(${index})">−</span>
                        <input type="number" class="sh-quantity-number" value="${item.quantity}" min="1" onchange="updateQuantity(${index}, this.value)">
                        <span class="sh-noselect sh-increase-number-up" onclick="increaseQuantity(${index})">+</span>
                    </div>
                </div>
            </td>
            <td class="product-subtotal" data-title="Subtotal">
                <span>$${(item.price * item.quantity).toFixed(2)}</span>
            </td>
        `;
        cartItemsContainer.appendChild(cartItem);
    });

    updateCartTotals();
}

// Function to update quantity based on user input
function updateQuantity(index, newQuantity) {
    const quantity = parseInt(newQuantity);
    if (quantity > 0) {
        cart[index].quantity = quantity;
        localStorage.setItem('cart', JSON.stringify(cart));
        renderCart();
    }
}

// Function to update cart totals
function updateCartTotals() {
    const subtotal = cart.reduce((sum, item) => sum + item.price * item.quantity, 0);
    const shipping = document.querySelector('input[name="shipping_method"]:checked').value === 'express' ? 60.00 : 19.80;
    const total = subtotal + shipping;

    document.getElementById('cart-subtotal').textContent = `$${subtotal.toFixed(2)}`;
    document.getElementById('cart-total').textContent = `$${total.toFixed(2)}`;
}

// Function to remove an item from the cart
function removeFromCart(index) {
    cart.splice(index, 1);
    localStorage.setItem('cart', JSON.stringify(cart));
    renderCart();
}

// Function to increase the quantity of a cart item
function increaseQuantity(index) {
    cart[index].quantity++;
    localStorage.setItem('cart', JSON.stringify(cart));
    renderCart();
}

// Function to decrease the quantity of a cart item
function decreaseQuantity(index) {
    if (cart[index].quantity > 1) {
        cart[index].quantity--;
        localStorage.setItem('cart', JSON.stringify(cart));
        renderCart();
    }
}

// Function to clear checkout data when cart is empty
function clearCheckoutData() {
    localStorage.removeItem('checkoutCartDetails');
    localStorage.removeItem('orderData');
}

// Event listener for shipping method change
document.querySelectorAll('input[name="shipping_method"]').forEach((input) => {
    input.addEventListener('change', updateCartTotals);
});

// Function to handle the "Proceed to Checkout" button click
document.getElementById('place_order').addEventListener('click', function(e) {
    e.preventDefault(); // Prevent form submission

    // Prepare the cart details to be stored for checkout
    const cartDetails = cart.map(item => ({
        product_name: item.product_name,
        quantity: item.quantity,
        subtotal: (item.price * item.quantity).toFixed(2)
    }));
    const cartSubtotal = cart.reduce((sum, item) => sum + item.price * item.quantity, 0).toFixed(2);
    const shippingMethod = document.querySelector('input[name="shipping_method"]:checked').value;
    const shippingCost = shippingMethod === 'flat_rate:16' ? 180.00 : 118.80;
    const cartTotal = (parseFloat(cartSubtotal) + shippingCost).toFixed(2);

    // Store the checkout details in localStorage
    localStorage.setItem('checkoutCartDetails', JSON.stringify({
        items: cartDetails,
        subtotal: cartSubtotal,
        shipping: shippingCost,
        total: cartTotal
    }));

    // Redirect to the checkout page
    window.location.href = "checkout.html";
});

// Initial render of cart
renderCart();
