﻿/*--------------------------------------------------------------
# Created by ColdCoders.com
--------------------------------------------------------------*/
(function() {
  "use strict";

  /**
   * Easy selector helper function
   */
  const select = (el, all = false) => {
    el = el.trim()
    if (all) {
      return [...document.querySelectorAll(el)]
    } else {
      return document.querySelector(el)
    }
  }

  /**
   * Easy event listener function
   */
  const on = (type, el, listener, all = false) => {
    let selectEl = select(el, all)
    if (selectEl) {
      if (all) {
        selectEl.forEach(e => e.addEventListener(type, listener))
      } else {
        selectEl.addEventListener(type, listener)
      }
    }
  }

  /**
   * Easy on scroll event listener 
   */
  const onscroll = (el, listener) => {
    el.addEventListener('scroll', listener)
  }

  /**
   * Navbar links active state on scroll
   */
  let navbarlinks = select('#navbar .scrollto', true)
  const navbarlinksActive = () => {
    let position = window.scrollY + 200
    navbarlinks.forEach(navbarlink => {
      if (!navbarlink.hash) return
      let section = select(navbarlink.hash)
      if (!section) return
      if (position >= section.offsetTop && position <= (section.offsetTop + section.offsetHeight)) {
        navbarlink.classList.add('active')
      } else {
        navbarlink.classList.remove('active')
      }
    })
  }
  window.addEventListener('load', navbarlinksActive)
  onscroll(document, navbarlinksActive)

  /**
   * Scrolls to an element with header offset
   */
  const scrollto = (el) => {
    let header = select('#header')
    let offset = header.offsetHeight

    let elementPos = select(el).offsetTop
    window.scrollTo({
      top: elementPos - offset,
      behavior: 'smooth'
    })
  }

  /**
   * Toggle .header-scrolled class to #header when page is scrolled
   */
  let selectHeader = select('#header')
  if (selectHeader) {
    const headerScrolled = () => {
      if (window.scrollY > 100) {
        selectHeader.classList.add('header-scrolled')
      } else {
        selectHeader.classList.remove('header-scrolled')
      }
    }
    window.addEventListener('load', headerScrolled)
    onscroll(document, headerScrolled)
  }

  /**
   * Back to top button
   */
  let backtotop = select('.back-to-top')
  if (backtotop) {
    const toggleBacktotop = () => {
      if (window.scrollY > 100) {
        backtotop.classList.add('active')
      } else {
        backtotop.classList.remove('active')
      }
    }
    window.addEventListener('load', toggleBacktotop)
    onscroll(document, toggleBacktotop)
  }

  /**
   * Mobile nav toggle
   */
  on('click', '.mobile-nav-toggle', function(e) {
    select('#navbar').classList.toggle('navbar-mobile')
    this.classList.toggle('bi-list')
    this.classList.toggle('bi-x')
  })

  on('click', '.copy-text', function(e) {
    var copyfrom = this.getAttribute('data-copy-from');
    if (copyfrom) {
      var selfrom = select(copyfrom);
      if (selfrom && (selfrom.type == 'text' || selfrom.type == 'textarea')) {
        selfrom.select();
        document.execCommand("copy");
        //selfrom.setSelectionRange(0,0);
        this.classList.remove('bi-clipboard')
        this.classList.add('bi-clipboard-check');
      }
    }
  }, true)

  /**
   * Preloader
   */
  let preloader = select('#preloader');
  if (preloader) {
    window.addEventListener('load', () => {
      preloader.remove()
    });
  }

  /**
   * Animation on scroll
   */
  window.addEventListener('load', () => {
    AOS.init({
      duration: 1000,
      easing: 'ease-in-out',
      once: true,
      mirror: false
    })
  });

  let error_alerts = select('.error-alert', true)
  const errorAlertsApply = () => {
    error_alerts.forEach(err => {
      let apply_to = err.getAttribute('data-error-apply')
      if (!apply_to) return
      let inpt = select('#inpt_'+apply_to)
      if (inpt) inpt.classList.add('is-invalid')

      let text = err.innerHTML
      let inpt_err = select('#inpt_'+apply_to+'_err')
      if (inpt_err && text) inpt_err.innerHTML = text
    })
  }
  window.addEventListener('load', errorAlertsApply)
  on('input', 'input,select,textarea', function(el, e) { this.classList.remove('is-invalid','is-valid')}, true)

  const errorMinMaxApply = (el) => {
     let amt_inpt = select('#inpt_amount')
     if (el.getAttribute('data-min-val')) {
       let minval = parseFloat(el.getAttribute('data-min-val'))
       if(isNaN(minval)) minval = 0.0000001;
       amt_inpt.setAttribute('data-v-min-val', minval)
       amt_inpt.setAttribute('data-v-notice-min-val', el.getAttribute('data-min-val-notice'))
     }
     if (el.getAttribute('data-max-val')) {
       let maxval = parseFloat(el.getAttribute('data-max-val'))
       if(isNaN(maxval)) maxval = 0;
       select('#inpt_amount').setAttribute('data-v-max-val', maxval)
       amt_inpt.setAttribute('data-v-notice-max-val', el.getAttribute('data-max-val-notice'))
     }

     if (el.getAttribute('data-min-dep-val')) {
       let minval = parseFloat(el.getAttribute('data-min-dep-val'))
       if(isNaN(minval)) minval = 0.0000001;
       amt_inpt.setAttribute('data-v-min-dep-val', minval)
       amt_inpt.setAttribute('data-v-notice-min-dep-val', el.getAttribute('data-min-dep-val-notice'))
     }
     if (el.getAttribute('data-max-dep-val')) {
       let maxval = parseFloat(el.getAttribute('data-max-dep-val'))
       if(isNaN(maxval)) maxval = 0;
       select('#inpt_amount').setAttribute('data-v-max-dep-val', maxval)
       amt_inpt.setAttribute('data-v-notice-max-dep-val', el.getAttribute('data-max-dep-val-notice'))
     }
  }
  window.addEventListener('load', function() {
    let el = select('form.minmaxamount input[type=radio]:checked', true)
    el.forEach(elm => { errorMinMaxApply(elm) })
  });
  on('input', 'form.minmaxamount input[type=radio]', function(el, e) { errorMinMaxApply(this); }, true)


  /**
   * Initiate Pure Counter 
   */
  new PureCounter();

  const checkform = (e) => {
    let form = e.target;
    var validated = 1;
    for (let i in form.elements) {
      if (i == 'namedItem') break;
      let f = form.elements[i];
      if (f.name) {
        f.classList.remove('is-valid', 'is-invalid');
        let err_div = document.getElementById(f.id+'_err'); if (!err_div) { continue; } else { err_div.innerHTML = null; }
        if (f.getAttribute('data-v-account') == 1 && f.value == '') continue;
        if (f.getAttribute('data-v-skip-empty') == 1 && f.value == '') continue;
        let funcs = ['not-empty','min-len','not-zerro','min-val','max-val','regexp','email','equiv-to','min-dep-val','max-dep-val'];
        for (let j in funcs) {
          let invalid = 0;
          let func = funcs[j];
          if (f.getAttribute('data-v-'+func) == null) continue;
          if (func == 'regexp' && f.value != '') {
            let re = new RegExp(f.getAttribute('data-v-regexp'));
            if (!f.value.match(re)) {
              invalid = 1;
            }
          } else if (func == 'email' && f.value != '') {
            var re = /^[^\@]+\@[^\@]+\.\w{2,10}$/;
            if (!f.value.match(re)) {
              invalid = 1;
            }
          } else if (func == 'not-empty') {
            if (f.type == 'checkbox' && f.checked == false) {
              invalid = 1;
            } else if (f.value == '') {
              invalid = 1;
            }
          } else if (func == 'min-len') {
            let min = f.getAttribute('data-v-min-len');
            let val = f.value.trim();
            if (val != '' && val.length < min) {
              invalid = 1;
            }
          } else if (func == 'not-zerro') {
            let val = parseFloat(f.value);
            if (isNaN(val) || val == 0) {
              invalid = 1;
            }
          } else if (func == 'min-val') {
            let min = parseFloat(f.getAttribute('data-v-min-val'));
            let val = parseFloat(f.value);
            if (!isNaN(min)) {
              if (isNaN(val) || val < min) {
                invalid = 1;
              }
            }
          } else if (func == 'max-val') {
            let max = parseFloat(f.getAttribute('data-v-max-val'));
            let val = parseFloat(f.value);
            if (!isNaN(max) && max > 0) {
              if (isNaN(val) || val > max) {
                invalid = 1;
              }
            }
          } else if (func == 'min-dep-val') {
            let min = parseFloat(f.getAttribute('data-v-min-dep-val'));
            let val = parseFloat(f.value);
            if (!isNaN(min)) {
              if (isNaN(val) || val < min) {
                invalid = 1;
              }
            }
          } else if (func == 'max-dep-val') {
            let max = parseFloat(f.getAttribute('data-v-max-dep-val'));
            let val = parseFloat(f.value);
            if (!isNaN(max) && max > 0) {
              if (isNaN(val) || val > max) {
                invalid = 1;
              }
            }
          } else if (func == 'equiv-to') {
            let equivto = f.getAttribute('data-v-equiv-to');
            if (equivto == '' || !form.elements[equivto]) { console.log('Form validation: '+equivto+' form elemnt was not found'); continue;}
            if (f.value != form.elements[equivto].value) {
              invalid = 1;
            }
          }
          if (invalid) {
            let notice = f.getAttribute('data-v-notice-'+func);
            f.classList.add('is-invalid');
            document.getElementById(f.id+'_err').innerHTML = notice;
            f.focus();
            validated = 0;
          } else {
            //f.classList.add('is-valid');
          }
        }
      }
    }
    if (!validated) {
      e.preventDefault();
      return false; 
    }
    return true;
  }
  on('submit', 'form.validate', checkform);

})()
/*--------------------------------------------------------------
# Created by ColdCoders.com
--------------------------------------------------------------*/