{include file="header.tpl" meta_tile="Dashboard"}

{call name="account_heading" title="Dashboard"}

{call name="content_start" section_id="account" center=1}

{loaddata name="user_notices" var=notices}
{if $notices}
{foreach from=$notices item=n}
{capture assign=note}
<div class="user_note">
<h4 class="alert-heading"><i class="bi bi-exclamation-circle-fill"></i> {$n.title}</h4>
<p>{$n.text|nl2br}</p>
<form method=post>
<input type=hidden name=a value=user_notices>
<input type=hidden name=action value=notified>
<input type=hidden name=id value={$n.id}>
<button type="submit" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</form>
</div>
{/capture}
{call name="alert" type="primary" dismissible=1 text=$note}
{/foreach}
{/if}

{if $settings.use_transaction_code ==1 && $userinfo.transaction_code == ''}
{capture assign=note}
<h4 class="alert-heading"><i class="bi bi-exclamation-triangle-fill"></i> Transaction Code is not activated</h4>
Currently you have not specified a Transaction Code. The Transaction code strengthens your funds security in our system.
The code is required for secure confirmation of operations with your funds.
Just do not change 'Transaction Code' in your account information if you do not want to use this feature.
<a class="alert-link" href={"?a=edit_account"|encurl}>Edit Account</a> to specify a new transaction code.
{/capture}
{call name="alert" type="warning" text=$note}
{/if}

{if $userinfo.tfa_not_enabled} 
{capture assign=note}
<h4 class="alert-heading"><i class="bi bi-exclamation-triangle-fill"></i> Security Note</h4>
Please, activate <a class="alert-link" href="{"?a=security"|encurl}">Two Factor Authentication</a> to keep your account safe.
{/capture}
{call name="alert" type="warning" text=$note}
{/if}


  <div class="row justify-content-start mb-3">

      <div class="user_common_info col-12 col-md-6 mb-3 d-flex align-items-stretch align-items-center">
        <div class="flex-fill content-frame text-start">
          <div class="title"><i class="bi bi-person-circle"></i> Welcome, {$userinfo.username|escape:html}</div>
          <dl class="row">
            <dt class="col-sm-4">Name:</dt>
            <dd class="col-sm-8">{$userinfo.name|escape:html}</dd>

            <dt class="col-sm-4">Member since:</dt>
            <dd class="col-sm-8">{$userinfo.create_account_date}</dd>

            <dt class="col-sm-4">Last Access:</dt>
            <dd class="col-sm-8">{$last_access|default:"n/a"}</dd>

            <dt class="col-sm-4">Last Access IP:</dt>
            <dd class="col-sm-8">{$last_ip|default:"n/a"}</dd>

            <dt class="col-sm-4">Upline:</dt>
            <dd class="col-sm-8">{$userinfo.ref_username|default:"<i>none</i>"}</dd>
          </dl>

          <div class="mt-3">
            <a href="{"?a=deposit"|encurl}" class="btn btn-deposit mb-3 me-3"><i class="bi bi-bag-plus pe-2"></i> Deposit</a>
            <a href="{"?a=withdraw"|encurl}" class="btn btn-withdraw mb-3"><i class="bi bi-cash-coin pe-2"></i> Withdraw</a>
          </div>
        </div>
      </div>

      <div class="user_balance_info col-12 col-md-6 mb-3 d-flex align-items-stretch align-items-center">
        <div class="flex-fill content-frame text-start">
          <div class="title"><i class="bi bi-cash-stack"></i> Your Balance</div>
          <dl class="row">
            <dt class="col-sm-6 text-end">Total Balance:</dt>
            <dd class="col-sm-6 text-start">{$userinfo.balance_totals.balance|fiat}</dd>
          </dl>

          <div class="row justify-content-center">
          {foreach from=$userinfo.balances item=p key=ec}
            <div class="col-6 col-md-4 fiat_amount">
              <div class="icon"><img src="images/{$ec}.gif"></div>
              <div class="amount">{$p.balance|fiat:$ec}</div>
            </div>
          {/foreach}
          </div>
        </div>
      </div>

      <div class="user_referrals_info col-12 col-md-6 mb-3 d-flex align-items-stretch align-items-center">
        <div class="flex-fill content-frame text-start">
          {loaddata name="user_referrals" total_direct_referrals=1 total_commissions=1 var=ref}
          <div class="title"><i class="bi bi-diagram-3-fill"></i> Referrals</div>
          <dl class="row">
            <dt class="col-sm-4">Total:</dt>
            <dd class="col-sm-8">{$ref.total_direct_referrals}</dd>

            <dt class="col-sm-4">Commissions:</dt>
            <dd class="col-sm-8">{$ref.total_commissions|fiat}</dd>

            <dt class="col-sm-4">Your Link:</dt>
            <dd class="col-sm-8"><input type="text" class="form-control" id="relink" readonly value="{"?ref=`$userinfo.username`"|encurl:0:1}" style="width:95%;display:inline-block;"> <i class="copy-text bi bi-clipboard ps-2" data-copy-from="#relink"></i></dd>

          </dl>

          <div class="mt-3">
            <a href="{"?a=referals"|encurl}" class="btn btn-info mb-3 me-3"><i class="bi bi-person-lines-fill pe-2"></i> Referrals</a>
            <a href="{"?a=referallinks"|encurl}" class="btn btn-warning mb-3 me-3"><i class="bi bi-aspect-ratio-fill pe-2"></i> Banners</a>
          </div>
        </div>
      </div>

      <div class="user_deposits_info col-12 col-md-6 mb-3 d-flex align-items-stretch align-items-center">
        <div class="flex-fill content-frame text-start">
          <div class="title"><i class="bi bi-wallet-fill"></i> Deposits</div>
          <dl class="row">
            <dt class="col-sm-4">Active:</dt>
            <dd class="col-sm-8">{$userinfo.balance_totals.active_deposit|fiat}</dd>

            <dt class="col-sm-4">Total:</dt>
            <dd class="col-sm-8">{$userinfo.balance_totals.deposit|fiat}</dd>

            {loaddata name="user_last_deposit" var=last}
            <dt class="col-sm-4">Last:</dt>
            <dd class="col-sm-8">{if $last}{$last.amount|fiat:$last.ec}</b> &nbsp; <small>{$last.date|default:"n/a"}</small>{else}<i>n/a</i>{/if}</dd>
          </dl>

          <div class="mt-3">
            <a href="{"?a=deposit_list"|encurl}" class="btn btn-deposit mb-3 me-3"><i class="bi bi-wallet-fill pe-2"></i> Active Deposits</a>
          </div>
        </div>
      </div>

      <div class="user_earnings_info col-12 col-md-6 mb-3 d-flex align-items-stretch align-items-center">
        <div class="flex-fill content-frame text-start">
          <div class="title"><i class="bi bi-rocket-takeoff-fill"></i> Earnings</div>
          <dl class="row">
            <dt class="col-sm-4">Total:</dt>
            <dd class="col-sm-8">{$userinfo.balance_totals.earning|fiat}</dd>
            {loaddata name="user_today_earnings" var=ern}
            <dt class="col-sm-4">Today:</dt>
            <dd class="col-sm-8">{$ern.earning_amount|fiat}</dd>

            {loaddata name="user_last_earning" var=last}
            <dt class="col-sm-4">Last:</dt>
            <dd class="col-sm-8">{if $last}{$last.amount|fiat:$last.ec}</b> &nbsp; <small>{$last.date|default:"n/a"}</small>{else}<i>n/a</i>{/if}</dd>
          </dl>

          <div class="mt-3">
            <a href="{"?a=history"|encurl}" class="btn btn-info mb-3 me-3"><i class="bi bi-list-ul pe-2"></i> Transactions</a>
          </div>

        </div>
      </div>

      <div class="user_withdrawals_info col-12 col-md-6 mb-3 d-flex align-items-stretch align-items-center">
        <div class="flex-fill content-frame text-start">
          <div class="title"><i class="bi bi-cash-coin"></i> Withdrawals</div>
          <dl class="row">
            <dt class="col-sm-4">Pending:</dt>
            <dd class="col-sm-8">{$userinfo.balance_totals.withdraw_pending|fiat}</dd>

            <dt class="col-sm-4">Total:</dt>
            <dd class="col-sm-8">{$userinfo.balance_totals.withdrawal|fiat}</dd>

            {loaddata name="user_last_withdrawal" var=last}
            <dt class="col-sm-4">Last:</dt>
            <dd class="col-sm-8">{if $last}{$last.amount|fiat:$last.ec}</b> &nbsp; <small>{$last.date|default:"n/a"}</small>{else}<i>n/a</i>{/if}</dd>
          </dl>

          <div class="mt-3">
            <a href="{"?a=withdraw"|encurl}" class="btn btn-withdraw mb-3 me-3"><i class="bi bi-cash-coin pe-2"></i> Withdraw</a>
          </div>

        </div>
      </div>

  </div>


{foreach from=$ps item=p}
  {if $p.pending_col > 0}{$p.pending_col} {$p.name} deposit{if $p.pending_col > 1}s{/if} of {$p.pending_amount|fiat} total pending<br>{/if}
{/foreach}

{call name="content_end"}

{include file="footer.tpl"}