{include file="header.tpl" meta_tile="Currency Exchange"}

{call name="account_heading" title="Currency Exchange"}

{call name="content_start" section_id="account" center=1}

{literal}
<script>
var balances = [];
var pow = [];
{/literal}
                                                                                                 
var currencies = [{foreach from=$ec item=i name=ec}'{$i.ec}'{if !$smarty.foreach.ec.last},{/if}{/foreach}];
var curs = [{foreach from=$exchange item=i name=ec}'{$i.from}'{if !$smarty.section.ec.last},{/if}{/foreach}];

{foreach from=$ec item=i}
balances[{$i.ec}] = parseFloat('{$i.balance}');
{/foreach}

var exchange = [];
var rates = [];
var pow = [];
{foreach from=$exchange item=e}
exchange[{$e.from}] = [];
rates[{$e.from}] = [];
pow[{$e.from}] = parseFloat('{$e.pow}');
{foreach from=$e.tos item=t}
exchange[{$e.from}][{$t.to}] = parseFloat('{$t.percent}');
rates[{$e.from}][{$t.to}] = parseFloat('{$t.rate}');
{/foreach}
{/foreach}

{literal}
function in_out(bForce) {

  var from_obj = document.querySelector('input[name="from"]:checked');
  if (!from_obj) return;
  var from_id = from_obj.value;

  var to_obj = document.querySelector('input[name="to_'+from_id+'"]:checked');
  if (!to_obj) {
    document.getElementById('inpt_estimate').value = '0';
    return;
  }
  var to_id = to_obj.value;

  var amount = parseFloat(document.getElementById('inpt_amount').value.replace(",","."));
  if (isNaN(amount)) amount = 0;

  if (!to_id || amount <= 0) {
    document.getElementById('inpt_estimate').value = 0;
    return false;
  }

  var percent = Math.round(exchange[from_id][to_id] * 100) / 10000;
  var estimate = (rates[from_id][to_id] * amount).toFixed(pow[to_id]);

  document.getElementById('inpt_estimate').value = estimate;

  if (bForce) {
    out_in();
  }
}

function out_in(bForce) {
  var from_obj = document.querySelector('input[name="from"]:checked');
  if (!from_obj) return;
  var from_id = from_obj.value;

  var to_obj = document.querySelector('input[name="to_'+from_id+'"]:checked');
  if (!to_obj) {
    document.getElementById('inpt_estimate').value = '0';
    return;
  }
  var to_id = to_obj.value;

  var estimate = parseFloat(document.getElementById('inpt_estimate').value.replace(",","."));
  if (isNaN(estimate)) estimate = 0;

  if (!to_id || amount <= 0) {
    document.getElementById('inpt_amount').value = 0;
    return false;
  }

  var percent = Math.round(exchange[from_id][to_id] * 100) / 10000;
  var amount = (estimate / rates[from_id][to_id]).toFixed(pow[from_id]);

  document.getElementById('inpt_amount').value = amount;

  if (bForce) {
    in_out();
  }
}

function update_tos() {

  var from_obj = document.querySelector('input[name="from"]:checked');
  var from_id = from_obj.value;

  var tos = document.querySelectorAll('.tos');
  tos.forEach(e => {
    var rds = e.querySelectorAll('input[type="radio"]');
    rds.forEach(r => {
      r.required = (e.id == 'to_opts_'+from_id) ? true : false
    });
    e.style.display = (e.id == 'to_opts_'+from_id) ? 'block' : 'none'
  });
  in_out();
}
</script>
{/literal}

{if $frm.display == "ok"}{call name="alert" type="success" text="Exchange has been successfully completed"}{/if}

{if $errors.no_from}{call name="alert" text="No source currency is specified"}{/if}
{if $errors.no_to}{call name="alert" text="No destination currency is specified"}{/if}
{if $errors.no_amount}{call name="alert" text="No exchange amount is specified"}{/if}
{if $errors.not_enough_funds}{call name="alert" text="You have insufficient funds to do the exchange"}{/if}
{if $errors.exchange_forbidden}{call name="alert" text="The exchange for specified currencies is not allowed"}{/if}
{if $errors.too_small_amount}{call name="alert" text="The amount you have entered for exchange is too small"}{/if}

{if $ec}
<form method=post class="validate minmaxamount" name="exchange_form">
<input type="hidden" name="a" value="exchange">
<input type="hidden" name="action" value="preview">
<input type="hidden" name="display" value="">

  <div class="balance_select row justify-content-center mb-3 aos-init" data-aos="fade-up">
    {assign var="wfch" value=1}
    {foreach from=$ec item=p}
      <input type="radio" name="from" value="{$p.id}" id="inpt_{$p.id}" data-fiat="{$p.fiat}" onchange="update_tos()" required
               {if $frm.from == $p.id || $wfch}{assign var="wfch" value=0}checked{/if}
               data-max-val="{$p.balance}" data-max-val-notice="Maximal exchange amount for {$p.name} is {$p.balance|fiat:$p.ec}">

      <label class="col-12 col-md-2" for="inpt_{$p.id}">
        <div class="icon"><img src="images/{$p.id}.gif" alt="{$p.ec_name|escape:html}" title="{$p.ec_name|escape:html}"></div>
        <div class="amount">
          <small>Balance:</small> <b style="color:green">{$p.balance|fiat:$p.ec}</b><br>
        </div>
      </label>
    {/foreach}
  </div>

  <div class="col-10 col-md-6 m-auto mb-3">
    <div class="form-floating">
      <input type="text" id="inpt_amount" name="amount" value="{$frm.amount|default:0|escape:html}" class="form-control" placeholder="Exchange Amount" oninput="in_out()"
            data-v-min-val="0.000001" data-v-notice-min-val=""
            data-v-max-val="0" data-v-notice-max-val=""
            data-v-not-zerro="" data-v-notice-not-zerro="Please, enter Amount">
      <label for="inpt_amount"><i class="bi bi-cash-coin"></i> Exchange Amount</label>
      <div id="inpt_amount_err" class="invalid-feedback"></div>
    </div>
  </div>

{foreach from=$ec item=f name=to}
  <div id="to_opts_{$f.id}" class="tos balance_select row justify-content-center mb-3" style="display:none">
    {foreach from=$f.tos item=t}
      <input type="radio" name="to_{$f.id}" value="{$t.id}" id="inpt_{$f.id}_{$t.id}" data-fiat="{$t.fiat}" {if $t.disabled}disabled{/if} onchange="in_out()">
      <label class="col-12 col-md-2" for="inpt_{$f.id}_{$t.id}">
        <div class="icon"><img src="images/{$t.id}.gif" alt="{$t.ec_name|escape:html}" title="{$t.ec_name|escape:html}"></div>
        <div class="amount">
          {if $t.disabled}Disabled{else}<small>Fee:</small> <b style="color:{if $t.percent <= 0}green{else}red{/if}">{$t.percent|abs}%</b>{/if}<br>
        </div>
      </label>
    {/foreach}
  </div>
{/foreach}

  <div class="col-10 col-md-6 m-auto mb-3">
    <div class="form-floating">
      <input type="text" id="inpt_estimate" name="estimate" value="0" class="form-control" placeholder="Estimate Receive Amount" oninput="out_in()">
      <label for="inpt_estimate"><i class="bi bi-cash-coin"></i> Estimate Receive Amount</label>
      <div id="inpt_estimate_err" class="invalid-feedback"></div>
    </div>
  </div>

  <div class="col-12 text-center">
    <input type=submit class="btn btn-primary" value="Exchange">
  </div>
</form>
{literal}
<script>update_tos();in_out()</script>
{/literal}
{else}
{call name="alert" type="warning" text="Currently you have no funds to exchange"}
{/if}

{call name="content_end"}

{include file="footer.tpl"}