{include file="header.tpl" meta_tile="Internal Transfer"}

{call name="account_heading" title="Internal Transfer"}

{call name="content_start" section_id="account" center=1}

{if $say == 'processed'}
{call name="alert" type="success" text="<b>Internal transfer has been successfully completed</b>"}
{/if}

{if $fatals}

{if $fatals.forbidden}
{call name="alert" text="Internal transfers are forbidden"}
{/if}
{if $fatals.no_deposits}
{call name="alert" text="You can not send funds before you make any deposit"}
{/if}
{if $fatals.times_limit}
{call name="alert" text="You can send internal transfer `$settings.limit_transfer_period_times` per `$settings.limit_transfer_period_date` only"}
{/if}

{else}

{if $errors}
{if $errors.turing_image}
{call name="alert" text="Invalid turing image"}
{/if}
{if $errors.user_not_found}
{call name="alert" text="The recipient's username entered has not been found or has been suspended"}
{/if}
{if $errors.less_min}
{call name="alert" text="You can transfer the amount not less `$errors.less_min` only"}
{/if}
{if $errors.too_big_amount}
{call name="alert" text="Insufficient funds"}
{/if}
{if $errors.too_big_amount_plus_fee}
{capture assign=note}You have no enough funds to complte the transaction. Total amount you should have to send {$frm.amount|fiat:$frm.ec} + fee is <b>{$errors.too_big_amount_plus_fee}</b>{/capture}
{call name="alert" text=$note}
{/if}
{if $errors.greater_max}
{call name="alert" text="Maximum amount you can send is `$errors.greater_max`"}
{/if}
{if $errors.invalid_transaction_code}
{call name="alert" text="Invalid Transaction Code"}
{/if}
{if $errors.invalid_tfa_code}
{call name="alert" text="You have entered invalid 2FA code"}
{/if}
{/if}

{if $preview}

<form method=post name="internal_transfer_confirm" class="validate">
<input type=hidden name=a value=internal_transfer>
<input type=hidden name=action value=confirm>
<input type=hidden name=amount value="{$amount}">
<input type=hidden name=account value="{$user.username|escape:html}">
<input type=hidden name=ec value="{$ec}">
<input type=hidden name=comment value="{$comment|escape:html}">

<table class="table table-responsive table-striped align-middle form-list">
<tr>
 <th>Payment System:</th>
 <td>{$currency}</td>
</tr>
<tr>
 <th>Recipient:</th>
 <td>{$user.username|escape:html}</td>
</tr>
<tr>
 <th>Fee:</th>
 <td>
{if $fee > 0}
  {$settings.internal_transfer_fee}% (min. {$minimum_internal_transfer_fee|fiat:$ec})
{else}
We have no fee for this operation.
{/if}
</td>
</tr>
<tr>
 <th>Debit Amount:</th>
 <td>{$to_send|fiat:$ec}</td>
</tr>
<tr>
 <th>Credit Amount:</th>
 <td>{$to_receive|fiat:$ec}</td>
</tr>
{if $comment}
<tr>
 <th>With comments:</th>
 <td>{$comment|escape:html}</th>
</tr>
{/if}
{if $settings.use_transaction_code && $userinfo.transaction_code}
<tr>
 <th>Transaction Code:</th>
 <td><input type="password" name="transaction_code" class=inpts size=15></td>
</tr>
{/if}
{include file="captcha.tpl" action="internal_transfer"}
{if $userinfo.tfa_settings.withdraw}
<tr>
 <th>2FA Code:</th>
 <td><input type="text" name="tfa_code" class=inpts size=15> <input type="hidden" name="tfa_time" id="tfa_time"></td>
</tr>
{literal}
<script language=javascript>
document.getElementById('tfa_time').value = (new Date()).getTime();
</script>
{/literal}
{/if}
</table>

  <div class="col-12 text-center">
    <input type=submit class="btn btn-success" value="Confirm">
    <input type=submit class="btn btn-warning" name="action" value="Cancel">
  </div>

</form>

{else}

<form method=post name="internal_transfer" class="validate">
<input type=hidden name=a value=internal_transfer>
<input type=hidden name=action value=preview>
<input type=hidden name=say value="">

{if $have_available}

  <div class="title text-center"><i class="bi bi-cash-stack"></i> Select Payment System</div>

  <div class="balance_select row justify-content-center mb-3">
  {assign var="wfch" value=1}
  {foreach from=$ps item=p}
    {if $p.available > 0}
    <input type="radio" name="ec" value="{$p.id}" id="inpt_{$p.id}" data-fiat="{$p.fiat}" required {if $frm.ec == $p.id || $wfch}{assign var="wfch" value=0}checked{/if}>
    <label class="col-3 col-md-2" for="inpt_{$p.id}">
      <div class="icon"><img src="images/{$p.id}.gif" alt="{$p.name|escape:html}" title="{$p.name|escape:html}"></div>
      <div class="amount">
        <small>Balance:</small> <b>{$p.available|fiat:$p.ec}</b><br>
        {if $p.hold > 0}<small>On Hold:</small> <b style="color:black">{$p.hold|fiat:$p.ec}</b><br>{/if}
      </div>
    </label>
    {/if}
  {/foreach}
  </div>

  <br clear=all>
  <div class="title text-center mt-3"><i class="bi bi-cash-coin"></i> Transfer</div>
  <div class="row">
  {call name="user_field" title="Amount" fname="amount" value=$frm.amount|amount_format|default:"10.00" icon="cash-coin" validate=[['func'=>'not-zerro','notice'=>'Please, enter Amount']]}

  {call name="user_field" title="Recipient" fname="account" icon="person-circle" validate=[['func'=>'not-empty','notice'=>'Please, enter Recipient Username'],['func'=>'regexp','param'=>'^[A-Za-z0-9_\-]+$','notice'=>'Please, use English letters and digits only for Recipient Username']]}

  {call name="user_field" type="textarea" title="Comment" fname="comment" icon="chat-text" colmd=12}
  </div>
  <div class="col-12 text-center">
    <input type=submit class="btn btn-primary" value="Send">
  </div>
</form>

{else}
{call name="alert" type="warning" text="You have no funds to withdraw."}
{/if}


{/if}

{/if}

{call name="content_end"}

{include file="footer.tpl"}
