{include file="header.tpl" meta_title="Signup"}

{call name="page_heading" title="Registration" slogan="Fill the signup form to create account on our program."}

{call name="content_start" section_id="signup" center=1}


{if $deny_registration}
{call name="alert" text="We are closed for new registrations now."}
{elseif $settings.use_referal_program && $settings.force_upline && !$referer.id && !$settings.get_rand_ref}
{call name="alert" text="You do not have an upline. Our system require an upline to do registration."}
{else}

{if $errors}
{if $errors.turing_image}{call name="alert" text="Invalid turing image" field_id="validation_number"}{/if}
{if $errors.ip_exists_in_database}{call name="alert" text="Your IP has been used already. Sorry, but registration impossible"}{/if}
{if $errors.no_fullname}{call name="alert" text="Please enter your full name" field_id="username"}{/if}
{if $errors.invalid_username}{call name="alert" text="Please enter valid username! It should contains English letters and digits only" field_id="username"}{/if}
{if $errors.username_too_short}{call name="alert" text="Username should contains `$errors.username_too_short` charaters at least" field_id="username"}{/if}
{if $errors.username_exists}{call name="alert" text="The Username is already taken. Please try another Username." field_id="username"}{/if}
{if $errors.no_password}{call name="alert" text="Please define a password" field_id="password"}{/if}
{if $errors.password_confirm}{call name="alert" text="Please confirm your password correctly" field_id="password2"}{/if}
{if $errors.password_too_small}{call name="alert" text="The password you provided is too small, please enter at least `$errors.password_too_small` characters!" field_id="password"}{/if} 
{if $errors.invalid_email}{call name="alert" text="Please valid email address" field_id="email"}{/if} 
{if $errors.email_confirm}{call name="alert" text="Please confirm your email address correctly" field_id="email"}{/if}
{if $errors.email_exists}{call name="alert" text="An account with this email is already exist" field_id="email"}{/if}
{if $errors.no_address}{call name="alert" text="Please enter your address" field_id="address"}{/if}
{if $errors.no_city}{call name="alert" text="Please enter your city" field_id="city"}{/if}
{if $errors.no_state}{call name="alert" text="Please enter your state" field_id="state"}{/if}
{if $errors.no_zip}{call name="alert" text="Please enter your zip" field_id="zip"}{/if}
{if $errors.no_country}{call name="alert" text="Please enter your country" field_id="country"}{/if}
{if $errors.no_transaction_code}{call name="alert" text="Please define a transaction code" field_id="transaction_code"}{/if}
{if $errors.transaction_code_confirm}{call name="alert" text="Please correcty confirm your transaction code" field_id="transaction_code2"}{/if}
{if $errors.transaction_code_too_small}{call name="alert" text="The transaction code you provided is too small, please enter at least `$errors.transaction_code_too_small` characters!" field_id="transaction_code"}{/if} 
{if $errors.transaction_code_vs_password}{call name="alert" text="The Transaction Code should not be equal to the Password you have defined" field_id="transaction_code"}{/if}
{if $errors.no_agree}{call name="alert" text="You have to agree with the Terms and Conditions!" field_id="agree"}{/if}
{if $errors.no_upline}{call name="alert" text="You should have an upline to make registration"}{/if}
{if $errors.invalid_account_format}
 {foreach from=$errors.invalid_account_format item=err key=pid}
 {call name="alert" text=$err field_id="pa_`$pid`"}
 {/foreach}
{/if}
{/if} 

<form method=post name="regform" class="validate">
<input type=hidden name=a value="signup">
<input type=hidden name=action value="signup">

<div class="row">
  {call name="user_field" title="Full Name" fname="fullname" icon="person" validate=[['func'=>'not-empty','notice'=>'Please, enter Full Name']]}
  {call name="user_field" title="Username"  fname="username" icon="person-circle"  validate=[['func'=>'not-empty','notice'=>'Please, enter Username'],['func'=>'min-len','param'=>$settings.min_username_length,'notice'=>"Username should contains `$settings.min_username_length` charaters at least"],['func'=>'regexp','param'=>'^[A-Za-z0-9_\-]+$','notice'=>'Please, use English letters and digits only for Username']]}
</div>

{if $settings.use_user_location}
<div class="row">
  {if $settings.use_user_location == 1}{$val_func = 'not-empty'}{/if}
  {call name="user_field" title="Address" fname="address" icon="globe2" validate=[['func'=>$val_func,'notice'=>'Please, enter Address']]}
  {call name="user_field" title="City" fname="city" icon="globe2" validate=[['func'=>$val_func,'notice'=>'Please, enter Address']]}
  {call name="user_field" title="State" fname="state" icon="globe2" validate=[['func'=>$val_func,'notice'=>'Please, enter State']]}
  {call name="user_field" title="ZIP" fname="zip" icon="globe2" validate=[['func'=>$val_func,'notice'=>'Please, enter Zip']]}
  {call name="user_field" title="Country" fname="country" icon="globe2" type="country" validate=[['func'=>$val_func,'notice'=>'Please, enter Contry']]}
</div>
{/if}

<div class="row">
  {call name="user_field" title="Define Password" fname="password" icon="lock" type="password" validate=[['func'=>'not-empty','notice'=>'Please, enter Password'],['func'=>'min-len','param'=>$settings.min_user_password_length,'notice'=>"Password should contains `$settings.min_user_password_length` charaters at least"]]}
  {call name="user_field" title="Retype Password" fname="password2" icon="lock" type="password" validate=[['func'=>'equiv-to','param'=>'password','notice'=>'Please retype Password correctly']]}
</div>
{if $settings.use_transaction_code}
<div class="row">
  {call name="user_field" title="Define Transaction Code" fname="transaction_code" icon="lock-fill" type="password" validate=[['func'=>'not-empty','notice'=>'Please, enter Transaction Code'],['func'=>'min-len','param'=>$settings.min_transaction_code_length,'notice'=>"Transaction Code should contains `$settings.min_transaction_code_length` charaters at least"]]}
  {call name="user_field" title="Retype Transaction Code" fname="transaction_code2" icon="lock-fill" type="password" validate=[['func'=>'equiv-to','param'=>'transaction_code','notice'=>'Please retype Transaction Code correctly']]}
</div>
{/if}

<div class="row">
{foreach from=$pay_accounts item=ps}
  {call name="account_field" fname=$ps.name id=$ps.id account=$ps.account|escape:html validate=$ps.validate}
{/foreach}
{foreach item=p from=$mpay_accounts}
{foreach item=ps from=$p.accounts}
  {call name="account_field" fname=$p.name title=$ps.name id=$p.id subname=$ps.name|escape:html account=$ps.value|escape:html}
{/foreach}
{/foreach}
</div>

<div class="row">
  {call name="user_field" title="E-mail Address" fname="email" icon="envelope-at" validate=[['func'=>'not-empty','notice'=>'Please, enter Email address'],['func'=>'email','notice'=>'Please, enter valid email address']]}
  {call name="user_field" title="Retype E-mail" fname="email1" icon="envelope-at" validate=[['func'=>'equiv-to','param'=>'email','notice'=>'Please retype Email correctly']]}
</div>
<div class="row">
  {call name="user_field" title="Secret Question" fname="sq" icon="question-circle"}
  {call name="user_field" title="Secret Answer" fname="sa" icon="question-circle-fill"}
</div>

{if $settings.use_referal_program}
{if $referer}
<div class="row">
    <div class="col-12  mb-3">
      <div class="form-floating">
        <input type="text" id="inpt_upline" value="Your Upline: {$referer.name} ({$referer.username|escape:html})" class="form-control" readonly>
      </div>
    </div>
</div>
{else}
  {if $settings.force_upline}
<div class="row row-cols-1 mb-2">
    <div class="col">
          {if $settings.get_rand_ref}
            <label>You do not have an upline. Our system requires an upline for each user. You'll have to agree to get a random one or find a referral link on the net.</label>
            <input type=checkbox name="rand_ref" value=1>
          {else}
            <label>You do not have an upline. Our system requires an upline for each user.</label>
          {/if}
    </div>
</div>
  {/if}
{/if}
{/if}

{include file="captcha.tpl" action="signup"}

  <div class="col-12 mb-3">
    <input class="form-check-input" id="inpt_agree" type=checkbox name="agree" value=1 {if $frm.agree}checked{/if}  data-v-not-empty="" data-v-notice-not-empty="You have to agree with the Terms and Conditions!">
    <label class="form-check-label" for="inpt_agree">I agree with <a href="{"?a=rules"|encurl}">Terms and conditions</a></label>
    <div id="inpt_agree_err" class="invalid-feedback"></div>
  </div>

  <div class="col-12">
    <input type=submit class="btn btn-primary" value="Register">
  </div>
</form>
{/if}

{call name="content_end"}

{include file="footer.tpl"}
