{include file="header.tpl" meta_tile="Release Deposit"}

{call name="account_heading" title="Release Deposit"}

{call name="content_start" section_id="account" center=1}

{if $fatal}
 {if $fatal == 'deposit_not_found'}{call name="alert" text="Invalid deposit ID has been provided"}{/if} 
 {if $fatal == 'withdraw_forbidden'}{call name="alert" text="Can not process principal withdrawal for this plan"}{/if}
 {if $fatal == 'too_early_withdraw'}{call name="alert" text="Can not process principal withdrawal yet"}{/if}
 {if $fatal == 'too_late_withdraw'}{call name="alert" text="Can not process principal withdrawal longer"}{/if}
 {if $fatal == 'withdraw_complete'}
   {capture assign=note}<b>Deposit Release has been sucessfully completed</b><br><a href="{"?a=deposit_list"|encurl}">Return to Deposits</a>{/capture}
   {call name="alert" type="success" text=$note}
 {/if}
{else}
 {if $say == 'too_big_amount'}{call name="alert" text="You have no such amount on this deposit"}{/if}
 {if $say == 'too_small_amount'}{call name="alert" text="Provided amount is too small"}{/if}

{if $preview == 1}

<form method=post name=withdraw_form>
<input type=hidden name=a value=withdraw_principal>
<input type=hidden name=action value=withdraw>
<input type=hidden name=deposit value={$deposit.id}>
<input type=hidden name=amount value={$amount}>

<table class="table table-responsive table-striped align-middle form-list">
<tr>
 <th>Deposit Amount</th>
 <td>{$deposit.deposit|fiat:$deposit.ec}</td>
</tr>
<tr>
 <th>Deposit Plan</th>
 <td>{$type.name|escape:html}</td>
</tr>
<tr>
 <th>Release Amount</th>
 <td>{$amount|fiat:$deposit.ec}</td>
</tr>
<tr>
 <th>Fee</th>
 <td>{$fee|fiat:$deposit.ec} ({$type.withdraw_principal_percent}%)</td>
</tr>
<tr>
 <th>Receive Amount</th>
 <td><b>{$to_balance|fiat:$deposit.ec}</b></td>
</tr>
</table>
<input type=submit value="Confirm" class="btn btn-danger">
</form>

{else}

<script>
var max_amount = new Number('{$deposit.deposit}');
var percent = new Number('{$type.withdraw_principal_percent}');
var currency_pow = 8;

{literal}
function withdraw() {
  if (!document.withdraw_form.amount) return;
  var out_val = new Number(document.withdraw_form.amount.value.replace(",","."));
  if (isNaN(out_val))
  { out_val = 0; }
  out_val = out_val;

  if (out_val > max_amount) {
    out_val = max_amount;
    document.withdraw_form.amount.value = out_val.toFixed(currency_pow);
  }

  if (out_val < 0) {
    document.withdraw_form.amount.value = '';
    document.withdraw_form.quote.value = 0;
  } else {
    var fee = out_val * (percent/ 100);
    if (fee <= 0) fee = 0;
    out_val = out_val - fee;
    if (out_val < 0) out_val = 0;
    document.withdraw_form.quote.value = out_val.toFixed(currency_pow);
  }
}
{/literal}
</script>

<form method=post name=withdraw_form>
<input type=hidden name=a value=withdraw_principal>
<input type=hidden name=action value=withdraw_preview>
<input type=hidden name=deposit value={$deposit.id}>

<table class="table table-responsive table-striped align-middle form-list">
<tr>
 <th>Deposit Plan</th>
 <td>{$type.name|escape:html}</td>
</tr>
<tr>
 <th>Deposit Amount</th>
 <td>{$deposit.deposit|fiat:$deposit.ec}</td>
</tr>
<tr>
 <th>Deposit Earned</th>
 <td>{$deposit.earned|fiat:$deposit.ec}</td>
</tr>
<tr>
 <th>Fee</th>
 <td>{$type.withdraw_principal_percent}%</td>
</tr>
{if $type.withdraw_principal_full}
<tr>
 <th>Release Amount:</td>
 <td>{$deposit.deposit|fiat:$deposit.ec}</td>
</tr>
{else}
<tr>
 <th>Release Amount ({fiat ec=$deposit.ec}):</td>
 <td><input type=text name=amount value="{$deposit.deposit}" class="form-control" oninput="withdraw()"
      onfocusout="withdraw()" onactivate="withdraw()" ondeactivate="withdraw()"></td>
</tr>
<tr>
 <th>Receive Amount ({fiat ec=$deposit.ec}):</th>
 <td><input type=text name=quote readonly class="form-control"></td>
</tr>
{/if}
</table>
<input type=submit value="Release Deposit" class="btn btn-danger">
<input type=button value="Cancel" onclick="history.go(-1)" class="btn btn-warning">
</form>

<script>
withdraw();
</script>
{/if}
{/if}

{call name="content_end"}

{include file="footer.tpl"}