function initialiseCrossChainAnimation(){

    //variables
    listAmount = $('.crosschain-lines li').length;

    setInterval(function(){

        //variables
        var randomList = Math.floor(Math.random() * listAmount-1);
        var randomIcon = crosschainIcons[Math.floor(Math.random() * crosschainIcons.length)];

        var icon = $('<div class="crosschain-icon" data-crosschain-icon="'+randomIcon+'"></div>');

        $('.crosschain-lines li').eq(randomList).prepend(icon);

        setTimeout(function(){

            $(icon).remove();

        }, 7500)

    }, 2000)

}

function toggleDappMode(ev){

    //variables
    var dappMode = $(ev).attr('data-dapp-mode');

    $(ev).parent('div').find('.active').removeClass('active')
    $(ev).addClass('active')
    $('.dapp-preview').attr('data-dapp-mode', dappMode)

}

function initialiseStarParticles(){

    setInterval(function(){

        $('.star-particles').show();

        setTimeout(function(){

            $('.star-particles').hide();

        }, 700)

    }, 5000)

}

function initialiseAuditLaser(){

    setInterval(function(){

        var randTrigger = Math.floor(Math.random() * 3);

        if(randTrigger == '0'){

                 //show laser
                $('.laser').show();

                setTimeout(function(){

                //show explode
                $('.audit-orb-explode').show();
                shakeOrb();

                }, 60)

                setTimeout(function(){

                    $('.audit-orb-explode').fadeOut(400);

                }, 300)

                setTimeout(function(){

                    //hide laser
                    $('.laser').hide();

                }, 500)

        }

    }, 700);

}

function shakeOrb(){
    scaleOrb = '1';
    if($('.mobile-beacon').is(':visible')){ scaleOrb = '0.7'; }

    $('.audit-orb-wrapper').css('transform','translateY(15px) scale('+scaleOrb+')');

    setTimeout(function(){

        $('.audit-orb-wrapper').css('transform','translateY(-15px) scale('+scaleOrb+')');

        setTimeout(function(){

            $('.audit-orb-wrapper').css('transform','translateY(10px) scale('+scaleOrb+')');

            setTimeout(function(){

                $('.audit-orb-wrapper').css('transform','translateY(-10px) scale('+scaleOrb+')');

                setTimeout(function(){

                    $('.audit-orb-wrapper').css('transform','translateY(5px) scale('+scaleOrb+')');

                    setTimeout(function(){

                        $('.audit-orb-wrapper').css('transform','translateY(-5px) scale('+scaleOrb+')');

                        setTimeout(function(){

                            $('.audit-orb-wrapper').css('transform','translateY(2px) scale('+scaleOrb+')');

                            setTimeout(function(){

                                $('.audit-orb-wrapper').css('transform','translateY(0px) scale('+scaleOrb+')');
                        
                            }, 20)
                    
                        }, 20)
                
                    }, 20)
            
                }, 20)
        
            }, 20)
    
        }, 20)

    }, 20)

}

function changeRoadmapTab(ev){

    //variables
    var roadmapIndex = $(ev).index();

    $('.roadmap-tabs li.active').removeClass('active');
    $(ev).addClass('active')
    $('.roadmap-list').css('transform','translateX(-'+(25*roadmapIndex)+'%)');
    
    // changing height based on tab opened
    const vw = Math.max(document.documentElement.clientWidth || 0, window.innerWidth || 0);
    if(vw>=860) $('.roadmap-outer').css('height','760px');
    else if(ev.innerText==='Q1 - Q2') $('.roadmap-outer').css('height','1880px');
    else if(ev.innerText==='Q3 - Q4') $('.roadmap-outer').css('height','1450px');
    else $('.roadmap-outer').css('height','980px');
}

//fetch analytics from rvf scan so we get numbers in real-time
function fetchRvfScanAnalytics(){

    //initiate to fetch the users details
    $.ajax({
        type: "GET",
        dataType: "json",
        url: 'https://api.rocketx.exchange/rocketx/v1/get/statistics'
    }).done(function(data) {

        //variables
        var totalTrades = data['totalTxns'].toLocaleString("en-US");
        var totalVolume = ((+data['totalVolumeUsd']/10**9).toFixed(3)).toLocaleString("en-US");

        $('[data-global-stat="swaps"] h4').text(totalTrades);
        $('[data-global-stat="volume"] h4').text('$'+totalVolume+'B');

    });

}

//fetch rvf Price
function fetchRvfPrice(){
    $.ajax({
        type: "GET",
        dataType: "json",
        url: 'https://api.coingecko.com/api/v3/simple/price?ids=rocketx&vs_currencies=usd'
    }).done(function(data) {
        var rvfPrice = data.rocketx?.usd;
        $('#rvfPrice').text('$' + rvfPrice.toFixed(3));
    }).fail(function(){
        $.ajax({
            type: "GET",
            dataType: "json",
            url: ' https://dev-api.rocketx.exchange/rocketx/v1/get/quotation?fromToken=1&fromNetwork=1&toToken=1708&toNetwork=1&amount=1&slippage=1&referralId=undefined'
        }).done(function(data) {
            var rvfPrice;
            if(data.quotes){
                data.quotes.forEach((q)=>{
                if(q?.usd?.to){
                    rvfPrice = q.usd.to;
                }
              })
            $('#rvfPrice').text('$' + rvfPrice.toFixed(3));
            }
        })
    });

}

//fetch Configs from app so we get numbers in real-time
function fetchConfigs(){
    $.ajax({
        type: "GET",
        dataType: "json",
        url: 'https://api.rocketx.exchange/rocketx/v1/get/allConfigs'
    }).done(function(data) {

        var totalNetworks = data['supported_network']?.length || 62;
        $('[data-global-stat="networks"] h4').text(totalNetworks);
        
    });

}

function detectIfSectionIsPresent(ev){

    //variables
    var anchor = $(ev).attr('href');

    if($(anchor).length){

        $('html, body').animate({
            scrollTop: $(anchor).offset().top
        }, 750);

    }
    else {
        
        $(location).attr('href','../'+anchor)
    
    }
    
}

function showMobileNavigation(){

    $('.mobile-navigation').show();
    
    setTimeout(function(){

        $('.mobile-navigation').addClass('active')

    }, 10)

}

function hideMobileNavigation(){

    $('.mobile-navigation').removeClass('active')

    setTimeout(function(){

        $('.mobile-navigation').hide();

    }, 290)

}

function filterFAQ(query){
    var allCategories = document.getElementsByClassName('cat');
    var activeCatID=0;
    for (var i = 0; i < allCategories.length; i++) {
        if(allCategories.item(i).classList.contains('active')) {
            var cList = allCategories.item(i).classList;
            for (var j = 0; j < cList.length; j++) {
                if(cList[j].includes('cat---')) activeCatID = cList[j].split('cat---')[1]
            }
        }
    }  

    var allQs = document.getElementsByClassName("question-box");

    // show only selected category OR all if id===0
    var id = 'cat-id-' + activeCatID;
    for (var i = 0; i < allQs.length; i++) {
        if(!allQs.item(i).classList.contains(id) && Number(activeCatID)!==0) allQs.item(i).style.display = "none";
        else allQs.item(i).style.display = "block";
    }

    if(!!query){
        for (var i = 0; i < allQs.length; i++) {
            if(allQs.item(i).style.display==='block' && !allQs.item(i).textContent.toLowerCase().includes(query)) allQs.item(i).style.display = "none";
        }
        closeAllQuestions();
    }
    else{
        openFirst();
    }

    // check if not-found
    checkNotFound();
}

function checkNotFound(){
    var notFound=true;
    var allQs = document.getElementsByClassName("question-box");
    for (var i = 0; i < allQs.length; i++) {
        if(allQs.item(i).style.display!=='none') {
            notFound = false;
        }
    }
    var notFoundContainer = document.getElementById('not-found');
    if(notFound){
        notFoundContainer.style.display = "block";
    }
    else{
        notFoundContainer.style.display = "none";
    }
}
function openFirst(){
    closeAllQuestions();
    var allQs = document.getElementsByClassName("question-box");
    for (var i = 0; i < allQs.length; i++) {
        if(allQs.item(i).style.display!=='none') { 
            allQs.item(i).classList.add('active');
            $header = $(allQs.item(i).childNodes[1]);
            
            setTimeout(()=>{
                $header.slideToggle(500);
            },200) 
            break;
        }
    }
}

function closeAllQuestions(){
    var allQs = document.getElementsByClassName("question-box");
    for (var i = 0; i < allQs.length; i++) {
        if(allQs.item(i).classList.contains('active')) { allQs.item(i).classList.remove('active');}
        allQs.item(i).childNodes[1].style.display = 'none';
    }
}

function setLS(name,data){
    localStorage.setItem(name,JSON.stringify(data));
}

function getLS(name){
    return localStorage.getItem(name) ?  JSON.parse(localStorage.getItem(name))  : null;
}
function getDynamicPathJs(name){
        //variables
        var path = window.location.href;
		if(path.indexOf("/about")>-1 || path.indexOf("/faq")>-1  ||  path.indexOf("/referral")>-1  ||  path.indexOf("/404")>-1 ){
			return '../';
		}
        return './';
}

function changeYear(year){
    // remove active on all
    var allYrs = document.querySelectorAll(".timeline-years .year");
    for (var i = 0; i < allYrs.length; i++) {
        if(allYrs.item(i).classList.contains('active')) { allYrs.item(i).classList.remove('active');}
        if(allYrs.item(i).id==='year-'+year){ allYrs.item(i).classList.add('active') }
    }

    // remove show on all
    var allYrDs = document.querySelectorAll(".timeline-details .year-detail");
    for (var i = 0; i < allYrDs.length; i++) {
        if(!allYrDs.item(i).classList.contains('hide')) { allYrDs.item(i).classList.add('hide');}
        if(allYrDs.item(i).id==='y-'+year){ allYrDs.item(i).classList.remove('hide'); allYrDs.item(i).classList.add('show') }
    }


}