const products = [
    {
        "id": 34517,
        "product_name": "ICERIVER KAS KS0 ULTRA",
        "hashrate": "400GH",
        "power": "100W",
        "price": 239.00,
        "status": "available",
        "url": "https://www.iceriver.io/product/iceriver-kas-ks0-ultra-2/",
        "image": "images/pro_r.jpeg",
        "secondary_image": "images/pro_r.jpeg"
    },
    {
        "id": 41220,
        "product_name": "ICERIVER KAS KS5M + Hosting",
        "hashrate": "15TH",
        "power": "3400W",
        "price": 7499.00,
        "status": "available",
        "url": "https://www.iceriver.io/product/iceriver-kas-ks5m-hosting/",
        "image": "https://www.iceriver.io/wp-content/uploads/2018/08/0603.144-300x300.jpg",
        "secondary_image": "https://www.iceriver.io/wp-content/uploads/2018/08/0603.144-660x660.jpg",
        "hosted": true
    },
    {
        "id": 34514,
        "product_name": "ICERIVER KAS KS5M",
        "hashrate": "15TH",
        "power": "3400W",
        "price": 7499.00,
        "status": "sold out",
        "url": "https://www.iceriver.io/product/iceriver-kas-ks5m/",
        "image": "https://www.iceriver.io/wp-content/uploads/2018/08/0603.144-300x300.jpg",
        "secondary_image": "https://www.iceriver.io/wp-content/uploads/2018/08/0603.144-660x660.jpg"
    },
    {
        "id": 36926,
        "product_name": "ICERIVER KAS KS5L + Hosting",
        "hashrate": "12TH",
        "power": "3400W",
        "price": 4799.00,
        "status": "available",
        "url": "https://www.iceriver.io/product/iceriver-kas-ks5l-hosting/",
        "image": "https://www.iceriver.io/wp-content/uploads/2023/06/0613.209-300x300.jpg",
        "secondary_image": "https://www.iceriver.io/wp-content/uploads/2023/06/0613.209-660x660.jpg",
        "hosted": true
    },
    {
        "id": 46340,
        "product_name": "ICERIVER ALPH AL0",
        "hashrate": "400GH",
        "power": "100W",
        "price": 790099.00,
        "status": "sold out",
        "url": "https://www.iceriver.io/product/iceriver-alph-al0/",
        "image": "https://file.bitmain.com/shop-bitmain/proshow/2024/02/26/21/72c03a7e-a882-493e-923a-d39c51811fbf.jpg",
        "secondary_image": "https://file.bitmain.com/shop-bitmain/proshow/2024/02/26/21/72c03a7e-a882-493e-923a-d39c51811fbf.jpg"
    },
    {
        "id": 33890,
        "product_name": "ICERIVER KAS KS5L",
        "hashrate": "12TH",
        "power": "3400W",
        "price": 4799.00,
        "status": "sold out",
        "url": "https://www.iceriver.io/product/iceriver-kas-ks5l/",
        "image": "https://www.iceriver.io/wp-content/uploads/2023/06/0613.209-300x300.jpg",
        "secondary_image": "https://www.iceriver.io/wp-content/uploads/2023/06/0613.209-660x660.jpg"
    }
]
;

let cart = JSON.parse(localStorage.getItem('cart')) || [];

// Function to render products on the page
function renderProducts() {
    const productList = document.getElementById('product-list');
    productList.innerHTML = ''; // Clear previous content

    products.forEach((product) => {
        const productItem = document.createElement('li');
        productItem.classList.add('pif-has-gallery', 'product', 'type-product', `post-${product.id}`, 'status-publish', product.status === 'available' ? 'instock' : 'outofstock', 'product_cat-all-product', 'has-post-thumbnail', 'shipping-taxable', 'purchasable', 'product-type-simple');

        productItem.innerHTML = `
            <a href="${product.url}" class="woocommerce-LoopProduct-link woocommerce-loop-product__link">
                <div class="sh-woo-post-image test">
                    <img width="300" height="300" src="${product.image}" class="attachment-woocommerce_thumbnail size-woocommerce_thumbnail"
                     alt="${product.product_name}" />
                </div>
                <div class="sh-woo-post-content-container">
                    <h2 class="woocommerce-loop-product__title">${product.product_name}</h2>
                    <span class="woocommerce-loop-product__attributes">${product.hashrate} | ${product.power}</span>
                    <span class="price"><span class="woocommerce-Price-amount amount">
                    <span class="woocommerce-Price-currencySymbol">&#036;</span>${product.price.toFixed(2)}</span></span>
                </div>
            </a>
            <a href="#" onclick="addToCart(${product.id})" 
            class="button wp-element-button product_type_simple" ${product.status === 'sold out' ? 'disabled' : ''} 
            aria-label="Read more about “${product.product_name}”" rel="nofollow">
                ${product.status === 'sold out' ? 'Sold Out' : 'Add to Cart'}
            </a>
        `;

        productList.appendChild(productItem);
    });
}

// Function to add product to cart
function addToCart(productId) {
    const product = products.find(item => item.id === productId);
    const existingProductIndex = cart.findIndex(item => item.id === productId);

    if (existingProductIndex !== -1) {
        cart[existingProductIndex].quantity += 1; // Increment quantity if already in cart
    } else {
        product.quantity = 1; // Add quantity property
        cart.push(product);
    }

    localStorage.setItem('cart', JSON.stringify(cart));
    updateCartCount();
    alert(`${product.product_name} has been added to your cart.`);
}

// Function to update cart count in the icon
function updateCartCount() {
    const cartCount = document.getElementById('cart-count');
    const totalItems = cart.reduce((sum, item) => sum + item.quantity, 0);
    cartCount.textContent = totalItems;
}

// Redirect to the cart page
function redirectToCart() {
    window.location.href = "cart.html";
}

// Initial render of products and cart count
renderProducts();
updateCartCount();
