jQuery(document).ready(function ($) {
	if ($('.sp-team-pro').length > 0) {

		function SwiperSlide(selector, options) {
			if (parseInt(sptp_vars.sptp_swiper) === 1) {
				return new SPTPSwiper(selector, options);
			} else {
				return new Swiper(selector, options);
			}

		}
		// Lazy-load scripts.
		function wpteam_lazyload() {
			// Find all images with the class 'wpteam_lazyload'.
			var $lazyImages = $("img.wpteam_lazyload");

			// Check if there are any lazy-loaded images.
			if ($lazyImages.length > 0) {
				$lazyImages.each(function () {
					var $image = $(this);
					// Apply lazy loading with fadeIn effect.
					$image.wp_team_lazyload({
						effect: "fadeIn",
						effectTime: 2000,
						appear: function () {
							// Set the 'srcset' attribute to the 'data-wpteam_srcset' value and remove the 'data-wpteam_srcset' attribute since it's no longer needed.
							$(this).attr('srcset', $(this).attr('data-wpteam_srcset')).removeAttr('data-wpteam_srcset');

							// Add the 'wpteam_lazyloaded' class after the image is loaded and appeared.
							$(this).removeClass('wpteam_lazyload').addClass('wpteam_lazyloaded');
						}
					});
				});
			}
		}

		// Team stuffs init
		$('.sp-team-pro').each(function () {
			var sptp_container = $(this),
				sptp_container_id = sptp_container.attr('id'),
				sptp_Wrapper_ID = '#' + sptp_container_id,
				sptpSwiper,
				sptpTicker;
			// Carousel.
			function carouselSlide() {
				// Carousel ticker init.
				if (sptpCarousel.mode === "ticker") {
					var ticker_carousel_items = $(".sptp-main-carousel .swiper-wrapper", sptp_Wrapper_ID).find('.sp-team-pro-item').length;
					var tickerSpeed = sptpCarousel.speed * ticker_carousel_items;
					// Ticker Direction class add.
					if ($('body').hasClass('rtl')) {
						$(sptp_Wrapper_ID + " .swiper-container").addClass('sptp-dir');
					}
					sptpTicker = $(".sptp-main-carousel .swiper-wrapper", sptp_Wrapper_ID).bxSlider({
						ticker: true,
						tickerHover: sptpCarousel.stop_onhover,
						speed: tickerSpeed,
						easing: null,
						slideWidth: 280,
						slideMargin: sptpCarousel.spaceBetween,
						minSlides: sptpCarousel.min_item,
						maxSlides: sptpCarousel.items,
						moveSlides: sptpCarousel.items,
						shrinkItems: false,
						auto: false,
						autoDirection: sptpCarousel.direction,
					});
					$('.sptp-main-carousel', sptp_Wrapper_ID).css('opacity', 1);
					$(sptp_Wrapper_ID + ' .bx-wrapper .sptp-member-avatar-img-area img').removeAttr('loading');
				}
				// Carousel standard.
				if (sptpCarousel.mode !== "ticker") {
					// Carousel Navigation Style.
					// var nav_arrow = $(".sptp-main-carousel ", sptp_Wrapper_ID).data('nav_arrow');
					// switch (nav_arrow) {
					// 	case 'angle':
					// 		var left_arrow = 'fa-angle-left';
					// 		var right_arrow = 'fa-angle-right';
					// 		break;
					// 	case 'chevron':
					// 		var left_arrow = 'fa-chevron-left';
					// 		var right_arrow = 'fa-chevron-right';
					// 		break;
					// 	case 'angle-double':
					// 		var left_arrow = 'fa-angle-double-left';
					// 		var right_arrow = 'fa-angle-double-right';
					// 		break;
					// 	case 'arrow':
					// 		var left_arrow = 'fa-arrow-left';
					// 		var right_arrow = 'fa-arrow-right';
					// 		break;
					// 	case 'long-arrow':
					// 		var left_arrow = 'fa-long-arrow-left';
					// 		var right_arrow = 'fa-long-arrow-right';
					// 		break;
					// 	case 'caret':
					// 		var left_arrow = 'fa-caret-left';
					// 		var right_arrow = 'fa-caret-right';
					// 		break;
					// }
					// Add navigation left and right arrow.
					// $(sptp_Wrapper_ID + ' .swiper-button-prev i').addClass(left_arrow);
					// $(sptp_Wrapper_ID + ' .swiper-button-next i').addClass(right_arrow);
					var carousel_items = $(sptp_Wrapper_ID).find('.swiper-slide:not(.swiper-slide-duplicate)').length,
						dragScrollSize = (($(sptp_Wrapper_ID).width()) / carousel_items),
						type = {};
					if (sptpCarousel.pagination_type === 'fraction') {
						type = {
							type: 'fraction',
						}
					}

					var desktopScreen = sptpCarousel.breakpoints.desktop_screen_size,
						laptopScreen = sptpCarousel.breakpoints.laptop_screen_size,
						tabletScreen = sptpCarousel.breakpoints.tablet_screen_size,
						mobileScreen = sptpCarousel.breakpoints.mobile_screen_size,
						fade_mode = (sptpCarousel.fade_mode == 1) && (sptpCarousel.mode === 'standard') ? 'fade' : 'slider',
						fade_mode = sptpCarousel.mode === 'thumbnails-slider' ? 'thumbnails-slider' : fade_mode;

					if ('slider' === fade_mode) {
						sptpSwiper = SwiperSlide(sptp_Wrapper_ID + " .sptp-main-carousel", {
							speed: sptpCarousel.speed,
							slidesPerView: sptpCarousel.items,
							spaceBetween: sptpCarousel.spaceBetween,
							grid: {
								rows: sptpCarousel.breakpoints.mobile_row,
								fill: 'row',
							},
							autoplay: sptpCarousel.autoplay ? ({ delay: sptpCarousel.autoplay_speed }) : false,
							preloadImages: false,
							freeMode: sptpCarousel.freeMode,
							observer: true,
							runCallbacksOnInit: false,
							slidesPerGroup: sptpCarousel.per_slide,
							initialSlide: 0,
							loop: (sptpCarousel.breakpoints.desktop_row > '1' || sptpCarousel.breakpoints.laptop_row > '1' || sptpCarousel.breakpoints.tablet_row > '1' || sptpCarousel.breakpoints.mobile_row > '1') ? false : sptpCarousel.loop,
							mousewheel: sptpCarousel.mouse_wheel,
							simulateTouch: sptpCarousel.simulateTouch,
							allowTouchMove: sptpCarousel.allowTouchMove,
							autoHeight: (sptpCarousel.breakpoints.desktop_row > '1' || sptpCarousel.breakpoints.laptop_row > '1' || sptpCarousel.breakpoints.tablet_row > '1' || sptpCarousel.breakpoints.mobile_row > '1') ? false : sptpCarousel.autoHeight,
							centeredSlides: sptpCarousel.mode === 'center' ? true : false,
							// pagination: {
							// 	el: sptp_Wrapper_ID + " .sptp-main-carousel .swiper-pagination",
							// 	clickable: true,
							// 	dynamicBullets: sptpCarousel.dynamicBullets
							// },
							// If we need pagination
							pagination: sptpCarousel.pagination_type !== 'scrollbar' ? {
								el: sptp_Wrapper_ID + " .sptp-main-carousel .swiper-pagination",
								clickable: true,
								dynamicBullets: 'dynamic' == sptpCarousel.pagination_type ? true : false,
								renderBullet: sptpCarousel.pagination_type === 'numbers' ? function (index, className) {
									return '<span class="' + className + '"><span class="number">' + (index + 1) + "</span> </span>";
								} : '',
								...type,
								renderFraction: sptpCarousel.pagination_type === 'fraction' ? function (currentClass, totalClass) {
									return '<div class="sptp-swiper-pagination-fraction"><span class="' + currentClass + '"></span>' +
										' / ' +
										'<span class="' + totalClass + '"></span></div>';
								} : '',
							} : false,
							scrollbar: {
								el: sptp_Wrapper_ID + " .sptp-pagination-scrollbar",
								draggable: true,
								dragSize: dragScrollSize,
							},
							navigation: {
								nextEl: sptp_Wrapper_ID + " .sptp-main-carousel .sptp-button-next",
								prevEl: sptp_Wrapper_ID + " .sptp-main-carousel  .sptp-button-prev"
							},
							breakpoints: {
								[mobileScreen]: {
									slidesPerView: sptpCarousel.breakpoints.mobile,
									slidesPerGroup: sptpCarousel.breakpoints.mobile_pSlide,
									grid: {
										rows: sptpCarousel.breakpoints.mobile_row,
										fill: 'row',
									},
								},
								[tabletScreen]: {
									slidesPerView: sptpCarousel.breakpoints.tablet,
									slidesPerGroup: sptpCarousel.breakpoints.tablet_pSlide,
									grid: {
										rows: sptpCarousel.breakpoints.tablet_row,
										fill: 'row',
									},
								},
								[laptopScreen]: {
									slidesPerView: sptpCarousel.breakpoints.laptop,
									slidesPerGroup: sptpCarousel.breakpoints.laptop_pSlide,
									grid: {
										rows: sptpCarousel.breakpoints.laptop_row,
										fill: 'row',
									},
								},
								[desktopScreen]: {
									slidesPerView: sptpCarousel.breakpoints.desktop,
									slidesPerGroup: sptpCarousel.breakpoints.desktop_pSlide,
									grid: {
										rows: sptpCarousel.breakpoints.desktop_row,
										fill: 'row',
									},
								}
							},
							ally: {
								enabled: sptpCarousel.enabled,
								prevSlideMessage: sptpCarousel.prevSlideMessage,
								nextSlideMessage: sptpCarousel.nextSlideMessage,
								firstSlideMessage: sptpCarousel.firstSlideMessage,
								lastSlideMessage: sptpCarousel.lastSlideMessage,
								paginationBulletMessage: sptpCarousel.paginationBulletMessage
							},
							keyboard: {
								enabled: true
							}
						});
					} else if ('thumbnails-slider' === fade_mode) {
						if (!$(sptp_Wrapper_ID + ' .sptp-main-carousel').hasClass('swiper-initialized')) {
							var contentCarousel = $(sptp_Wrapper_ID + ' .sptp-thumbnail-slider-content-section');
							var item = contentCarousel.find(".swiper-wrapper .sp-team-pro-item").length;
							var galleryThumbs = SwiperSlide(sptp_Wrapper_ID + " .sptp-thumbnail-slider-thumb-section", {
								slidesPerView: sptpCarousel.items,
								spaceBetween: sptpCarousel.spaceBetween,
								preloadImages: false,
								freeMode: sptpCarousel.freeMode,
								observer: true,
								watchSlidesProgress: true,
								slidesPerGroup: 1,
								loop: (sptpCarousel.breakpoints.desktop_row > '1' || sptpCarousel.breakpoints.laptop_row > '1' || sptpCarousel.breakpoints.tablet_row > '1' || sptpCarousel.breakpoints.mobile_row > '1') ? false : sptpCarousel.loop,
								mousewheel: sptpCarousel.mouse_wheel,
								simulateTouch: sptpCarousel.simulateTouch,
								allowTouchMove: sptpCarousel.allowTouchMove,
								centeredSlides: true,
								loopedSlides: item,
								slideToClickedSlide: true,
								// pagination: {
								// 	el: sptp_Wrapper_ID + " .sptp-main-carousel .swiper-pagination",
								// 	clickable: true,
								// 	dynamicBullets: sptpCarousel.dynamicBullets
								// },
								// If we need pagination
								navigation: false,
								pagination: false,
								breakpoints: {
									[mobileScreen]: {
										slidesPerView: sptpCarousel.breakpoints.mobile,
									},
									[tabletScreen]: {
										slidesPerView: sptpCarousel.breakpoints.tablet,
									},
									[laptopScreen]: {
										slidesPerView: sptpCarousel.breakpoints.laptop,
									},
									[desktopScreen]: {
										slidesPerView: sptpCarousel.breakpoints.desktop,
									}
								},
							});
							var galleryContent = SwiperSlide(sptp_Wrapper_ID + " .sptp-thumbnail-slider-content-section", {
								speed: sptpCarousel.speed,
								slidesPerView: 1,
								slidesPerGroup: 1,
								spaceBetween: sptpCarousel.spaceBetween,
								loop: (sptpCarousel.breakpoints.desktop_row > '1' || sptpCarousel.breakpoints.laptop_row > '1' || sptpCarousel.breakpoints.tablet_row > '1' || sptpCarousel.breakpoints.mobile_row > '1') ? false : sptpCarousel.loop,
								loopedSlides: item,
								grabCursor: true,
								autoplay: sptpCarousel.autoplay ? ({ delay: sptpCarousel.autoplay_speed }) : false,
								preloadImages: false,
								freeMode: sptpCarousel.freeMode,
								observer: true,
								runCallbacksOnInit: false,
								slidesPerGroup: sptpCarousel.per_slide,
								initialSlide: 0,
								loop: (sptpCarousel.breakpoints.desktop_row > '1' || sptpCarousel.breakpoints.laptop_row > '1' || sptpCarousel.breakpoints.tablet_row > '1' || sptpCarousel.breakpoints.mobile_row > '1') ? false : sptpCarousel.loop,
								mousewheel: sptpCarousel.mouse_wheel,
								simulateTouch: sptpCarousel.simulateTouch,
								allowTouchMove: sptpCarousel.allowTouchMove,
								autoHeight: (sptpCarousel.breakpoints.desktop_row > '1' || sptpCarousel.breakpoints.laptop_row > '1' || sptpCarousel.breakpoints.tablet_row > '1' || sptpCarousel.breakpoints.mobile_row > '1') ? false : sptpCarousel.autoHeight,
								// If we need pagination
								pagination: sptpCarousel.pagination_type !== 'scrollbar' ? {
									el: sptp_Wrapper_ID + " .sptp-main-carousel .swiper-pagination",
									clickable: true,
									dynamicBullets: 'dynamic' == sptpCarousel.pagination_type ? true : false,
									renderBullet: sptpCarousel.pagination_type === 'numbers' ? function (index, className) {
										return '<span class="' + className + '"><span class="number">' + (index + 1) + "</span> </span>";
									} : '',
									...type,
									renderFraction: sptpCarousel.pagination_type === 'fraction' ? function (currentClass, totalClass) {
										return '<div class="sptp-swiper-pagination-fraction"><span class="' + currentClass + '"></span>' +
											' / ' +
											'<span class="' + totalClass + '"></span></div>';
									} : '',
								} : false,
								scrollbar: {
									el: sptp_Wrapper_ID + " .sptp-pagination-scrollbar",
									draggable: true,
									dragSize: dragScrollSize,
								},
								navigation: {
									nextEl: sptp_Wrapper_ID + " .sptp-main-carousel .sptp-button-next",
									prevEl: sptp_Wrapper_ID + " .sptp-main-carousel  .sptp-button-prev"
								},
								ally: {
									enabled: sptpCarousel.enabled,
									prevSlideMessage: sptpCarousel.prevSlideMessage,
									nextSlideMessage: sptpCarousel.nextSlideMessage,
									firstSlideMessage: sptpCarousel.firstSlideMessage,
									lastSlideMessage: sptpCarousel.lastSlideMessage,
									paginationBulletMessage: sptpCarousel.paginationBulletMessage
								},
								keyboard: {
									enabled: true
								},
								fadeEffect: {
									crossFade: true,
								},

							});

							galleryContent.controller.control = galleryThumbs;
							galleryThumbs.controller.control = galleryContent;
							if (sptpCarousel.autoplay === false) {
								galleryThumbs.autoplay.stop()
								galleryContent.autoplay.stop()
							}
							if (sptpCarousel.stop_onhover && sptpCarousel.autoplay) {
								$(contentCarousel).on({
									mouseenter: function () {
										galleryContent.autoplay.stop()
										galleryThumbs.autoplay.stop()
									},
									mouseleave: function () {
										galleryContent.autoplay.start()
										galleryThumbs.autoplay.start()
									}
								});
							}
						}
					} else if ('fade' === fade_mode) {
						var sptpFadeItem = $(sptp_Wrapper_ID + " .sptp-fade-carousel").data("responsive");
						var slidePerView = sptpFadeItem.desktop
						if ($(window).width() > desktopScreen) {
							slidePerView = sptpFadeItem.desktop
						} else if ($(window).width() > laptopScreen) {
							slidePerView = sptpFadeItem.laptop
						} else if ($(window).width() > tabletScreen) {
							slidePerView = sptpFadeItem.tablet
						} else if ($(window).width() > 0) {
							slidePerView = sptpFadeItem.mobile
						}
						$(sptp_Wrapper_ID + " .sptp-fade-carousel .sp-team-pro-item").css('width', 100 / slidePerView + '%');

						var fade_items = $(sptp_Wrapper_ID + " .sptp-fade-carousel .swiper-wrapper >.sp-team-pro-item");
						for (var i = 0; i < fade_items.length; i += slidePerView) {
							fade_items.slice(i, i + slidePerView).wrapAll('<div class="swiper-slide"></div>');
						}
						var carousel_items = $(sptp_Wrapper_ID).find('.swiper-slide').length,
							dragScrollSize = (($(sptp_Wrapper_ID).width()) / carousel_items);
						sptpSwiper = SwiperSlide(sptp_Wrapper_ID + " .sptp-fade-carousel", {
							speed: sptpCarousel.speed,
							autoplay: sptpCarousel.autoplay ? ({ delay: sptpCarousel.autoplay_speed }) : false,
							preloadImages: false,
							observer: true,
							runCallbacksOnInit: false,
							effect: 'fade',
							fadeEffect: {
								crossFade: true
							},
							initialSlide: 0,
							loop: (sptpCarousel.breakpoints.desktop_row > '1' || sptpCarousel.breakpoints.laptop_row > '1' || sptpCarousel.breakpoints.tablet_row > '1' || sptpCarousel.breakpoints.mobile_row > '1') ? false : sptpCarousel.loop,
							mousewheel: sptpCarousel.mouse_wheel,
							simulateTouch: sptpCarousel.simulateTouch,
							allowTouchMove: sptpCarousel.allowTouchMove,
							autoHeight: (sptpCarousel.breakpoints.desktop_row > '1' || sptpCarousel.breakpoints.laptop_row > '1' || sptpCarousel.breakpoints.tablet_row > '1' || sptpCarousel.breakpoints.mobile_row > '1') ? false : sptpCarousel.autoHeight,
							centeredSlides: sptpCarousel.mode === 'center' ? true : false,
							pagination: sptpCarousel.pagination_type !== 'scrollbar' ? {
								el: sptp_Wrapper_ID + " .sptp-main-carousel .swiper-pagination",
								clickable: true,
								dynamicBullets: 'dynamic' == sptpCarousel.pagination_type ? true : false,
								renderBullet: sptpCarousel.pagination_type === 'numbers' ? function (index, className) {
									return '<span class="' + className + '"><span class="number">' + (index + 1) + "</span> </span>";
								} : '',
								...type,
								renderFraction: sptpCarousel.pagination_type === 'fraction' ? function (currentClass, totalClass) {
									return '<div class="sptp-swiper-pagination-fraction"><span class="' + currentClass + '"></span>' +
										' / ' +
										'<span class="' + totalClass + '"></span></div>';
								} : '',
							} : false,
							scrollbar: {
								el: sptp_Wrapper_ID + " .sptp-pagination-scrollbar",
								draggable: true,
								dragSize: dragScrollSize,
							},
							navigation: {
								nextEl: sptp_Wrapper_ID + " .sptp-main-carousel .sptp-button-next",
								prevEl: sptp_Wrapper_ID + " .sptp-main-carousel  .sptp-button-prev"
							},
							ally: {
								enabled: sptpCarousel.enabled,
								prevSlideMessage: sptpCarousel.prevSlideMessage,
								nextSlideMessage: sptpCarousel.nextSlideMessage,
								firstSlideMessage: sptpCarousel.firstSlideMessage,
								lastSlideMessage: sptpCarousel.lastSlideMessage,
								paginationBulletMessage: sptpCarousel.paginationBulletMessage
							},
							keyboard: {
								enabled: true
							}
						});
						sptp_item_same_height()
					}

					$('.sptp-main-carousel', sptp_Wrapper_ID).css('opacity', 1);
					// Carousel stop on hover.
					if ('thumbnails-slider' !== fade_mode) {
						if (sptpCarousel.stop_onhover && sptpCarousel.autoplay) {
							$(sptp_Wrapper_ID + " .sptp-main-carousel").on({
								mouseenter: function () {
									sptpSwiper.autoplay.stop();
								},
								mouseleave: function () {
									sptpSwiper.autoplay.start();
								}
							});
						}
						sptpSwiper.on('slideChange', function () {
							$(window).trigger('resize');
						})
					}
				}

			}
			if ($(sptp_Wrapper_ID + ".sptp-carousel").length > 0) {
				var sptpCarousel = $('.sptp-main-carousel', sptp_Wrapper_ID).data(
					"carousel"
				);
				carouselSlide();
			}

			// Team stuffs init
			function accordion_init() {
				$(sptp_Wrapper_ID + ' .sptp-accordion-single-title').off('click').on('click', function () {
					var currentItem = $(this).parent();
					var isOpen = currentItem.hasClass('is-open');
					$(sptp_Wrapper_ID + ' .sptp-accordion-single-item').not(currentItem).removeClass('is-open').find('.sptp-accordion-single-content').slideUp();
					if (!isOpen) {
						currentItem.addClass('is-open').find('.sptp-accordion-single-content').slideDown();
					} else {
						currentItem.removeClass('is-open').find('.sptp-accordion-single-content').slideUp();
					}
				});
			}
			if ($(sptp_Wrapper_ID + " .sptp-accordion").length > 0) {
				accordion_init();
			}

			// Same height option
			function sptp_item_same_height() {
				var maxHeight = 0;
				$(sptp_Wrapper_ID + '.sptp_item_same_height .sp-team-pro-item').each(function () {
					if ($(this).find('.sptp-member').height() > maxHeight) {
						maxHeight = $(this).find('.sptp-member').height();
					}
				})
				$(sptp_Wrapper_ID + '.sptp_item_same_height .sptp-member').height(maxHeight);
			}
			sptp_item_same_height();

			// Progress bar animation on loading.
			function progressBarAnimation() {
				$(".sptp-progress-container", sptp_Wrapper_ID).each(function () {
					var percent = $(this).data("title");
					$(this)
						.find(".sptp-progress-bar")
						.animate({
							width: percent
						},
							1000
						);
					var percentInt = parseInt(percent);
					if (percentInt >= 95) {
						$(this)
							.find(".sptp-top")
							.css("right", 0);
					}
					if (percentInt === 100) {
						$(this)
							.find(".sptp-top")
							.css("width", "40px");
					}
				});
			}
			// Icon on hover.
			function iconOnImage() {
				$(document).on({
					mouseenter: function () {
						$(this)
							.find(".sptp-icon")
							.animate({
								opacity: 1
							},
								50
							);
					},
					mouseleave: function () {
						$(this)
							.find(".sptp-icon")
							.animate({
								opacity: 0
							},
								50
							);
					}
				},
					".sptp-icon-on-image"
				);
			}
			// Content over image animation class adding function.
			function contentOverImage() {
				$(".sptp-content-on-image", sptp_Wrapper_ID).on({
					mouseenter: function () {
						$(this)
							.find(".sptp-content")
							.addClass("animation");
					},
					mouseleave: function () {
						$(this)
							.find(".sptp-content")
							.removeClass("animation");
					}
				});
			}
			// Run progress bar animation.
			progressBarAnimation();
			// iconOnImage();
			contentOverImage();

			// REMOVE AND ADD CLICK EVENT
			$(".doAddItem").on("click", function () {
				$(".gridder")
					.data("gridderExpander")
					.gridderAddItem("TEST");
			});

			// Gridder init function.
			function sptp_gridder_init() {
				var firstDrawerAttr = $(".gridder", sptp_Wrapper_ID).find('.sp-team-pro-item').data('first-drawer');
				if ($(".gridder", sptp_Wrapper_ID).length > 0) {
					$(".gridder", sptp_Wrapper_ID).gridderExpander({
						scrollOffset: 60,
						scrollTo: "panel", // "panel" or "listitem"
						animationSpeed: 400,
						animationEasing: "easeInOutExpo",
						nextText: "<i class='fa fa-angle-right'></i>", // Next button text
						prevText: "<i class='fa fa-angle-left'></i>", // Previous button text
						closeText: "",
						onContent: function (object) {
							$(object).find(".sptp-left-content");
						},
						onExpanded: function (object) { },
						onChanged: function (object) { },
						onClosed: function () { }
					});
				}

				if ('1' == firstDrawerAttr) {
					$(sptp_Wrapper_ID + " .sptp-row.gridder").css("display", "inline-block");
					var button = $(".gridder", sptp_Wrapper_ID).find(".gridder-list:nth-child(1)");
					$(button).trigger('click', false);
				}

			}
			sptp_gridder_init()

			// Masonry initialize.
			function sptp_masonry_init() {
				var masonry = $(sptp_Wrapper_ID + ".sptp-masonry .sptp-row");
				if (masonry.length > 0 && $.fn.masonry) {
					masonry.masonry(); // Masonry
					masonry.imagesLoaded(function () {
						masonry.masonry(); // Masonry
					});
				}
			};
			sptp_masonry_init();

			// Filter Layout.
			var $sptpgrid;
			if ($(sptp_Wrapper_ID + ".sptp-filter").length > 0) {
				$(sptp_Wrapper_ID + ".sptp-filter").each(function () {
					var sptpGeneratorID = $(this).attr("id");
					var isopope_selector = $(sptp_Wrapper_ID + ' .sptp-filter-grid');
					var filter_style = isopope_selector.data('layout_mode');
					var layoutMode = 'fitRows';
					if (filter_style == 'masonry') {
						layoutMode = 'masonry';
					}
					$sptpgrid = isopope_selector.isotope({
						// itemSelector: '.element-item',
						layoutMode: layoutMode,
						stamp: '.element-item--static',
						itemSelector: '[data-category]'
					});

					function isotope_init() {
						$(window).on('load', function () {
							$sptpgrid.isotope('layout');
						});
						isopope_selector.imagesLoaded(function () {
							$sptpgrid.isotope('layout');
						});

					}

					// Flatten object by concatenation values.
					function concatValues(obj) {
						var value = ''
						for (var prop in obj) {
							value += obj[prop]
						}
						return value;
					}
					// bind filter button click
					var filters = {}
					$(sptp_Wrapper_ID + ' .filters-button-group').on('click', 'button', function (event) {

						var $button = $(event.currentTarget);
						// get group key

						var $taxonomyGroup = $button.parents('.filters-button-group')
						var filterGroup = $taxonomyGroup.attr('data-filter-group')

						filters[filterGroup] = $button.attr('data-filter')
						// Combine filters
						var filterValue = concatValues(filters);
						// set filter for Isotope
						$sptpgrid.isotope({ filter: filterValue });
						//  updateFilterCounts();
					});
					// Filter select.
					$(sptp_Wrapper_ID + ".sptp-filter .filterSelect").on(
						'change',
						function (event) {
							var $select = $(event.target);
							// get group key
							var filterGroup = $select.attr('data-filter-group');
							filters[filterGroup] = event.target.value;
							// Combine filters
							var filterValue = concatValues(filters);

							// set filter for Isotope
							$sptpgrid.isotope({ filter: filterValue });
							//  updateFilterCounts();
						});


					// Change active class on buttons
					$(sptp_Wrapper_ID + ' .filters-button-group').each(function (i, buttonGroup) {
						var $buttonGroup = $(buttonGroup);
						var $find_active_button = $buttonGroup.find('.is-checked');
						if ($find_active_button.length == 0) {
							$buttonGroup.find('button:nth-child(1)').addClass('is-checked').trigger('click');
						}
						$buttonGroup.on('click', 'button', function () {
							$buttonGroup.find('.is-checked').removeClass('is-checked');
							$(this).addClass('is-checked');
						});
					});
				})
			}

			// Thumbnail pager.
			if ($(sptp_Wrapper_ID + ' .sptp-thumbnail-pager').length > 0) {
				var galleryThumbs = SwiperSlide(sptp_Wrapper_ID + ' .sptp-thumbnail-pager-thumbs', {
					spaceBetween: 0,
					slidesPerView: 10,
					loop: false,
					allowTouchMove: false,
				});
				var galleryTop = SwiperSlide(sptp_Wrapper_ID + ' .sptp-thumbnail-pager-sidebar', {
					loop: false,
					allowTouchMove: false,
					effect: 'fade',
					autoHeight: true,
					thumbs: {
						swiper: galleryThumbs,
					}
				});
			}

			/* After pagination load event init */
			function sptp_event_init(sptp_Wrapper_ID) {
				$(document).on("click", ".gridder-close", function (e) {
					e.preventDefault();
					e.stopPropagation();
					$(this)
						.closest(".gridder-show")
						.remove();
				});
				$(document).on("click", sptp_Wrapper_ID + " .gridder-list", function (e) {
					if (!$(e.target).closest('.sptp-member-social').hasClass('sptp-member-social')) {
						var totalGridder = $(".gridder-list", sptp_Wrapper_ID).length;
						var position = $(".gridder-list", sptp_Wrapper_ID).index($(this)) + 1;
						if (position == totalGridder) {
							$(".sptp-drawer .gridder-nav.next", sptp_Wrapper_ID).hide();
						}
						if (position == 1) {
							$(".sptp-drawer .gridder-nav.prev", sptp_Wrapper_ID).hide();
						}
					}
				});
			}
			sptp_event_init(sptp_Wrapper_ID);

			/* Popup slider init */
			function sptp_popup_swiper_init() {
				$(sptp_Wrapper_ID + " .sptp-popup-item").each(function () {
					var _this = $(this);
					var sptp_sw_container = _this.find('.swiper-container');
					var swiperItem = sptp_sw_container.find(".swiper-slide").length;
					if (swiperItem < 2) {
						sptp_sw_container.find(".sptp-pagination, .sptp-button-next, .sptp-button-prev").hide();
					}
					if (!$(sptp_sw_container).hasClass('swiper-container-initialized')) {
						swiper = SwiperSlide(sptp_Wrapper_ID + " .sptp-popup-item .swiper-container", {
							loop: false,
							slidesPerView: 1,
							autoHeight: true,
							observer: true,
							observeParents: true,
							pagination: {
								el: ".swiper-pagination",
								clickable: true
							},
							navigation: {
								nextEl: ".swiper-button-next",
								prevEl: ".swiper-button-prev"
							}
						});
					}
				})
			}
			sptp_popup_swiper_init();

			$(document).ajaxComplete(function () {
				progressBarAnimation();
				$('.pagination-disable').css('pointer-events', 'none');

				$(".sp-team-pro-page-loading-image").css("visibility", "hidden");
			});
			$(".sp-team-pro-page-loading-image").css("visibility", "hidden");

			// Ajax all filter action.
			var sptp_search_value = '';
			var sptp_filter_slug = '';
			var shortcodeId = $(sptp_Wrapper_ID + '.sp-team-pro').attr('id');
			function sptp_ajax_actions(sptp_Wrapper_ID) {
				$.ajax({
					type: 'POST',
					url: sptp_vars.ajax_url,
					data: {
						value: sptp_search_value,
						slug: sptp_filter_slug,
						generator_id: shortcodeId,
						action: 'team_pro_search_member',
						page: 1,
						nonce: sptp_vars.nonce,
					},
					success: function (response) {
						var $data = response ? $(response) : `<h4 style="text-align:center;width:100%">${sptp_vars.not_found}</h4>`;
						var member_data = $(sptp_Wrapper_ID + ' .sptp-grid > .sptp-row, ' + sptp_Wrapper_ID + '  table tbody, ' + sptp_Wrapper_ID + ' .swiper-wrapper, ' + sptp_Wrapper_ID + '.sptp-filter .sptp-filter-grid.sptp-row,' + sptp_Wrapper_ID + ' .sptp-accordion-items').css('opacity', 0);
						// Carousel destroy.
						if ($(sptp_Wrapper_ID + ".sptp-carousel").length > 0) {
							var sptpCarousel = $('.sptp-main-carousel', sptp_Wrapper_ID).data(
								"carousel"
							);
							if (sptpCarousel.mode === "ticker") {
								sptpTicker.destroySlider();
							} else {
								sptpSwiper.destroy();
							}
						}
						member_data.html($data);
						// Masonry layout.
						if ($(sptp_Wrapper_ID).hasClass("sptp-masonry")) {
							var $post_wrapper = $(".sptp-row", sptp_Wrapper_ID);
							$post_wrapper.masonry("destroy");
							$post_wrapper.html($data).imagesLoaded(function () {
								$post_wrapper.masonry();
							});
						}
						// Carousel.
						if ($(sptp_Wrapper_ID + ".sptp-carousel").length > 0) {
							var sptpCarousel = $('.sptp-main-carousel', sptp_Wrapper_ID).data(
								"carousel"
							);
							carouselSlide();
						}
						if ($(sptp_Wrapper_ID + ".sptp-filter").length > 0) {
							$sptpgrid.isotope('remove', $sptpgrid.isotope('getItemElements'));
							$sptpgrid.html($data).imagesLoaded(function () {
								$sptpgrid.isotope('insert', $data);
								$sptpgrid.isotope('layout');
							})
							// $sptpgrid.isotope('insert', $data);
						}
						sptp_item_same_height();
						accordion_init();
						//  setTimeout(() => {
						member_data.animate({
							opacity: '1',
						}, "slow");
						// }, 10);
						wpteam_lazyload();
					}
				});
				if ($(sptp_Wrapper_ID + ".pagination_btn").length > 0 || $(sptp_Wrapper_ID + ".pagination_scrl").length > 0 || $(sptp_Wrapper_ID + ".pagination_number").length > 0) {
					$.ajax({
						type: 'POST',
						url: sptp_vars.ajax_url,
						data: {
							value: sptp_search_value,
							slug: sptp_filter_slug,
							generator_id: shortcodeId,
							action: 'team_pro_pagination',
							nonce: sptp_vars.nonce,
						},
						success: function (response) {
							var $data = $(response);
							var member_data = $(sptp_Wrapper_ID + ' .sptp-post-pagination');
							member_data.html($data);
							if ($(sptp_Wrapper_ID + ' .sptp-post-pagination a').length) {
								$(sptp_Wrapper_ID + ' .sptp-post-load-more').show();
								$(sptp_Wrapper_ID + ' .infinite-scroll-last').hide();
								$('.sptp-post-load-more', sptp_Wrapper_ID).html('<span> ' + LoadMoreButton_text + ' </span>');
							} else {
								$(sptp_Wrapper_ID + ' .sptp-post-load-more').hide();
								$(sptp_Wrapper_ID + ' .infinite-scroll-last').show();
								$('.sptp-post-load-more span', sptp_Wrapper_ID + '.pagination_scrl').remove();
							}
						}
					});
				}

				if ($(sptp_Wrapper_ID + ' .sptp-row').hasClass('gridder')) {
					$.ajax({
						type: 'POST',
						url: sptp_vars.ajax_url,
						data: {
							value: sptp_search_value,
							slug: sptp_filter_slug,
							page: 1,
							generator_id: shortcodeId,
							action: 'team_pro_drawer_content',
							nonce: sptp_vars.nonce,
						},
						success: function (response) {
							var $data = $(response);
							var member_data = $('#' + shortcodeId + ' .sptp-drawer-items');
							member_data.html($data);
						}
					});
				}
			}
			// Ajax filter first button click when all button is hidden.
			var $buttonGroup = $(sptp_Wrapper_ID + ' .filters-button-group .fltr-controls:nth-child(1).is-checked');
			setTimeout(function () {
				$buttonGroup.trigger('click');
			}, 300);

			// Ajax filter with button style.
			$(sptp_Wrapper_ID + ' .sptp-live-filter.filters-button-group').on('click', 'button', function (event) {
				var $buttonGroup = $(sptp_Wrapper_ID + ' .filters-button-group');
				$buttonGroup.find('.is-checked').removeClass('is-checked');
				$(this).addClass('is-checked');
				sptp_filter_slug = $(this).data('slug');
				sptp_ajax_actions(sptp_Wrapper_ID);
			});
			// Live filter with dropdown style.
			$(sptp_Wrapper_ID + " .sptp-live-filter .filterSelect").on(
				'change',
				function (e) {
					e.preventDefault();
					e.stopPropagation();
					sptp_filter_slug = $(this).val();
					sptp_ajax_actions(sptp_Wrapper_ID);
				});

			function makeDelay(fn, ms) {
				let timer = 0
				return function (...args) {
					clearTimeout(timer)
					timer = setTimeout(fn.bind(this, ...args), ms || 0)
				}
			}
			// Ajax member Search.
			$(document).on('keyup', '#member_search-' + sptp_container_id, makeDelay(function () {
				sptp_search_value = $(this).val();
				sptp_ajax_actions('#' + sptp_container_id);
			}, 500));

			// Ajax number pagination.
			if ($(sptp_Wrapper_ID + ".pagination_number").length > 0) {
				$(sptp_Wrapper_ID + ".pagination_number").on('click', '.sptp-post-pagination a', function (e) {
					e.preventDefault();
					e.stopPropagation();
					var that = $(this);
					var totalPage = $('.sptp-post-pagination a:not(.next, .prev)', sptp_Wrapper_ID)
						.length,
						currentPage = parseInt(
							$('.sptp-post-pagination .current:not(.next, .prev)', sptp_Wrapper_ID).data('page')),
						page = parseInt(that.data('page'));
					if (that.hasClass('next')) {
						if (totalPage > currentPage) {
							var page = currentPage + 1
						} else {
							return
						}
					}
					if (that.hasClass('prev')) {
						if (currentPage > 1) {
							var page = currentPage - 1
						} else {
							return
						}
					}
					$.ajax({
						type: 'POST',
						url: sptp_vars.ajax_url,
						data: {
							value: sptp_search_value,
							slug: sptp_filter_slug,
							page: page,
							generator_id: shortcodeId,
							action: 'team_pro_search_member',
							nonce: sptp_vars.nonce,
						},
						success: function (response) {
							var $data = $(response);
							var member_data = $(sptp_Wrapper_ID + ' .sptp-grid > .sptp-row, ' + sptp_Wrapper_ID + '  table tbody, ' + sptp_Wrapper_ID + ' .swiper-wrapper, ' + sptp_Wrapper_ID + '.sptp-filter .sptp-filter-grid.sptp-row,' + sptp_Wrapper_ID + ' .sptp-accordion-items').css('opacity', 0);

							member_data.html($data);
							// Carousel.
							if ($(sptp_Wrapper_ID + ".sptp-carousel").length > 0) {
								carouselSlide();
							}
							// Masonry layout.
							if ($(sptp_Wrapper_ID).hasClass("sptp-masonry")) {
								var $post_wrapper = $(".sptp-row", sptp_Wrapper_ID);
								$post_wrapper.masonry("destroy");
								$post_wrapper.html($data).imagesLoaded(function () {
									$post_wrapper.masonry();
								});
							}

							if ($(sptp_Wrapper_ID + ".sptp-filter").length > 0) {
								$sptpgrid.isotope('insert', $data);
							}
							accordion_init();
							// sptp_gridder_init();
							sptp_item_same_height()
							// Thumbnail pager.
							if ((sptp_Wrapper_ID + ' .sptp-thumbnail-page').length > 1) {
								var galleryThumbs = SwiperSlide(sptp_Wrapper_ID + ' .sptp-thumbnail-pager-thumbs', {
									spaceBetween: 0,
									slidesPerView: 10,
									loop: false,
									allowTouchMove: false,
								});
								var galleryTop = SwiperSlide(sptp_Wrapper_ID + ' .sptp-thumbnail-pager-sidebar', {
									loop: false,
									allowTouchMove: false,
									effect: 'fade',
									autoHeight: true,
									thumbs: {
										swiper: galleryThumbs,
									}
								});
							}

							var headerH = ($('body').hasClass('logged-in admin-bar')) ? 32 : 0;
							var targetToID = $($data).parents('.sp-wp-team-pro-wrapper').offset().top - headerH;
							$('html, body').animate({
								scrollTop: targetToID + "px"
							}, 500);

							$('.page-numbers', sptp_Wrapper_ID).removeClass('current');
							$('.page-numbers', sptp_Wrapper_ID).each(function () {
								$('.sptp-post-pagination  a[data-page=' + page + ']', sptp_Wrapper_ID).addClass(
									'current'
								)
							});

							$('.next', sptp_Wrapper_ID).removeClass('current')
							$('.prev', sptp_Wrapper_ID).removeClass('current')
							$('.sptp-post-pagination a.current', sptp_Wrapper_ID).each(function () {

								if (parseInt($(this).data('page')) === totalPage) {
									$('.next', sptp_Wrapper_ID).addClass('current');
								}
								if (parseInt($(this).data('page')) === 1) {
									$('.prev', sptp_Wrapper_ID).addClass('current');
								}
							})
							member_data.css('opacity', 1);
							wpteam_lazyload();
						}
					});
					if ($(sptp_Wrapper_ID + ' .sptp-row').hasClass('gridder')) {
						$.ajax({
							type: 'POST',
							url: sptp_vars.ajax_url,
							data: {
								value: sptp_search_value,
								slug: sptp_filter_slug,
								page: page,
								generator_id: shortcodeId,
								action: 'team_pro_drawer_content',
								nonce: sptp_vars.nonce,
							},
							success: function (response) {
								var $data = $(response);
								var member_data = $(sptp_Wrapper_ID + ' .sptp-drawer-items');
								member_data.html($data);
							}
						});
					}
				});
			}
			// Ajax load more and infinite scroll.
			var LoadMoreButton_text;
			if ($(sptp_Wrapper_ID + ".pagination_btn").length > 0 || $(sptp_Wrapper_ID + ".pagination_scrl").length > 0) {
				var EndingMessage = $(sptp_Wrapper_ID).find('.infinite-scroll-last');
				var ErrorMessage = $(sptp_Wrapper_ID).find('.infinite-scroll-error');
				var PageLoadStatus = $(sptp_Wrapper_ID).find('.page-load-status .loader-ellips.infinite-scroll-request');
				LoadMoreButton_text = $(sptp_Wrapper_ID).find('.sptp-post-load-more').data('buttontext')
				$('.sptp-post-load-more', sptp_Wrapper_ID).attr('data-processing', 0);
				$(sptp_Wrapper_ID + ".pagination_btn, " + sptp_Wrapper_ID + ".pagination_scrl").on('click', '.sptp-post-load-more span', function (e) {
					e.preventDefault();
					e.stopPropagation();
					e.stopImmediatePropagation();
					PageLoadStatus.show();
					var that = $(this);
					var totalPage = $('.sptp-post-pagination a:not(.next, .prev)', sptp_Wrapper_ID).length;
					var currentPage = parseInt($('.sptp-post-pagination .current:not(.next, .prev)', sptp_Wrapper_ID).data('page'));
					var page = currentPage + 1;
					$('.sptp-post-load-more', sptp_Wrapper_ID + '.pagination_scrl').attr('data-processing', 1);
					$.ajax({
						type: 'POST',
						url: sptp_vars.ajax_url,
						data: {
							value: sptp_search_value,
							slug: sptp_filter_slug,
							page: page,
							generator_id: shortcodeId,
							action: 'team_pro_search_member',
							nonce: sptp_vars.nonce,
						},
						success: function (response) {
							var $data = $(response);
							var member_data = $(sptp_Wrapper_ID + ' .sptp-grid > .sptp-row, ' + sptp_Wrapper_ID + '  table tbody, ' + sptp_Wrapper_ID + ' .swiper-wrapper, ' + sptp_Wrapper_ID + '.sptp-filter .sptp-filter-grid.sptp-row, ' + sptp_Wrapper_ID + ' .sptp-accordion-items');
							member_data.append($data);
							if ($(sptp_Wrapper_ID + ".sptp-filter").length > 0) {
								$sptpgrid.isotope('appended', $data);
							}
							// Masonry Layout.
							if ($(sptp_Wrapper_ID).hasClass("sptp-masonry")) {
								var $post_wrapper = $(".sptp-row", sptp_Wrapper_ID);
								$post_wrapper.masonry("destroy");
								$post_wrapper.append($data).imagesLoaded(function () {
									$post_wrapper.masonry();
								});
							}
							// Carousel.
							if ($(sptp_Wrapper_ID + ".sptp-carousel").length > 0) {
								carouselSlide();
							}
							accordion_init();
							sptp_item_same_height();
							if ($(sptp_Wrapper_ID + ".sptp-filter").length > 0) {
								$sptpgrid.isotope('layout');
							}

							$('.page-numbers', sptp_Wrapper_ID).removeClass('current');
							$('.page-numbers', sptp_Wrapper_ID).each(function () {
								$('.sptp-post-pagination  a[data-page=' + page + ']', sptp_Wrapper_ID).addClass(
									'current'
								)
							});

							$('.next', sptp_Wrapper_ID).removeClass('current')
							$('.prev', sptp_Wrapper_ID).removeClass('current')
							$('.sptp-post-pagination a.current', sptp_Wrapper_ID).each(function () {

								if (parseInt($(this).data('page')) === totalPage) {
									$('.next', sptp_Wrapper_ID).addClass('current');
								}
								if (parseInt($(this).data('page')) === 1) {
									$('.prev', sptp_Wrapper_ID).addClass('current');
								}
							})
							if (totalPage == page) {
								$('.sptp-post-load-more span', sptp_Wrapper_ID).remove();
								EndingMessage.show();
							}
							PageLoadStatus.hide();
							$('.sptp-post-load-more', sptp_Wrapper_ID).attr('data-processing', 0);
							wpteam_lazyload();
						}
					});
					$.ajax({
						type: 'POST',
						url: sptp_vars.ajax_url,
						data: {
							value: sptp_search_value,
							slug: sptp_filter_slug,
							page: page,
							generator_id: shortcodeId,
							action: 'team_pro_drawer_content',
							nonce: sptp_vars.nonce,
						},
						success: function (response) {
							var $data = $(response);
							var member_data = $(sptp_Wrapper_ID + ' .sptp-drawer-items');
							member_data.append($data);
						}
					});
				});
			}
			if ($(sptp_Wrapper_ID + ".pagination_scrl").length > 0) {
				var bufferBefore = Math.abs(10);
				var row = $('.sptp-row, table tbody', sptp_Wrapper_ID);
				if (row.length) {
					$(window).on('scroll', function (e) {
						e.preventDefault();
						var TopAndContent = row.offset().top + row.outerHeight();
						var totalPage = $('.sptp-post-pagination a:not(.next, .prev)', sptp_Wrapper_ID).length;
						var areaLeft = TopAndContent - $(window).scrollTop();
						totalPage = totalPage + 1;
						if (areaLeft - bufferBefore < $(window).height()) {
							if ($('.sptp-post-load-more', sptp_Wrapper_ID).attr('data-processing') == 0) {
								$('.sptp-post-load-more span', sptp_Wrapper_ID).trigger('click');
							}
						}

					})
				}

			}
		})

		// Gallery caption image;
		function gallery_caption_hover(shortcodeId) {
			var sptp_gallery = $('#' + shortcodeId + " .swiper-slide");
			sptp_gallery.on('mousemove',
				function () {
					if ($(this).find('.sptp_gallery_image_caption').hasClass('sptp_gallery_image_caption')) {
						$('#' + shortcodeId + ".popup-open .sptp-pagination").css({
							'bottom': '60px'
						})
					} else {
						$('#' + shortcodeId + ".popup-open .sptp-pagination").css({
							'bottom': '10px'
						})
					}
				}
			);
			var sptp_gallery = $('#' + shortcodeId + " .sptp-member-avatar-area");
			sptp_gallery.on('mouseleave',
				function () {
					if ($(this).find('.sptp_gallery_image_caption').hasClass('sptp_gallery_image_caption')) {
						$('#' + shortcodeId + ".popup-open .sptp-pagination").css({
							'bottom': '10px'
						})
					}
				}
			);
		}

		function sptp_post_id_list(selector) {
			var list = new Array()
			selector.find('.sp-team-pro-item')
				.each(function (index) {
					list.push($(this).data('member'))
				})
			return list
		}
		// Return array key number of a value.
		function sptp_val2key(val, array) {
			for (var all_key in array) {
				if (array[all_key] == val) {
					return all_key
				}
			}
			return false
		}

		// Go to previous array key.
		function sptp_array_key_next(all_key, sptp_id_length) {
			all_key--
			if (all_key < 0) {
				all_key = sptp_id_length - 1
			}
			return all_key
		}

		// Go to next array key.
		function sptp_array_key_prev(all_key, sptp_id_length) {
			all_key++
			if (all_key > sptp_id_length - 1) {
				all_key = 0
			}
			return all_key
		}
		// Progress bar animation on loading.
		function progressBarAnimation() {
			$(".sptp-progress-container").each(function () {
				var percent = $(this).data("title");
				$(this)
					.find(".sptp-progress-bar")
					.animate({
						width: percent
					},
						1000
					);
				var percentInt = parseInt(percent);
				if (percentInt >= 95) {
					$(this)
						.find(".sptp-top")
						.css("right", 0);
				}
				if (percentInt === 100) {
					$(this)
						.find(".sptp-top")
						.css("width", "40px");
				}
			});
		}

		// Change Popup content on next prev button click.
		function popup_next_prev($data, shortcode_id, load_type, sptp_Wrapper_ID = '') {
			var selector = $('#' + shortcode_id + '.sptp-modal');
			var icon_shape = selector.data('icon');
			var modalshow = selector.data('modalshow');
			var modalshow = modalshow.split(',');
			if ('true' == load_type) {
				var $data = modal_json_to_plain_html($data, modalshow, icon_shape, sptp_Wrapper_ID);
			}
			var nextPrevContent = $('.sptp-popup-item');
			nextPrevContent.html($data);
			setTimeout(() => {
				var modelCarouselData = $('.sptp-popup-carousel').data('carousel');
				var loop = $('.sptp-popup-carousel .swiper-slide:not(.swiper-slide-duplicate )').length > 1 ? true : false;
				var autoplay = modelCarouselData ? modelCarouselData.autoplay : false;
				var modal_swiper = SwiperSlide('.sptp-popup-carousel', {
					loop: loop,
					autoplay: autoplay ? ({ delay: 5000 }) : false,
					navigation: {
						nextEl: '.sptp-button-next.swiper-button-next',
						prevEl: '.sptp-button-prev.swiper-button-prev',
					},
					autoHeight: true,
					pagination: {
						el: '.sptp-pagination.swiper-pagination',
						clickable: true,
					}
				});
				$('.sptp-popup-content-main.text-center').css({
					'opacity': '1',
					'transform': 'translateY(0px)',
					'transition': '.6s'
				})

				$('.sp-team-pro.sptp-section.style-1.popup-open').css({
					'transform': 'translate(-50%, -45%)',
					'opacity': '0',
					'visibility': 'hidden',
					'transition': '.2s'
				});
				var sptpPaginationSingle = $('.popup-open .sptp-pagination.swiper-pagination').children().length;
				if (sptpPaginationSingle < 2) {
					$('.popup-open .sptp-pagination.swiper-pagination').hide();
				}
			}, 0);

			setTimeout(() => {
				$('.sp-team-pro.sptp-section.style-1.popup-open').css({
					'transform': 'translate(-50%, -50%)',
					'opacity': '1',
					'visibility': 'visible',
					'transition': '.4s'
				});
			}, 300);
			progressBarAnimation();
		}

		// Modal option init with this function.
		function modal_json_to_plain_html(item, modalshow, icon_shape, sptp_Wrapper_ID) {
			var skeleton = $(sptp_Wrapper_ID + '+.sptp-skeleton').data('skeleton');
			var customdiv = document.createElement('div');
			customdiv.innerHTML = skeleton;
			// Member image.
			if ($.inArray("img", modalshow) != -1 && (typeof item.thumbs != "undefined") && item.thumbs.length > 1) {
				$(customdiv).find('.sptp-member-avatar-area .swiper-wrapper').append(item.thumbs)
			} else {
				$(customdiv).find('.sptp-member-avatar-area').remove();
			}
			// Member name.
			if ($.inArray("name", modalshow) != -1 && (typeof item.name != "undefined") && item.name.length > 1) {
				$(customdiv).find('.sptp-member-name .sptp-name').append(item.name);
			} else {
				$(customdiv).find('.sptp-member-name').remove();
			}
			// Member profession.
			if ($.inArray("position", modalshow) != -1 && (typeof item.job_title != "undefined") && item.job_title.length > 1) {
				$(customdiv).find('.sptp-member-profession .sptp-profession-text').append(item.job_title);
			} else {
				$(customdiv).find('.sptp-member-profession').remove();
			}
			// Member Description.
			if ($.inArray("desc", modalshow) != -1 && (typeof item.desc != "undefined") && item.desc.length > 1) {
				$(customdiv).find('.sptp-member-desc').append(item.desc);
			} else {
				$(customdiv).find('.sptp-member-desc').remove();
			}
			// Member Email.
			if ($.inArray("email", modalshow) != -1 && (typeof item.email != "undefined") && item.email.length > 1) {
				$(customdiv).find('.sptp-member-email').append(item.email);
			} else {
				$(customdiv).find('.sptp-member-email').remove();
			}
			// Member mobile.
			if ($.inArray("mobile", modalshow) != -1 && (typeof item.mobile != "undefined") && item.mobile.length > 1) {
				$(customdiv).find('.sptp-member-mobile').append(item.mobile);
			} else {
				$(customdiv).find('.sptp-member-mobile').remove();
			}
			// Member phone number.
			if ($.inArray("phone", modalshow) != -1 && (typeof item.phone != "undefined") && item.phone.length > 1) {
				$(customdiv).find('.sptp-member-phone').append(item.phone);
			} else {
				$(customdiv).find('.sptp-member-phone').remove();
			}
			// Member experience.
			if ($.inArray("experience", modalshow) != -1 && (typeof item.experience != "undefined") && item.experience.length > 1) {
				$(customdiv).find('.sptp-member-experience').append(item.experience);
			} else {
				$(customdiv).find('.sptp-member-experience').remove();
			}
			// Member location.
			if ($.inArray("location", modalshow) != -1 && (typeof item.location != "undefined") && item.location.length > 1) {
				$(customdiv).find('.sptp-member-location a').attr('href', `https://www.google.com/maps/search/?api=1&query=${item.location}`);
				$(customdiv).find('.sptp-member-location span').append(item.location);
			} else {
				$(customdiv).find('.sptp-member-location a').attr('href', `https://www.google.com/maps/search/?api=1&query=${item.location}`);
				$(customdiv).find('.sptp-member-location').remove();
			}
			// Member website.
			if ($.inArray("website", modalshow) != -1 && (typeof item.website != "undefined") && item.website.length > 1) {
				$(customdiv).find('.sptp-member-website').append(item.website);
			} else {
				$(customdiv).find('.sptp-member-website').remove();
			}
			// Member extra fields.
			if ($.inArray("extra_fields_switch", modalshow) != -1 && (typeof item.extra_fields != "undefined") && item.extra_fields.length > 1) {
				$(customdiv).find('.sptp-member-extra-fields').append(item.extra_fields);
			} else {
				$(customdiv).find('.sptp-member-extra-fields').remove();
			}
			// Member Skill.
			if ($.inArray("skills", modalshow) != -1 && (typeof item.skills != "undefined") && item.skills.length > 1) {
				$(customdiv).find('.sptp-member-skill-progress').append(item.skills);
			} else {
				$(customdiv).find('.sptp-member-skill-progress').remove();
			}
			// Member Social profiles.
			if ($.inArray("social_profiles", modalshow) != -1 && (typeof item.social != "undefined") && item.social.length > 1) {
				$(customdiv).find('.sptp-member-social ul').append(item.social);
			} else {
				$(customdiv).find('.sptp-member-social').remove();
			}
			// Member author posts.
			if ($.inArray("author_posts_detail", modalshow) != -1 && (typeof item.author_post != "undefined") && item.author_post.length > 1) {
				$(customdiv).find('.sptp-member-post ul').append(item.author_post);
			} else {
				$(customdiv).find('.sptp-member-post').remove();
			}
			// Social add class icon shape.
			$(customdiv).find('.sptp-member-social').removeClass('circle').addClass(icon_shape);
			var data = customdiv.innerHTML;
			customdiv.remove();
			return `<div class="sptp-popup-content-main text-center">` + data + `</div>`;
		}

		// Check Element in viewport.
		function isElementInViewport(el) {
			var elementTop = $(el).offset().top;
			var elementBottom = elementTop + $(el).outerHeight();
			var viewportTop = $(window).scrollTop();
			var viewportBottom = viewportTop + $(window).height();
			return elementBottom > viewportTop && elementTop < viewportBottom;
		};
		// Popup init function.
		function ajax_popup_init(sid, sptp_Wrapper_ID) {
			var json_data = Array();
			var rest_url = $(sptp_Wrapper_ID + '.sptp-modal').data('rest-url');
			$.ajax({
				url: rest_url + sid,
				async: true,
				dataType: 'json',
				success: function (response) {
					json_data[sid] = response;
					var sptp_id_list;
					var sptp_array_key;
					var sptp_id_length;
					// Triggering modal.
					$(document).on('click', sptp_Wrapper_ID + '.sptp-modal .sptp-member-avatar:not(.custom-link),' + sptp_Wrapper_ID + '.sptp-modal .sptp-member-read-more-button, ' + sptp_Wrapper_ID + '.sptp-modal .member_name_clickable', function (e) {
						e.preventDefault();
						e.stopPropagation();
						e.stopImmediatePropagation();
						var that = $(this);
						var selector = $(sptp_Wrapper_ID + '.sptp-modal');
						var modal_type = selector.data('modal-type');
						var layout = selector.data('layout');
						var pdfbtn = selector.data('pdfbtn');
						var icon_shape = selector.data('icon');
						var modalshow = selector.data('modalshow');
						var modalshow = modalshow.split(',');
						var shortcodeId = that.parents('.sp-team-pro').attr('id');
						var unique_uid = Date.now();
						memberId = that.parents('.sp-team-pro-item').data('member');
						sptp_id_list = sptp_post_id_list(selector);
						sptp_array_key = sptp_val2key(memberId, sptp_id_list);
						sptp_id_length = sptp_id_list.length;
						var multiple_btn_style1 = '';
						var multiple_btn_style2 = '';
						var pdfbtn_text = '';
						if (pdfbtn) {
							pdfbtn_text = `<button id="sp-team-generate-pdf-file">Download PDF File</button>`;
						}
						if ('multiple' == modal_type) {
							multiple_btn_style1 = `<div class="sptp-popup-style1-navigation"> <a href="#" class="sptp-nav-item sptp-nav-next"><i class="fa fa-angle-left"></i></a><a href="#" class="sptp-nav-item sptp-nav-prev"><i class="fa fa-angle-right"></i></a></div><button type="button" class="mfp-close"></button>`;
							multiple_btn_style2 = `<div class="sptp-popup-style2-navigation"> <a href="#" class="sptp-nav-item sptp-nav-next"><i class="fa fa-angle-left"></i></a> <a href="#" class="sptp-nav-item sptp-nav-prev"><i class="fa fa-angle-right"></i></a></div><button type="button" class="mfp-close"></button>`;
						}
						// json_data[sid]
						var $item = json_data[sid][memberId];
						var $data = modal_json_to_plain_html($item, modalshow, icon_shape, sptp_Wrapper_ID);
						var $data = `<section class="sptp-popup-section ` + unique_uid + ` ` + layout + `">` + multiple_btn_style1 + `<div id="` + shortcodeId + `" class="sp-team-pro sptp-section ` + layout + ` popup-open"><div class="sptp-popup-header"> ` + multiple_btn_style2 + `  <button title="Close (Esc)" type="button" class="mfp-close"></button> </div> <button type="button" class="mfp-close"></button> <div class="sptp-popup-item sp-team-popup-item-section">` + $data + ` </div> ` + pdfbtn_text + ` </div> </section>`;
						$.magnificPopup.open({
							type: 'inline',
							mainClass: 'sptp-popup popup-open',
							showCloseBtn: true,
							closeBtnInshortcode_ide: true,
							enableEscapeall_key: true,
							closeOnBgClick: true,
							fixedContentPos: true,
							fixedBgPos: true,
							items: {
								src: $data
							},
							callbacks: {
								open: function () {
									sptp_id_length = sptp_id_list.length;
									sptp_array_key = sptp_val2key(memberId, sptp_id_list);
								}
							}
						});
						setTimeout(() => {
							$('.sp-team-pro.sptp-section.style-1.popup-open').css({
								'opacity': '1',
								'transform': 'translate(-50%, -50%)'
							});
							$('.sp-team-pro.sptp-section.style-3.popup-open').css({
								'opacity': '1',
								'transform': 'translateX(0px)'
							});
							$('.sp-team-pro.sptp-section.style-4.popup-open').css({
								'opacity': '1',
								'transform': 'translate(-50%, 0px)'
							});
							$('.sp-team-pro.sptp-section.style-2.popup-open').css({
								'opacity': '1',
								'transform': 'translateX(0px)'
							});
							$('.sptp-popup-content-main.text-center').css({
								'opacity': '1',
								'transform': 'translateY(0px)'
							});
							gallery_caption_hover(shortcodeId);
							progressBarAnimation();
							team_pro_generate_pdf();
							var modelCarouselData = $('.sptp-popup-carousel').data('carousel');
							var autoplay = modelCarouselData ? modelCarouselData.autoplay : false;
							var loop = $('.sptp-popup-carousel .swiper-slide:not(.swiper-slide-duplicate )').length > 1 ? true : false;
							var modal_swiper = SwiperSlide('.sptp-popup-carousel', {
								loop: loop,
								autoplay: autoplay ? ({ delay: 5000 }) : false,
								navigation: {
									nextEl: '.sptp-button-next.swiper-button-next',
									prevEl: '.sptp-button-prev.swiper-button-prev',
								},
								// clickable: true,
								autoHeight: true,
								pagination: {
									el: '.sptp-pagination.swiper-pagination',
									clickable: true,
								}
							});
							var sptpPaginationSingle = $('.popup-open .sptp-pagination.swiper-pagination').children().length;
							if (sptpPaginationSingle < 2) {
								$('.popup-open .sptp-pagination.swiper-pagination').hide();
							}
						}, 0);

						// Triggering Modal next.
						$(document).on('click', '.' + unique_uid + ' .sptp-nav-item.sptp-nav-next', function (event) {
							event.preventDefault();
							event.stopPropagation();
							var that = $(this);
							var shortcodeId = that.parents('.mfp-content').find('.sp-team-pro').attr('id');
							if (typeof sptp_id_list != 'undefined') {
								sptp_array_key = sptp_array_key_next(sptp_array_key, sptp_id_length);
								popup_next_prev(json_data[sid][sptp_id_list[sptp_array_key]], shortcodeId, 'true', sptp_Wrapper_ID);
							}
						});
						// Triggering Modal Prev.
						$(document).on('click', '.' + unique_uid + ' .sptp-nav-item.sptp-nav-prev', function (event) {
							event.preventDefault();
							event.stopPropagation();
							var that = $(this);
							var shortcodeId = that.parents('.mfp-content').find('.sp-team-pro').attr('id');
							if (typeof sptp_id_list != 'undefined') {
								sptp_array_key = sptp_array_key_prev(sptp_array_key, sptp_id_length);
								popup_next_prev(json_data[sid][sptp_id_list[sptp_array_key]], shortcodeId, 'true', sptp_Wrapper_ID);
							}
						});
					});
				}
			});
		}
		// Modal popup.
		$('.sp-team-pro.sptp-modal').each(function () {
			var sptp_container = $(this),
				sptp_container_id = sptp_container.attr('id'),
				sptp_Wrapper_ID = '#' + sptp_container_id,
				shortcode_id_array = Array(),
				sid = $(sptp_Wrapper_ID).data('id');
			// Init popup after loading modal API.
			if (sptp_vars.load_type) {
				if (isElementInViewport(sptp_Wrapper_ID) && jQuery.inArray(sptp_Wrapper_ID, shortcode_id_array) == -1) {
					shortcode_id_array.push(sptp_Wrapper_ID);
					ajax_popup_init(sid, sptp_Wrapper_ID);
				}
				window.addEventListener('scroll', function () {
					if (isElementInViewport(sptp_Wrapper_ID) && jQuery.inArray(sptp_Wrapper_ID, shortcode_id_array) == -1) {
						shortcode_id_array.push(sptp_Wrapper_ID);
						ajax_popup_init(sid, sptp_Wrapper_ID);
					}
				}, true);
			} else {
				// Modal load by data attr.
				var sptp_id_list;
				var sptp_array_key;
				var sptp_id_length;
				// Triggering Modal next.
				$(document).on('click', '.sptp-nav-item.sptp-nav-next', function (event) {
					event.preventDefault();
					event.stopPropagation();
					var that = $(this);
					var shortcodeId = that.parents('.mfp-content').find('.sp-team-pro').attr('id');
					if (typeof sptp_id_list != 'undefined') {
						sptp_array_key = sptp_array_key_next(sptp_array_key, sptp_id_length);
						var current_id = sptp_id_list[sptp_array_key];
						var $item = $('#' + shortcodeId + '.sptp-modal').find('.sp-team-pro-item[data-member="' + current_id + '"]').find('.modal-data').data('modal');
						popup_next_prev($item, shortcodeId, 'false');
					}
				});
				// Triggering Modal Prev.
				$(document).on('click', '.sptp-nav-item.sptp-nav-prev', function (event) {
					event.preventDefault();
					event.stopPropagation();
					var that = $(this);
					var shortcodeId = that.parents('.mfp-content').find('.sp-team-pro').attr('id');
					if (typeof sptp_id_list != 'undefined') {
						sptp_array_key = sptp_array_key_prev(sptp_array_key, sptp_id_length);
						var current_id = sptp_id_list[sptp_array_key];
						var $item = $('#' + shortcodeId + '.sptp-modal').find('.sp-team-pro-item[data-member="' + current_id + '"]').find('.modal-data').data('modal');
						popup_next_prev($item, shortcodeId, 'false');
					}
				});
				// Triggering modal.
				$(document).on('click', '.sptp-modal .sptp-member-avatar, .sptp-modal .sptp-member-read-more-button, .sptp-modal .member_name_clickable', function (e) {
					e.preventDefault();
					e.stopPropagation();
					e.stopImmediatePropagation();
					var that = $(this);
					var selector = that.parents('.sptp-modal');
					var modal_type = selector.data('modal-type');
					var layout = selector.data('layout');
					var pdfbtn = selector.data('pdfbtn');
					var icon_shape = selector.data('icon');
					var modalshow = selector.data('modalshow');
					var modalshow = modalshow.split(',');
					var shortcodeId = that.parents('.sp-team-pro').attr('id');
					memberId = that.parents('.sp-team-pro-item').data('member');
					sptp_id_list = sptp_post_id_list(selector);
					sptp_array_key = sptp_val2key(memberId, sptp_id_list);
					sptp_id_length = sptp_id_list.length;
					var multiple_btn_style1 = '';
					var multiple_btn_style2 = '';
					var pdfbtn_text = '';
					var modal_navigation = '';
					if (pdfbtn) {
						pdfbtn_text = `<button id="sp-team-generate-pdf-file">Download PDF File</button>`;
					}
					if ('multiple' == modal_type) {
						modal_navigation = `<a href="#" class="sptp-nav-item sptp-nav-next"><i class="fa fa-angle-left"></i></a> <a href="#" class="sptp-nav-item sptp-nav-prev"><i class="fa fa-angle-right"></i></a>`;
					}
					multiple_btn_style1 = `<div class="sptp-popup-style1-navigation"> ` + modal_navigation + ` </div><button type="button" class="mfp-close"></button>`;
					multiple_btn_style2 = `<div class="sptp-popup-style2-navigation">  ` + modal_navigation + ` </div><button type="button" class="mfp-close"></button>`;
					var member_content = that.parents('.sp-team-pro-item').find('.modal-data').data('modal');
					// var customTextarea = document.createElement('textarea');
					// customTextarea.innerHTML = member_content;
					var $data = member_content;
					var $data = `<section class="sptp-popup-section ` + layout + `">` + multiple_btn_style1 + ` <div id="` + shortcodeId + `" class="sp-team-pro sptp-section ` + layout + ` popup-open"><div class="sptp-popup-header"> ` + multiple_btn_style2 + `
                    </div>
                    <button type="button" class="mfp-close"></button>
                <div class="sptp-popup-item sp-team-popup-item-section">` + $data + ` </div>
                `+ pdfbtn_text + `
            </div>
        </section>`;
					$.magnificPopup.open({
						type: 'inline',
						mainClass: 'popup-open',
						showCloseBtn: true,
						closeBtnInshortcode_ide: true,
						enableEscapeall_key: true,
						closeOnBgClick: true,
						fixedContentPos: true,
						fixedBgPos: true,
						items: {
							src: $data
						},
						callbacks: {
							open: function () {
								sptp_id_length = sptp_id_list.length;
								sptp_array_key = sptp_val2key(memberId, sptp_id_list);
							}
						}
					});
					setTimeout(() => {
						$('.sp-team-pro.sptp-section.style-1.popup-open').css({
							'opacity': '1',
							'transform': 'translate(-50%, -50%)'
						});
						$('.sp-team-pro.sptp-section.style-3.popup-open').css({
							'opacity': '1',
							'transform': 'translateX(0px)'
						});
						$('.sp-team-pro.sptp-section.style-4.popup-open').css({
							'opacity': '1',
							'transform': 'translate(-50%, 0px)'
						});
						$('.sp-team-pro.sptp-section.style-2.popup-open').css({
							'opacity': '1',
							'transform': 'translateX(0px)'
						});
						$('.sptp-popup-content-main.text-center').css({
							'opacity': '1',
							'transform': 'translateY(0px)'
						});
						gallery_caption_hover(shortcodeId);
						progressBarAnimation();
						team_pro_generate_pdf();
						var modelCarouselData = $('.sptp-popup-carousel').data('carousel');
						var autoplay = modelCarouselData ? modelCarouselData.autoplay : false;
						var loop = $('.sptp-popup-carousel .swiper-slide:not(.swiper-slide-duplicate )').length > 1 ? true : false;
						var modal_swiper = SwiperSlide('.sptp-popup-carousel', {
							loop: loop,
							autoplay: autoplay ? ({ delay: 5000 }) : false,
							navigation: {
								nextEl: '.sptp-button-next.swiper-button-next',
								prevEl: '.sptp-button-prev.swiper-button-prev',
							},
							// clickable: true,
							autoHeight: true,
							pagination: {
								el: '.sptp-pagination.swiper-pagination',
								clickable: true,
							}
						});
						var sptpPaginationSingle = $('.popup-open .sptp-pagination.swiper-pagination').children().length;
						if (sptpPaginationSingle < 2) {
							$('.popup-open .sptp-pagination.swiper-pagination').hide();
						}
					}, 0);
				});
			}
		});

		wpteam_lazyload();
	}

	$(document).on("click", ".sptp-content-on-image .sptp-content", function (e) {
		if (!$(this).find('.sptp-member-social').hasClass('sptp-member-social')) {
			if (!$(this).parents('.sptp-drawer').hasClass('sptp-drawer')) {
				$(this)
					.parents(".sptp-content-on-image")
					.find(".sptp-image .sptp-member-avatar.sptp-popup-trigger")
					.trigger('click');
			}
		}
	});


	// Generate WP Team member PDF file.
	function team_pro_generate_pdf() {
		$("#sp-team-generate-pdf-file").on('click', function (e) {
			e.preventDefault();
			$("#sp-team-generate-pdf-file").css("display", "none");
			$(".sptp-popup-header").css("display", "none");
			$(".sptp-pagination,.sptp-button-next,.sptp-button-prev").css("display", "none");
			$(".sp-team-pro.sptp-section .sptp-popup-content-main .sptp-member-avatar-area").css({ "width": "400px", 'margin-bottom': '10px' });
			var item_section = $('.sptp-popup-item').hasClass('sp-team-popup-item-section');

			if (item_section) {
				var element = $('.sp-team-pro.sptp-section')[0];
			} else {
				var element = $('.sptp-single-post')[0];
			}
			var oldTitle = document.title;

			var member_name = $(element).find('.sptp-member-name')[0].innerText;

			document.title = member_name.replace(' ', '-') + '-Wp-Team';

			$(element).printThis({
				printContainer: false,
			});

			setTimeout(function () {
				$('#sp-team-generate-pdf-file').show();
				$(".sptp-section.popup-open:not(.style-1) .sptp-popup-header").show();
				$(".sptp-pagination,.sptp-button-next,.sptp-button-prev").css("display", "block");
				document.title = oldTitle;
			}, 2000);

		});
	}
	team_pro_generate_pdf();

	$('.sp-wp-team-pro-wrapper').addClass('sp-wp-team-loaded');
});

// Preloader js
var sptp_preloaders = document.querySelectorAll('.sp-team-pro.sptp-section');
document.querySelectorAll('.wp-team-pro-preloader').forEach(function (item) {
	item.style.opacity = '1';
})
sptp_preloaders.forEach(function (preloader) {
	window.addEventListener('load', function () {
		var preloaderId = preloader.id;
		var preloaderImg = preloader.querySelector('#' + preloaderId + ' .sp-team-pro-page-loading-image');
		if (preloaderImg != null) {
			preloaderImg.style.visibility = 'hidden';
		}
	})
})

