/*
= GET WINDOW WIDTH
------------------------------------------------------------------------------------- */

    function viewport() {
        var e = window,
            a = 'inner';
        if (!('innerWidth' in window)) {
            a = 'client';
            e = document.documentElement || document.body;
        };
        return { width: e[a + 'Width'] };
    };

/*
= MAIN CONTROLLER
-------------------------------------------------------------------------------------- */

    var btdgtl = {
        windowW: 0,
        windowH: $(window).height(),
        html: $('html'),
        body: $('body'),
        device: null,
        distanceFromTop: 0,
        lastDistanceFromTop: 0,
        resizeTimeout: null,
        navOpened: false,
        imagesLoaded: false,
        videoFinished: false,
        header: $('header'),
        footer: $('footer'),
        init: function() {

        /*
        + Preloading */

            btdgtl.body.preloading({
                beforeComplete: function() {
                    if (window.location.hash) {
                        var currHash = window.location.hash,
                            newHash = currHash.substr(1, currHash.length),
                            curr = $('section[data-hash="' + newHash + '"]'),
                            currOffset = curr.offset().top;
                        if (btdgtl.device != 'mobile' && curr.hasClass('fixed-section')) {
                            if (curr.height() < btdgtl.windowH)
                                currOffset = curr.offset().top - (btdgtl.windowH - curr.outerHeight()) / 2
                        }                            
                        $('html, body').stop().animate({
                            'scrollTop': currOffset + 1
                        }, 1000, 'easeInOutCubic');
                    }
                    btdgtl.resize();
                    btdgtl.imagesLoaded = true;
                    //if (btdgtl.videoFinished)
                    btdgtl.body.addClass('init-anim')

                },
                onComplete: function() {}
            });

        /*
        + Detecting device */

            if (btdgtl.html.hasClass('desktop')) { btdgtl.device = 'desktop'; }
            else if (btdgtl.html.hasClass('tablet')) { btdgtl.device = 'tablet'; }
            else if (btdgtl.html.hasClass('mobile')) { btdgtl.device = 'mobile'; }

        /*
        + Choosing theme */

            btdgtl.device == 'desktop' ?
                this.desktop.init() :
                this.handheld.init();

        },
        transformSetter: function(x, y, scale) {
            return {
                '-webkit-transform': 'translateX(' + x + ') translateY(' + y + ') translateZ(0px) rotate(0deg) scale(' + scale + ')',
                '-moz-transform': 'translateX(' + x + ') translateY(' + y + ') translateZ(0px) rotate(0deg) scale(' + scale + ')',
                'transform': 'translateX(' + x + ') translateY(' + y + ') translateZ(0px) rotate(0deg) scale(' + scale + ')',
            }
        },
        transitionSetter: function(property, duration, delay, easing) {
            return {
                '-webkit-transition': property + ' ' + duration + ' ' + delay + ' ' + easing,
                '-moz-transition': property + ' ' + duration + ' ' + delay + ' ' + easing,
                '-o-transition': property + ' ' + duration + ' ' + delay + ' ' + easing,
                '-ms-transition': property + ' ' + duration + ' ' + delay + ' ' + easing,
                'transition': property + ' ' + duration + ' ' + delay + ' ' + easing,
            }           
        },
        delaySetter: function(delay) {
            return {
                '-webkit-transition-delay': delay + 'ms',
                '-moz-transition-delay': delay + 'ms',
                '-ms-transition-delay': delay + 'ms',
                '-o-transition-delay': delay + 'ms',
                'transition-delay': delay + 'ms'
            }
        },      
        common: { 
            parallaxOffsets: [],
            animatedOffsets: [], 
            darkHeights: [],  
            texts: [],
            fixedOffsets: [],
            bodyH: 0,
            footerH: 0,
            logo: {
                top: 0,
                height: 0
            },
            parallaxPosition: function(element, index) {

                var currSpeed = element.data('speed'),
                    siteTopOffset = this.parallaxOffsets[index].top < btdgtl.windowH ? btdgtl.windowH - this.parallaxOffsets[index].top : 0,
                    currMovement = currSpeed * (this.parallaxOffsets[index].top - btdgtl.lastDistanceFromTop - btdgtl.windowH + siteTopOffset);
                currMovement += 0;
                if (((currSpeed < 0 && currMovement < 0) || (currSpeed > 0 && currMovement > 0))) currMovement = 0;
                element.css(btdgtl.transformSetter('0px', currMovement + 'px', 1));

            }, 
            
            init: function() {
				
            /*
            + Prevent scrolling */

                window.addEventListener('scroll', function(e) {
                    if (btdgtl.navOpened) {
                        e.preventDefault();
                        e.stopPropagation();
                        return false;
                    }
                }, {passive: false});
                window.addEventListener('mousewheel', function(e) {
                    if (btdgtl.navOpened) {
                        e.preventDefault();
                        e.stopPropagation();
                        return false;
                    }
                }, {passive: false});
                window.addEventListener('touchmove', function(e) {
                    if (btdgtl.navOpened) {
                        e.preventDefault();
                        e.stopPropagation();
                        return false;
                    }
                }, {passive: false});   

            /*
            + Call resize functionality */

                this.resize();

            /*
            + Scroll animations */

                var raf;

                if (typeof raf == 'undefined') scrollingAnimation();

                function scrollingAnimation() {

                    btdgtl.distanceFromTop = $(window).scrollTop();

                    if (Math.abs(btdgtl.lastDistanceFromTop - btdgtl.distanceFromTop) >= 1) {

                        dY = btdgtl.distanceFromTop - btdgtl.lastDistanceFromTop;
                        btdgtl.lastDistanceFromTop += (dY / 10); 


                    /*
                    + Parallax movement (if it's in view) */

                        $('.parallax').each(function(i) {
                            var curr = $(this);
                            if (btdgtl.common.parallaxOffsets[i].top - btdgtl.distanceFromTop  < btdgtl.windowH &&
                                btdgtl.distanceFromTop - (btdgtl.common.parallaxOffsets[i].top + btdgtl.common.parallaxOffsets[i].height) <= 0) {
                                btdgtl.common.parallaxPosition(curr, i);
                            }
                        });

                    /*
                    + Animate element (if it's in view) */

                        $('.animated').each(function(i) {
                            var curr = $(this),
                                currOffset = btdgtl.windowH;
                            if (btdgtl.common.animatedOffsets[i].top - btdgtl.distanceFromTop < currOffset)
                                curr.addClass('in-view');
                        });

                    /*
                    + Main navigation */
					if (btdgtl.distanceFromTop > 0) {
						btdgtl.distanceFromTop > btdgtl.lastDistanceFromTop ?
							btdgtl.body.addClass('going-down').removeClass('going-up') :
							btdgtl.body.addClass('going-up').removeClass('going-down');
					}                    

                    }

                    raf = requestAnimationFrame(scrollingAnimation);

                };

            },
            resize: function() {

            /*
            + Setting animated elements' initial positions / offsets */

                this.parallaxOffsets = [];
                this.animatedOffsets = [];
                this.darkHeights = [];
                this.fixedOffsets = []

                $('.parallax, .animated').each(function(i) {
                    var curr = $(this),
                        currParam = {
                            top: curr.offset().top,
                            height: curr.outerHeight()
                        };
                    curr.hasClass('parallax') ?
                        btdgtl.common.parallaxOffsets.push(currParam) :
                        btdgtl.common.animatedOffsets.push(currParam);
                    if (curr.hasClass('animated')) {
                        if (curr.offset().top - btdgtl.distanceFromTop < btdgtl.windowH)
                            curr.addClass('in-view')
                    }
                });

                $('.parallax').each(function(i) {
                   btdgtl.common.parallaxPosition($(this), i);
                });

                this.logo.top = $(window).width() <= 768 && (!btdgtl.html.hasClass('desktop') && btdgtl.html.hasClass('portrait')) ? 
                    parseInt(btdgtl.header.children().css('padding-top')) :
                    parseInt(btdgtl.header.children().css('padding-top')) + 1;
                this.logo.height = $('.logo .shape').height();


            },
        },   
        desktop: {
            init: function() {

            /*
            + Call common functionality */

                btdgtl.common.init();

            /*
            + Call resize functionality */

                this.resize();

            },
            resize: function() {

            }
        },
        handheld: {
            init: function() {

            /*
            + Call common functionality */

                btdgtl.common.init();

            /*
            + Call resize functionality */

                this.resize();

            /*
            + Scrolling animation */

                var raf;

                if (typeof raf == 'undefined') scrollingAnimation();

                function scrollingAnimation() {

                    raf = requestAnimationFrame(scrollingAnimation);

                };

            },
            resize: function() {

            }
        },
        resize: function() {

            if (this.device == 'desktop' || this.windowW != $(window).width()) {

                if (this.resizeTimeout != null) {
                    clearTimeout(this.resizeTimeout)
                    this.resizeTimeout = null;
                }

                this.resizeTimeout = setTimeout(function() {

                    btdgtl.windowW = $(window).width();
                    btdgtl.windowH = $(window).height();

                    btdgtl.common.resize();

                    btdgtl.device == 'desktop' ?
                        btdgtl.desktop.resize() :
                        btdgtl.handheld.resize();

                    clearTimeout(btdgtl.resizeTimeout)
                    btdgtl.resizeTimeout = null;

                }, 500)

            }

        }
    }

    $(window).resize(function() {
        btdgtl.resize();
    })    

    btdgtl.init();

    btdgtl.resize();


$(document).ready(function(){
    
	// Add animated class to elements
	$('.regular-content .entry h3, .regular-content .entry p, .regular-content .entry ul, .regular-content .entry h4, .regular-content .entry img, .regular-content .entry article, .stats-module .section-title, .stats-module h2, .stats-content article, .btn, .more-link').each(
		function() {
			$(this).addClass('animated');
		}
	);
    
    $(window).scroll(function () {
        var scroll = $(window).scrollTop();

        if (scroll <= 20) {
            $('body').addClass('header-in-view');
        } else {
            $('body').removeClass('header-in-view');
        }
    });
	
	/* Info boxes
	$('.info-trigger').click(function(){
		$('.info-box-outer').removeClass('active');
		$(this).parents('.info-box-outer').addClass('active');
		return false;
	});
	
	$('.close').click(function(){
		$(this).parents('.info-box-outer').removeClass('active');
		return false;
	}); */
	
	
	// Mobile menu
	$('.mobile-nav-trigger').click(function(){
		$(this).toggleClass('active');
		if($(this).hasClass('active')) {
			$('html').addClass('menu-active');
			$('header .main-nav ').animate({
				right: '0'
			}, 300);
		} else {
			$('html').removeClass('menu-active');
			$('header .main-nav ').animate({
				right: '-380px'
			}, 300);
		}
		return false;
	});
	
	
	// Number countup
	$('.count').countUp({
	  'time': 600,
	  'delay': 10
	});
	
	
	// Mobile modifications
	if($('html').hasClass('mobile')) {
		// Countries list toggle
		$('.state-item .info-trigger').click(function(){
			$(this).toggleClass('item-active');
			$(this).next('.info-box').slideToggle('slow');
		});
		
		// Timeline toggle
		$('.timeline dl dt').click(function(){
			$(this).toggleClass('active');
			if($(this).hasClass('active')) {
				$(this).addClass('active');
				$(this).next('dd').slideDown('slow');
			} else {
				$(this).removeClass('active');
				$(this).next('dd').slideUp('slow');
			}
			return false;
		});
	}

	// People tabs
	$('.tab-nav li').click(function(){
		$('.tab-nav li').removeClass('active');
		$(this).addClass('active');
		$('.people-tab').hide();

		var activeTab = $(this).find('a').attr('href');
		$(activeTab).show();
		return false;
	});
	
	// QA list toggle
	$('.toggle-list dl dt').click(function(){
		$(this).toggleClass('active');
		$(this).next('dd').slideToggle('slow');
	});
	
	// Info stats toggle
	$('.info-toggle').click(function(){
		$(this).toggleClass('active');
		$(this).next('div').slideToggle('fast');
		return false;
	});
	
	// States toggle
	$('.countries-list .state-item > a').click(function() {
		$(this).toggleClass('active');
		if($(this).hasClass('active')) {
			$('.countries-list .state-item > a').removeClass('active');
			$(this).addClass('active');
			$('.state-info-box').fadeOut('fast')
			$(this).next().fadeIn('slow');
		} else {
			$(this).removeClass('active');
			$(this).next().fadeOut('fast');
		}
		return false;
	});
	
	
	// Glossary slider
	var $slickElement = $('.text-slider');
	var $sliderStatus = $('.paging-info');
	
	$slickElement.slick({
		dots: false,
		arrows: true,
		infinite: true,
		speed: 400,
		slidesToShow: 1,
		adaptiveHeight: true
	});

	$('.text-slider').on('init reInit afterChange', function (event, slick, currentSlide, nextSlide) {
		let currentSlick = $('.slick-current.slick-active', slick.$slideTrack)
		let prevName = currentSlick.prev().data('slide-name')
		let nextName = currentSlick.next().data('slide-name')

		slick.$prevArrow.text(prevName)
		slick.$nextArrow.text(nextName)
		
		var i = (currentSlide ? currentSlide : 0) + 1;
	  	$sliderStatus.text(i + '/' + slick.slideCount);
		
	});
	
	
	// Video section functionality
	$('.type-native .video-trigger').click(function() {
		var curr = $(this);
        $('body').addClass('overlay-active');
		curr.parents('article').find(".video-holder video").get(0).play();
		curr.parents('article').addClass('playing');
		return false;
	});
	$('.type-vimeo .video-trigger').click(function() {
		var curr = $(this);
        $('body').addClass('overlay-active');
		curr.parents('article').addClass('playing');
		curr.parents('article').find(".video-holder iframe").vimeo("play");
		return false;
	});
	$('.type-native .close-video-trigger').click(function() {
		var curr = $(this);
        $('body').removeClass('overlay-active');
		curr.parents('article').removeClass('playing');
		curr.parents('article').find(".video-holder video").get(0).pause();
		return false;
	});
	$('.type-vimeo .close-video-trigger').click(function() {
		var curr = $(this);
        $('body').removeClass('overlay-active');
		curr.parents('article').removeClass('playing');
		curr.parents('article').find(".video-holder iframe").vimeo("unload")
		return false;
	});
	
    // Blog modal
    $('body[data-status="blog-not-active"] .activate-blog > a').click(function(e){
        e.preventDefault();
        $('#blog-modal').addClass('visible');
    });
    $('.modal-close').click(function(e){
        e.preventDefault();
        $('#blog-modal').fadeOut();
    });
    
	$("#active-blog").on("click", function () {
        $.cookie('blogcookie', '1', { expires: 7, path: '/' });
	});
	
});

/* Close info boxes on click outside of the box
if(!$('html').hasClass('mobile')) {
	$(document).mouseup(function (e) {
		var popup = $(".info-box-outer");
		if (!$('.info-trigger').is(e.target) && !popup.is(e.target) && popup.has(e.target).length == 0) {
			$('.info-box-outer').removeClass('active');
		}
	});
}*/