{assign var="currentPage" value="page3"}
{assign var="title" value="About mining"}
{include file="miner_h.tpl"}

	<div class="hero ">
		
		<div class="wrapper">

			<hgroup>
				<h6>About Bitcoin Mining</h6>
<h1>Bit-Digital&#8217;s Bitcoin Mining &amp; Investment Glossary</h1>
			</hgroup>

		</div>
		<div class="media" id="particles-bgr"></div>

	</div><!-- / HERO -->

	
	
	

	<section class="regular-content ">
		
		<div class="wrapper">
			<h6 class="section-title animated">WHAT IS <br />
BITCOIN MINING</h6>
			<div class="entry">
				<h3><em>Bitcoin mining refers to the work of verifying transactions on the bitcoin network. This work is central to the security built into the blockchain.</em></h3>
<h3>A decentralized network of individual specialized computers, known as miners, independently verify transactions, making the network nearly impervious to hacking or manipulation. Confirmed transactions are added to the blockchain in the form of new blocks. For solving the network’s cryptographic puzzles, miners earn bitcoin rewards to incentivize this work.</h3>
<h3>Mining is therefore a foundational component of the blockchain and the entire bitcoin system. Without Bitcoin miners, transactions could not be verified or secured in a decentralized manner without the need for a governing authority.</h3>
<h3><em>It is also through mining that new bitcoins enter the market. For every problem a miner solves, they may be rewarded with newly-minted bitcoins and transaction fees.</em></h3>
							</div>
		</div>

	</section><!-- / REGULAR CONTENT -->


	<section class="regular-content numbered-list-outer reversed">
		<div class="wrapper">
			<h6 class="section-title animated">The <br />
Process</h6>
						<ol class="numbered-list">
								<li class="animated">
					<p>A transaction is requested by a participant</p>
				</li>
								<li class="animated">
					<p>The requested transaction is broadcast to the network of miners (specialized computers)</p>
				</li>
								<li class="animated">
					<p>Miners validate the transaction and the participant’s status using mathematical algorithms</p>
				</li>
								<li class="animated">
					<p>Once verified, the transaction is combined with other transactions to form a new block of data for the ledger, known as the blockchain</p>
				</li>
								<li class="animated">
					<p>The newly-created block is then added to the existing blockchain; this addition is permanent and unalterable</p>
				</li>
								<li class="animated">
					<p>The transaction is verified and completed</p>
				</li>
							</ol>
					</div>
	</section><!-- / NUMBERED LIST -->
	<section class="regular-content qa-list-outer text-slider-outer">
		<div class="wrapper">
			<h6 class="section-title animated">Glossary</h6>
						<div class="qa-list text-slider">
								<dl data-slide-name="Bitcoin BTC" class="animated">
					<dt><span class="paging-info">1/9</span> Bitcoin BTC</dt>
					<dd>A type of cryptocurrency operated by a decentralized authority; bitcoin transactions are verified by the computing power of a global network of specialized, privately-owned computers known as miners.</dd>
				</dl>
								<dl data-slide-name="Blockchain" class="animated">
					<dt><span class="paging-info">1/9</span> Blockchain</dt>
					<dd>A decentralized public ledger permanently recording all data “blocks” of transactions across a cryptocurrency network, allowing participants to confirm transactions without the need for a central authority to verify.</dd>
				</dl>
								<dl data-slide-name="Cryptocurrency" class="animated">
					<dt><span class="paging-info">1/9</span> Cryptocurrency</dt>
					<dd>An electronic currency system. Cryptocurrency can serve as a means of exchange and/or as a store of value. It is created and stored electronically on the blockchain, encrypted to control the creation of new currency units and to verify transfers of funds. Bitcoin is the most well-known type of cryptocurrency.</dd>
				</dl>
								<dl data-slide-name="Mining Hosting Center" class="animated">
					<dt><span class="paging-info">1/9</span> Mining Hosting Center</dt>
					<dd>A type of data center specifically designed and built for mining operations housing specialized computer servers, or miners. Energy is required to power the miners and must be brought to the building and distributed to the equipment; energy use and efficiency are important considerations for such centers. Air distribution and cooling systems are designed to maintain optimal environmental conditions for the mining equipment. The building structure provides protection from outside elements and maintains the network’s security from external threats.</dd>
				</dl>
								<dl data-slide-name="Digital Asset" class="animated">
					<dt><span class="paging-info">1/9</span> Digital Asset</dt>
					<dd>A non-tangible asset created, traded, and stored in a digital format. Cryptocurrency is a type of digital asset. Other types of digital assets include NFTs and equity tokens.</dd>
				</dl>
								<dl data-slide-name="Hash Rate" class="animated">
					<dt><span class="paging-info">1/9</span> Hash Rate</dt>
					<dd>Represents the number of times per second that miners—specialized computers—perform network operations. A hash rate is a health signifier for the quality of the network at any given time, pointing to the processing power of the mining fleet. This rate is driven primarily by the difficulty of the network and the number and quality of miners on the network. Generally, a higher hash rate is considered better.</dd>
				</dl>
								<dl data-slide-name="PH/s" class="animated">
					<dt><span class="paging-info">1/9</span> PH/s</dt>
					<dd>A common measure of hash rates, representing one quadrillion hashes per second.</dd>
				</dl>
								<dl data-slide-name="Miners" class="animated">
					<dt><span class="paging-info">1/9</span> Miners</dt>
					<dd>Specialized computer hardware designed to verify blocks of bitcoin transactions and in turn, secure the network. Miners can earn newly-created bitcoins and transaction fees in connection with providing this service.</dd>
				</dl>
								<dl data-slide-name="Megawatt MW" class="animated">
					<dt><span class="paging-info">1/9</span> Megawatt MW</dt>
					<dd>A measure of the amount of electrical power. One megawatt equals 1,000 kilowatts, equal to 1,000,000 watts.</dd>
				</dl>
							</div>
					</div>
	</section><!-- / QA LIST -->
	<section class="regular-content qa-list-outer reversed">
		<div class="wrapper">
			<h6 class="section-title animated">FAQ</h6>
						<div class="qa-list toggle-list">
								<dl data-slide-name="What is a good hash rate?" class="animated">
					<dt><span class="paging-info">1/4</span> What is a good hash rate?</dt>
					<dd>A good hash rate is a high hash rate, generally seen as a health signifier for the network that points to the high processing power of the mining fleet.<br />
<br />
A good hash rate is one that keeps a cryptocurrency network secure. The more computing power contributing to a network, the harder it becomes for potential bad actors to take control of the network. A higher hash rate increases a miner’s chances of adding the next block and receiving a bitcoin reward.</dd>
				</dl>
								<dl data-slide-name="What kinds of computer hardware are used in bitcoin mining?" class="animated">
					<dt><span class="paging-info">1/4</span> What kinds of computer hardware are used in bitcoin mining?</dt>
					<dd>There are many different types of mining machines commonly used, with new ones constantly being introduced and adopted in the market. Different machines offer different amounts of power, memory and processing capacity.<br />
<br />
The main types of mining machines used in bitcoin mining are GPUs (graphics processing unit) and ASICs (application-specific integrated circuit). Many mining companies now focus on ASIC machines, which are faster in conducting their calculations.</dd>
				</dl>
								<dl data-slide-name="What effect does a larger fleet of miners have on quality of operations?" class="animated">
					<dt><span class="paging-info">1/4</span> What effect does a larger fleet of miners have on quality of operations?</dt>
					<dd>The probability that a miner will be the one to solve a block is related to its proportion of the total mining power on the network. A larger and faster mining fleet means that the fleet is, probability-wise, more likely to be the one to solve the computational problem, meaning they are more likely to earn the resulting bitcoin from that problem.<br />
<br />
Simply put, the more miners you have in your fleet and the faster they are, the more bitcoin earning potential your network has.<br />
<br />
Individual miners improve their probability of solving a block by joining large mining pools of other miners who share proportionately in rewards. </dd>
				</dl>
								<dl data-slide-name="How is the size of a mining fleet measured and reported?" class="animated">
					<dt><span class="paging-info">1/4</span> How is the size of a mining fleet measured and reported?</dt>
					<dd>There are discrepancies between the way some bitcoin miners report the size of their mining fleets. It is common for mining companies to report fleet size or hash power based on machines under contract to be added sometime in the future. Bit Digital only counts and reports currently-owned miners in our existing fleet.</dd>
				</dl>
							</div>
					</div>
	</section><!-- / QA LIST -->
{include file="miner_f.tpl"}

