$(document).ready(function(){

    //initialise the little spark coming from the star of "Best Prices"
    initialiseStarParticles();

    //initialise the laser for the Audit Orb
    initialiseAuditLaser();

    //click - dapp mode
    $(document).on('click', '.dapp-devices div:not(.active)', function(){ toggleDappMode(this); });

    //click - smooth anchors
    $(document).on('click', 'a[href^="#"]', function (event) {
        
        event.preventDefault();
        detectIfSectionIsPresent(this);

    });

    //click - roadmap tabs (only visible on mobile)
    $(document).on('click', '.roadmap-tabs li:not(.active)', function(){ changeRoadmapTab(this) });

    //click - mobile menu (only visible on mobile)
    $(document).on('click', '.mobile-menu-button', function(){ showMobileNavigation(); });

    //click - close mobile menu (only visible on mobile)
    $(document).on('click', '.close-mobile-menu-button', function(){ hideMobileNavigation(); });

    //click - mobile navigation item (only visible on mobile)
    $(document).on('click', '.mobile-navigation-list a', function(){ hideMobileNavigation(); });

    //click - show old roadmap
    $(document).on('click', '#showNew', function(){ 
        // remove old classes
        $('#new').removeClass('hideLeft');
        $('#new').removeClass('hideRight');
        $('#old').removeClass('show');
        $('#new1').removeClass('show')
        // add new classes
        $('#old').addClass('hide');
        $('#new').addClass('show');
        $('#new1').addClass('hide')
        $(".new1-container .roadmap .roadmap-tabs li:first").trigger('click');     
    });
    $(document).on('click', '#showNew1', function(){ 
        // remove old classes
        $('#new').removeClass('hideLeft');
        $('#new').removeClass('hideRight');
        $('#old').removeClass('show');
        $('#old').removeClass('hide');
        $('#new').removeClass('show');
        $('#new1').removeClass('hide')
        // add new classes
        $('#old').addClass('hide');
        $('#new').addClass('hideRight');
        $('#new1').addClass('show')
        $(".new-container .roadmap .roadmap-tabs li:first").trigger('click');     
    });

    //click - show old roadmap
    $(document).on('click', '#showOld', function(){ 
        $('#old').removeClass('hide');
        $('#new').removeClass('show');
        $('#new').removeClass('hideLeft');
        $('#new').removeClass('hideRight');
        $('#new1').removeClass('show');
        $('#new1').addClass('hide');
        $('#new').addClass('hideLeft');
        $('#old').addClass('show');
        $(".old-container .roadmap .roadmap-tabs li:first").trigger('click');     
    });

});
