var filelist_g = new FormData();
var lan = "en";

window.addEventListener("load", (event) => {
	
	jQuery(".resource_select .layui-input").bind("input propertychange",function(){
		jQuery('.layui-select-none').remove();
	});
	
	
	
	listenInput();
	setTimeout(function(){
		jQuery(".resource_select .layui-input").attr("placeholder","");
	},600);
	setTimeout(function(){
		jQuery(".resource_select .layui-input").attr("placeholder","");
	},1000);
	setTimeout(function(){
		jQuery(".resource_select .layui-input").attr("placeholder","");
	},1500);
	
});


const listenInput = function() {
	jQuery(".basis_input").bind("input propertychange",function(){
		jQuery(this).removeClass('error_input');
		jQuery(this).parent().parent().find('.file_error').remove();
	});
	jQuery(".resource_input ").bind("input propertychange",function(){
		if (jQuery(this).hasClass("number_input")){
			jQuery(this).removeClass('error_input');
			return;
		}
		jQuery(this).removeClass('error_input');
		jQuery(this).parent().parent().find('.file_error').remove();
	});
	
	jQuery(".resource_select .layui-input").bind("input propertychange",function(){
		jQuery(this).removeClass('error_input');
		jQuery(this).parent().parent().find('.file_error').remove();
	});
	
	jQuery(".resource_select dd").click(function() {
		jQuery(this).parent().parent().find(".layui-input").removeClass("error_input");
		jQuery(this).parent().parent().parent().parent().find(".file_error").remove();
	});
	
	jQuery(".number_input").bind("input propertychange",function(){
		
		var value = jQuery(this).val();
		if (value != '') {
			if (!(!isNaN(parseFloat(value)) && isFinite(value)) || value <= 0) {
				if (lan == 'en'){
					var html = `<div class="file_error num_error">Please enter a number greater than 0</div>`;
					var str = "Please enter a number above 0";
				}else {
					var html = `<div class="file_error num_error">请输入大于0的数字</div>`;
					var str = "请输入0以上的数字";
				}
				if (jQuery(this).parent().parent().find('.file_error').length>0){
					if (jQuery(this).parent().parent().find(".file_error").hasClass("num_error")){
						return;
					}else {
						jQuery(this).parent().parent().find(".file_error").addClass("num_error");
						jQuery(this).parent().parent().find(".file_error").html(str);
					}
					
				}else {
					jQuery(this).parent().parent().find(".input_label").append(html);
				}
				
			}else {
				jQuery(this).parent().parent().find('.file_error').remove();
			}
		} else {
			jQuery(this).parent().parent().find('.file_error').remove();
		}
		
	});

}

window.onload = function () {
	window.history.replaceState(null, null, window.location.href);
	var url = window.location.pathname;
	if (url.includes("zh")) {
		lan = "cn";
	}else {
		lan = "en";
	}
	
	layui.use(function(){
		var laydate = layui.laydate;
		var form = layui.form;
		laydate.render({
			elem: '.r_available_time_item',
			type: 'datetime',
			range: true,
			lang: lan,
		});
	});
	
	
	var type = getQueryVariable("t");
	if (type == 1){
		var data = "action=check_mining_farm_action";
		//var data = new FormData();
		//data.append('action','check_mining_farm_action');
		jQuery.ajax({
			type: 'POST',
			async: true,
			url: my_ajaxurl,
			// processData: false,
			// contentType: false,
			data: data,
			success: function (response) {
				// Handle success response
				if (response.data.code == 0) {
					jQuery("#mining_loading").css("display","none");
					jQuery("#mining_start").css("display","none");
					jQuery("#mining_form").css("display","block");
				} else {
					window.location.href = '/my-account/';
				}
			},
			error: function (response) {
				// Handle error response
				setTimeout(function () {
					jQuery(".mining_form_main").unblock();
				}, 100);
			}
		});
	}else {
		jQuery("#mining_loading").css("display","none");
		jQuery("#mining_start").css("display","block");
		jQuery("#mining_form").css("display","none");
	}
	


}

const clickUpload = (elem)=>{
	jQuery("."+elem).click();
}

const changeFile = (type, item)=> {
	var files = jQuery(".file_"+type+"_item"+item).get(0).files;
	var length = files.length;
	var tempHtml = "";
	let maxSize = 5 * 1024 * 1024;
	if (type == "basic" ||type == "electric" ||type == "land"){
		var fileSize = files[0].size;
		var fileName = files[0].name;
		var fileType = files[0].type;
		if (fileSize > maxSize) {
			if (lan == 'en'){
				alertMsg("The file is too large. Please upload a file smaller than 5MB");
			}else {
				alertMsg("只能上传 pdf/doc/docx格式文件，且不超过5MB");
			}
			return;
		}
		var allowType = /^(application\/pdf|application\/msword|application\/vnd.openxmlformats-officedocument.wordprocessingml.document)$/i;
		if (!allowType.test(fileType)) {
			if (lan == 'en') {
				alertMsg("The file format must be pdf/doc/docx");
			}else {
				alertMsg("只能上传 pdf/doc/docx格式文件，且不超过5MB");
			}
			return;
		}
		
		tempHtml = `<div><span class="glyphicon file_icon"></span>${fileName} <span class="btn btn-link del_file_a" onclick="deleteFile('${type}',${item})">删除</span></div>`;
		jQuery(".file_"+type+"_body_item"+item).html(tempHtml);
	}else {
		
		var l = jQuery(".flie_pool_num_item"+item).val();
		var picI = jQuery(".flie_pool_item_item"+item).val();
		
		if(l==""){
    		l=0;
		}
		for (var i = 0; i < length; i++) {
			var fileSize = files[i].size;
			var fileType = files[i].type;
			if (fileSize > maxSize) {
				if (lan == 'en'){
					alertMsg("The file is too large. Please upload a file smaller than 5MB");
				} else {
					alertMsg("只能上传 jpg/png格式文件，且大小不超过5MB");
				}
				return;
			}
			var allowType = /^(image\/jpeg|image\/png|image\/jpg)$/i;
			if (!allowType.test(fileType)) {
				if (lan == 'en'){
					alertMsg("The file format must be jpeg , png , jpg");
				} else {
					alertMsg("只能上传 jpg/png格式文件，且大小不超过5MB");
				}
				return;
			}
			
			var itemName = generateRandomString(8);
			var tmp = "pool_pic|" + item +"|"+itemName;
			tempHtml += `<div class="pic_item pic_item_${picI}"><img class="pic_img pool_pic" data-id="${tmp}" src="${URL.createObjectURL(files[i])}"><img class="delete-button" src="https://file.iceriver.io/wp-content/uploads/image/close-image.svg" onclick="deleteImg('${tmp}',${item},${picI})"></div>`;
			
			let t=filelist_g.get(tmp);
			if (t == null) {
				filelist_g.append(tmp,files[i]);
				l=Number(l)+1;
			}
			picI = Number(picI)+1;
		}
		jQuery(".flie_pool_num_item"+item).val(l);
		jQuery(".flie_pool_item_item"+item).val(picI);
		jQuery(".file_"+type+"_body_item"+item).prepend(tempHtml);
	}
}


const deleteImg = function(temp,item,picItem) {
	jQuery(".pic_item_"+picItem).remove();
	filelist_g.delete(temp);
	var l = jQuery(".flie_pool_num_item"+item).val();
	if(l!=""){
		l=Number(l)-1;
		jQuery(".flie_pool_num_item"+item).val(l);
	}
}

const deleteFile = function(type,item) {
	var uploadBtn = `<div class="upload_file" onclick="clickUpload('file_${type}_item${item}')">
					<div class="upload_content">
						<img src="https://file.iceriver.io/wp-content/uploads/image/upload_icon.svg">
						<p>点击上传</p>
					</div>
				</div>`;
	jQuery(".file_"+type+"_item"+item).val('');
	jQuery(".file_"+type+"_body_item"+item).html(uploadBtn);
}




//add mining farm
const addMiningFarm = ()=> {
	console.log("add");
	var item = parseInt(jQuery(".r_item").val());
	var itemArray = jQuery(".r_item_array").val();
	var num = parseInt(jQuery(".r_num").val());
	item++;
	num++;
	
	var selectHtml = jQuery(".country_select_html").html();
	var html = "";
	if (lan == 'en'){
		
		html = `
				<div class="resource_item resource_item${item}">

					<div class="mining_form_label">Resource Information${item}
					<div class="del_resource" onclick="deleteResource(${item})"><img src="https://file.iceriver.io/wp-content/uploads/image/del_resource.svg">Delete</div>
					</div>
					
					<div class="resource_content">
						
						<div class="resource_input_item">
							<div class="form_item1 r_pool_name_div_item${item}">
								<div class="input_label"><div><span class="required">*</span>Data Center Name</div></div>
								<div><input id="r_pool_name_item${item}" class="layui-input resource_input"></div>
							</div>

							<div class="form_item2 r_company_div_item${item}">
								<div class="input_label"><div><span class="required">*</span>Site Operator</div></div>
								<div><input id="r_company_item${item}" class="layui-input resource_input"></div>
							</div>
						</div>
						
						<div class="resource_input_item">
							<div class="form_item1 r_pool_country_div_item${item}">
								<div class="input_label"><div><span class="required">*</span>Data Center Country/Region</div></div>
								<div class="layui-form resource_select r_pool_country_select_item${item}">
									<select id="r_pool_country_item${item}" lay-search="">
									  <option value="">Please select</option>${selectHtml}
									</select>
								</div>
							</div>

							<div class="form_item2 r_pool_region_div_item${item}">
								<div class="input_label"><div><span class="required">*</span>Data Center State</div></div>
								<div><input id="r_pool_region_item${item}" class="layui-input resource_input"></div>
							</div>
						</div>
						
						<div class="resource_input_item">
							<div class="form_item r_pool_address_div_item${item}">
								<div class="input_label"><div><span class="required">*</span>Data Center Address</div></div>
								<div><input id="r_pool_address_item${item}" class="layui-input resource_input"></div>
							</div>
						</div>
						
						<div class="resource_input_item">
							<div class="form_item1 r_pool_status_div_item${item}">
								<div class="input_label"><div><span class="required">*</span>Mine Status</div></div>
								<div class="layui-form resource_select r_pool_status_select_item${item}">
									<select id="r_pool_status_item${item}">
										<option value="">Please select</option>
									  <option value="已通电">Powered On</option>
									  <option value="建设中">Under Construction</option>
									  <option value="待建设">To Be Constructed</option>
									</select>
								</div>
							</div>

							<div class="form_item2">
								<div class="input_label"><div>Mining Farm Type</div></div>
								<div class="layui-form resource_select r_pool_type_select_item${item}">
									<select id="r_pool_type_item${item}">
										<option value="">Please select</option>
									  <option value="集装箱">Container</option>
									  <option value="厂房">Workshop</option>
									</select>
								</div>
							</div>
						</div>
					
						<div class="resource_input_item">
							<div class="form_item1">
								<div class="input_label"><div>Cost Water</div></div>
								<div class="layui-input-wrap"><input id="r_water_cost_item${item}" class="layui-input resource_input number_input"><div class="layui-input-suffix input_suffix">$ /m³</div></div>
							</div>

							<div class="form_item2">
								<div class="input_label"><div>Cost Electricity Type</div></div>
								<div class="layui-form resource_select r_electric_form_select_item${item}">
									<select id="r_electric_form_item${item}">
										<option value="">Please select</option>
									  <option value="浮动电价">Floating Electricity Price</option>
									  <option value="固定电价">Fixed Electricity Price</option>
									</select>
								</div>
							</div>
						</div>
						
						<div class="resource_input_item">
							<div class="form_item1 r_electric_price_div_item${item}">
								<div class="input_label"><div><span class="required">*</span>Intended Hosted Cost Electricity</div></div>
								<div class="layui-input-wrap">
								<input id="r_electric_price_item${item}" class="layui-input resource_input number_input"><div class="layui-input-suffix input_suffix">$ /kWh</div>
								</div>
							</div>
							
							<div class="form_item2 r_total_load_div_item${item}">
								<div class="input_label"><div><span class="required">*</span>Total Capacity</div></div>
								<div class="layui-input-wrap">
								<input id="r_total_load_item${item}" class="layui-input resource_input number_input"><div class="layui-input-suffix input_suffix">MW</div>
								</div>
							</div>
						</div>
						
						<div class="resource_input_item">
							<div class="form_item1 r_available_load_div_item${item}">
								<div class="input_label"><div><span class="required">*</span>Available Capacity</div></div>
								<div class="layui-input-wrap">
								<input id="r_available_load_item${item}" class="layui-input resource_input number_input"><div class="layui-input-suffix input_suffix">MW</div>
								</div>
							</div>
							
							<div class="form_item2">
								<div class="input_label"><div>Facility Uptime</div></div>
								<div class="layui-input-wrap">
								<input id="r_available_time_item${item}" class="layui-input resource_input r_available_time_item"><div class="layui-input-suffix input_suffix"><img src="https://file.iceriver.io/wp-content/uploads/image/calendar.svg"></div>
								</div>
							</div>
						</div>
						
						<div class="resource_input_item">
							<div class="form_item1">
								<div class="input_label"><div>Expandable Capacity</div></div>
								<div class="layui-input-wrap">
								<input id="r_expand_load_item${item}" class="layui-input resource_input number_input"><div class="layui-input-suffix input_suffix">MW</div>
								</div>
							</div>

							<div class="form_item2 r_electric_type_div_item${item}">
								<div class="input_label"><div><span class="required">*</span>Energy Source(s)</div></div>
								<div class="layui-form resource_select r_electric_type_select_item${item}">
									<select id="r_electric_type_item${item}">
										<option value="">Please select</option>
									  <option value="水力">Hydro</option>
									  <option value="风能">Wind</option>
									  <option value="太阳能">Solar</option>
									  <option value="地热">Geothermal</option>
									  <option value="煤炭">Coal</option>
									  <option value="核能">Nuclear</option>
									  <option value="其他">Others</option>
									</select>
								</div>
							</div>
						</div>
						
						<div class="resource_input_item">
							<div class="form_item1">
								<div class="input_label"><div>Cost Electricity Price</div></div>
								<div class="layui-input-wrap">
								<input id="r_electric_cost_item${item}" class="layui-input resource_input number_input"><div class="layui-input-suffix input_suffix">$ /kWh</div>
								</div>
							</div>

							<div class="form_item2">
								<div class="input_label"><div>Water Source Type</div></div>
								<div class="layui-form resource_select r_water_type_select_item${item}">
									<select id="r_water_type_item${item}">
										<option value="">Please select</option>
									  <option value="自然水体（江河湖海）">Natural Water(River/Lake/Sea)</option>
									  <option value="地下水">Underground Water</option>
									  <option value="市政中水">Utility Water</option>
									</select>
								</div>
							</div>
						</div>
						
						<div class="resource_input_item">
							<div class="form_item1">
								<div class="input_label"><div>Available Water</div></div>
								<div class="layui-input-wrap">
								<input id="r_available_water_item${item}" class="layui-input resource_input number_input"><div class="layui-input-suffix input_suffix">m³/h</div>
								</div>
							</div>
						</div>
						
						
						
							<div class="resource_input_item">
								<div class="form_file_item form_file_pool_item${item}">
									<div class="input_label"><div><span class="required">*</span>Photo of Data Center</div></div>
									<p>Only jpg/jpeg/png files can be uploaded, and it should not exceed 5MB</p>
									<input class="resource_file_intput file_pool file_pool_item${item}" type="file" multiple onchange="changeFile('pool',${item})">
									<input class="flie_pool_num_item${item}" type="hidden">
									<input class="flie_pool_item_item${item}" type="hidden" value="1">
									<div class="file_pool_pic file_pool_body_item${item}">
										<div class="pic_item upload_file" onclick="clickUpload('file_pool_item${item}')">
											<div class="upload_content">
												<img src="https://file.iceriver.io/wp-content/uploads/image/upload_icon.svg">
												<p>Click to upload</p>
											</div>
										</div>
									</div>
								</div>
							</div>
							
							<div class="resource_input_item">
								<div class="form_file_item form_file_basic_item${item}">
									<div class="input_label"><div><span class="required">*</span>Mining Farm Basic Introduction</div></div>
									<p>Only pdf/doc/docx files can be uploaded, and it should not exceed 5MB</p>
									<input class="resource_file_intput file_basic file_basic_item${item}" type="file" onchange="changeFile('basic',${item})">
									<div class="file_basic_body_item${item}">
										<div class="upload_file" onclick="clickUpload('file_basic_item${item}')">
											<div class="upload_content">
												<img src="https://file.iceriver.io/wp-content/uploads/image/upload_icon.svg">
												<p>Click to upload</p>
											</div>
										</div>
									</div>
								</div>
							</div>
							
							<div class="resource_input_item">
								<div class="form_file_item">
									<div class="input_label"><div>Mining Farm Electricity Contract</div></div>
									<p>Only pdf/doc/docx files can be uploaded, and it should not exceed 5MB</p>
									<input class="resource_file_intput file_electric file_electric_item${item}" type="file" onchange="changeFile('electric',${item})">
									<div class="file_electric_body_item${item}">
										<div class="upload_file" onclick="clickUpload('file_electric_item${item}')">
											<div class="upload_content">
												<img src="https://file.iceriver.io/wp-content/uploads/image/upload_icon.svg">
												<p>Click to upload</p>
											</div>
										</div>
									</div>
								</div>
							</div>
							
							<div class="resource_input_item">
								<div class="form_file_item">
									<div class="input_label"><div>Mining Farm Land Lease Contract</div></div>
									<p>Only pdf/doc/docx files can be uploaded, and it should not exceed 5MB</p>
									<input class="resource_file_intput file_land file_land_item${item}" type="file" onchange="changeFile('land',${item})">
									<div class="file_land_body_item${item}">
										<div class="upload_file" onclick="clickUpload('file_land_item${item}')">
											<div class="upload_content">
												<img src="https://file.iceriver.io/wp-content/uploads/image/upload_icon.svg">
												<p>Click to upload</p>
											</div>
										</div>
									</div>
								</div>
							</div>
						<div class="resource_input_item">
							<div class="form_item">
								<div class="input_label"><div>Remark</div></div>
								<div>
									<textarea id="remark_item${item}" placeholder="Please enter remark information" class="resource_remark layui-textarea"></textarea>
								</div>
							</div>
						</div>
					</div>
				</div>
			`;
		
		
	} else {
	
		html = `
				<div class="resource_item resource_item${item}">

					<div class="mining_form_label">资源信息${item}
					<div class="del_resource" onclick="deleteResource(${item})"><img src="https://file.iceriver.io/wp-content/uploads/image/del_resource.svg">删除</div>
					</div>
					
					<div class="resource_content">
						
						<div class="resource_input_item">
							<div class="form_item1 r_pool_name_div_item${item}">
								<div class="input_label"><div><span class="required">*</span>矿场名称</div></div>
								<div><input id="r_pool_name_item${item}" class="layui-input resource_input"></div>
							</div>

							<div class="form_item2 r_company_div_item${item}">
								<div class="input_label"><div><span class="required">*</span>所属公司</div></div>
								<div><input id="r_company_item${item}" class="layui-input resource_input"></div>
							</div>
						</div>
						
						<div class="resource_input_item">
							<div class="form_item1 r_pool_country_div_item${item}">
								<div class="input_label"><div><span class="required">*</span>矿场所在国家/地区</div></div>
								<div class="layui-form resource_select r_pool_country_select_item${item}">
									<select id="r_pool_country_item${item}" lay-search="">
										<option value="">请选择</option>
									  ${selectHtml}
									</select>
								</div>
							</div>

							<div class="form_item2 r_pool_region_div_item${item}">
								<div class="input_label"><div><span class="required">*</span>矿场所在地区</div></div>
								<div><input id="r_pool_region_item${item}" class="layui-input resource_input"></div>
							</div>
						</div>
						
						<div class="resource_input_item">
							<div class="form_item r_pool_address_div_item${item}">
								<div class="input_label"><div><span class="required">*</span>矿场具体地址</div></div>
								<div><input id="r_pool_address_item${item}" class="layui-input resource_input"></div>
							</div>
						</div>
						
						<div class="resource_input_item">
							<div class="form_item1 r_pool_status_div_item${item}">
								<div class="input_label"><div><span class="required">*</span>矿场状态</div></div>
								<div class="layui-form resource_select r_pool_status_select_item${item}">
									<select id="r_pool_status_item${item}">
										<option value="">请选择</option>
									  <option value="已通电">已通电</option>
									  <option value="建设中">建设中</option>
									  <option value="待建设">待建设</option>
									</select>
								</div>
							</div>

							<div class="form_item2 r_pool_type_div_item${item}">
								<div class="input_label"><div>矿场类型</div></div>
								<div class="layui-form resource_select r_pool_type_select_item${item}">
									<select id="r_pool_type_item${item}">
										<option value="">请选择</option>
									  <option value="集装箱">集装箱</option>
									  <option value="厂房">厂房</option>
									</select>
								</div>
							</div>
						</div>
					
						<div class="resource_input_item">
							<div class="form_item1">
								<div class="input_label"><div>用水成本</div></div>
								<div class="layui-input-wrap"><input id="r_water_cost_item${item}" class="layui-input resource_input number_input"><div class="layui-input-suffix input_suffix">$ /m³</div></div>
							</div>

							<div class="form_item2">
								<div class="input_label"><div>电价形式</div></div>
								<div class="layui-form resource_select r_electric_form_select_item${item}">
									<select id="r_electric_form_item${item}">
										<option value="">请选择</option>
									  <option value="浮动电价">浮动电价</option>
									  <option value="固定电价">固定电价</option>
									</select>
								</div>
							</div>
						</div>
						
						<div class="resource_input_item">
							<div class="form_item1 r_electric_price_div_item${item}">
								<div class="input_label"><div><span class="required">*</span>意向托管电价</div></div>
								<div class="layui-input-wrap">
								<input id="r_electric_price_item${item}" class="layui-input resource_input number_input"><div class="layui-input-suffix input_suffix">$ /kWh</div>
								</div>
							</div>
							
							<div class="form_item2 r_total_load_div_item${item}">
								<div class="input_label"><div><span class="required">*</span>总负荷</div></div>
								<div class="layui-input-wrap">
								<input id="r_total_load_item${item}" class="layui-input resource_input number_input"><div class="layui-input-suffix input_suffix">MW</div>
								</div>
							</div>
						</div>
						
						<div class="resource_input_item">
							<div class="form_item1 r_available_load_div_item${item}">
								<div class="input_label"><div><span class="required">*</span>可用负荷</div></div>
								<div class="layui-input-wrap">
								<input id="r_available_load_item${item}" class="layui-input resource_input number_input"><div class="layui-input-suffix input_suffix">MW</div>
								</div>
							</div>
							
							<div class="form_item2">
								<div class="input_label"><div>可用时间</div></div>
								<div class="layui-input-wrap">
								<input id="r_available_time_item${item}" class="layui-input resource_input r_available_time_item"><div class="layui-input-suffix input_suffix"><img src="https://file.iceriver.io/wp-content/uploads/image/calendar.svg"></div>
								</div>
							</div>
						</div>
						
						<div class="resource_input_item">
							<div class="form_item1">
								<div class="input_label"><div>可扩展负荷</div></div>
								<div class="layui-input-wrap">
								<input id="r_expand_load_item${item}" class="layui-input resource_input number_input"><div class="layui-input-suffix input_suffix">MW</div>
								</div>
							</div>

							<div class="form_item2 r_electric_type_div_item${item}">
								<div class="input_label"><div><span class="required">*</span>电力类型</div></div>
								<div class="layui-form resource_select r_electric_type_select_item${item}">
									<select id="r_electric_type_item${item}">
										<option value="">请选择</option>
									  <option value="水力">水力</option>
									  <option value="风能">风能</option>
									  <option value="太阳能">太阳能</option>
									  <option value="地热">地热</option>
									  <option value="煤炭">煤炭</option>
									  <option value="核能">核能</option>
									  <option value="其他">其他</option>
									</select>
								</div>
							</div>
						</div>
						
						<div class="resource_input_item">
							<div class="form_item1">
								<div class="input_label"><div>成本电价</div></div>
								<div class="layui-input-wrap">
								<input id="r_electric_cost_item${item}" class="layui-input resource_input number_input"><div class="layui-input-suffix input_suffix">$ /kWh</div>
								</div>
							</div>

							<div class="form_item2">
								<div class="input_label"><div>水资源类型</div></div>
								<div class="layui-form resource_select r_water_type_select_item${item}">
									<select id="r_water_type_item${item}">
										<option value="">请选择</option>
									  <option value="自然水体（江河湖海）">自然水体（江河湖海）</option>
									  <option value="地下水">地下水</option>
									  <option value="市政中水">市政中水</option>
									</select>
								</div>
							</div>
						</div>
						
						<div class="resource_input_item">
							<div class="form_item1">
								<div class="input_label"><div>可得用水量</div></div>
								<div class="layui-input-wrap">
								<input id="r_available_water_item${item}" class="layui-input resource_input number_input"><div class="layui-input-suffix input_suffix">m³/h</div>
								</div>
							</div>
						</div>
						
						
						
							<div class="resource_input_item">
								<div class="form_file_item form_file_pool_item${item}">
									<div class="input_label"><div><span class="required">*</span>矿场照片</div></div>
									<p>只能上传 jpg/jpeg/png格式文件，且大小不超过5MB</p>
									<input class="resource_file_intput file_pool file_pool_item${item}" type="file" multiple onchange="changeFile('pool',${item})">
									<input class="flie_pool_num_item${item}" type="hidden">
									<input class="flie_pool_item_item${item}" type="hidden" value="1">
									<div class="file_pool_pic file_pool_body_item${item}">
										<div class="pic_item upload_file" onclick="clickUpload('file_pool_item${item}')">
											<div class="upload_content">
												<img src="https://file.iceriver.io/wp-content/uploads/image/upload_icon.svg">
												<p>点击上传</p>
											</div>
										</div>
									</div>
								</div>
							</div>
							
							<div class="resource_input_item">
								<div class="form_file_item form_file_basic_item${item}">
									<div class="input_label"><div><span class="required">*</span>矿场基本介绍</div></div>
									<p>只能上传 pdf/doc/docx格式文件，且不超过5MB</p>
									<input class="resource_file_intput file_basic file_basic_item${item}" type="file" onchange="changeFile('basic',${item})">
									<div class="file_basic_body_item${item}">
										<div class="upload_file" onclick="clickUpload('file_basic_item${item}')">
											<div class="upload_content">
												<img src="https://file.iceriver.io/wp-content/uploads/image/upload_icon.svg">
												<p>点击上传</p>
											</div>
										</div>
									</div>
								</div>
							</div>
							
							<div class="resource_input_item">
								<div class="form_file_item">
									<div class="input_label"><div>矿场电力合同</div></div>
									<p>只能上传 pdf/doc/docx格式文件，且不超过5MB</p>
									<input class="resource_file_intput file_electric file_electric_item${item}" type="file" onchange="changeFile('electric',${item})">
									<div class="file_electric_body_item${item}">
										<div class="upload_file" onclick="clickUpload('file_electric_item${item}')">
											<div class="upload_content">
												<img src="https://file.iceriver.io/wp-content/uploads/image/upload_icon.svg">
												<p>点击上传</p>
											</div>
										</div>
									</div>
								</div>
							</div>
							
							<div class="resource_input_item">
								<div class="form_file_item">
									<div class="input_label"><div>矿场土地租赁合同</div></div>
									<p>只能上传 pdf/doc/docx格式文件，且不超过5MB</p>
									<input class="resource_file_intput file_land file_land_item${item}" type="file" onchange="changeFile('land',${item})">
									<div class="file_land_body_item${item}">
										<div class="upload_file" onclick="clickUpload('file_land_item${item}')">
											<div class="upload_content">
												<img src="https://file.iceriver.io/wp-content/uploads/image/upload_icon.svg">
												<p>点击上传</p>
											</div>
										</div>
									</div>
								</div>
							</div>
						<div class="resource_input_item">
							<div class="form_item">
								<div class="input_label"><div>备注</div></div>
								<div>
									<textarea id="remark_item${item}" placeholder="请输入备注信息" class="resource_remark layui-textarea"></textarea>
								</div>
							</div>
						</div>
					</div>
				</div>
			`;
		}
	

	jQuery(".resource_items").append(html);
	
	itemArray = itemArray + "," + item;

	jQuery(".r_item_array").val(itemArray);
	jQuery(".r_item").val(item);
	jQuery(".r_num").val(num);
	
	
	setTimeout(function(){
		layui.use(function() {
			var laydate = layui.laydate;
			laydate.render({
				elem: '.r_available_time_item',
				type: 'datetime',
				range: true,
				lang: lan,
			});

			var form = layui.form;
			form.render('select');

			jQuery(".resource_select .layui-input").attr("placeholder","");
			jQuery(".resource_select .layui-input").bind("input propertychange",function(){
				jQuery('.layui-select-none').remove();
			});
			listenInput();
		});
		
	},500);
	
}

deleteResource = function(item) {
	var itemArray = jQuery(".r_item_array").val();
	var num = parseInt(jQuery(".r_num").val());
	itemArray = itemArray.split(",");
	var new_set = new Set(itemArray);
	new_set.delete(item.toString());
	var new_arr = [...new_set];
	for (let [key, value] of filelist_g.entries()) {
		if (key.indexOf('pool_pic|'+item+'|')>=0){
			filelist_g.delete(key);
		}
	}
	jQuery(".resource_item"+item).remove();
	jQuery(".r_num").val(num-1);
	jQuery(".r_item_array").val(new_arr);
	
}























//save mining farm
const saveMiningFarm = ()=> {
	jQuery(".mining_form_main").block({
		message: '<div class="loader"></div>',
		css: {
			border: 'none',
			backgroundColor: 'transparent',
		},
	});
	
	jQuery(".basis_input").each(function() {
		jQuery(this).removeClass("error_input");
	});
	
	
	jQuery(".resource_input").each(function() {
		jQuery(this).removeClass("error_input");
	});
	
	jQuery(".resource_select input").each(function() {
		jQuery(this).removeClass("error_input");
	});
	
	jQuery(".file_error").each(function() {
		jQuery(this).remove();
	});
	
	
	var itemArray = jQuery(".r_item_array").val();
	itemArray = itemArray.split(",");
	
	var data = new FormData();
	var isError = 0;
	var isNumError = 0;
	//basis
	var basis_company_name = jQuery("#basis_company_name").val();
	var basis_cname = jQuery("#basis_cname").val();
	var basis_cemail = jQuery("#basis_cemail").val();
	var basis_contact = jQuery("#basis_contact").val();
	data.append("company_name",basis_company_name);
	data.append("cname",basis_cname);
	data.append("cemail",basis_cemail);
	data.append("contact",basis_contact);
	if (lan == 'en'){
		if (basis_company_name == '') {
			jQuery("#basis_company_name").addClass("error_input");
			isError = 1;
			var errorHtml=`<span class="file_error">Company Name is required</span>`;
			jQuery(".basis_company_name_div .input_label").append(errorHtml);
		}
		if (basis_cname == '') {
			jQuery("#basis_cname").addClass("error_input");
			isError = 1;
			var errorHtml=`<span class="file_error">Contact Name is required</span>`;
			jQuery(".basis_cname_div .input_label").append(errorHtml);
		}
		if (basis_cemail == '') {
			jQuery("#basis_cemail").addClass("error_input");
			isError = 1;
			var errorHtml=`<span class="file_error">Contact Email is required</span>`;
			jQuery(".basis_cemail_div .input_label").append(errorHtml);
		}
		if (basis_contact == '') {
			jQuery("#basis_contact").addClass("error_input");
			isError = 1;
			var errorHtml=`<span class="file_error">Contact Info is required</span>`;
			jQuery(".basis_contact_div .input_label").append(errorHtml);
		}
	}else {
		if (basis_company_name == '') {
			jQuery("#basis_company_name").addClass("error_input");
			isError = 1;
			var errorHtml=`<span class="file_error">公司名称不能为空</span>`;
			jQuery(".basis_company_name_div .input_label").append(errorHtml);
		}
		if (basis_cname == '') {
			jQuery("#basis_cname").addClass("error_input");
			isError = 1;
			var errorHtml=`<span class="file_error">联系人姓名不能为空</span>`;
			jQuery(".basis_cname_div .input_label").append(errorHtml);
		}
		if (basis_cemail == '') {
			jQuery("#basis_cemail").addClass("error_input");
			isError = 1;
			var errorHtml=`<span class="file_error">联系邮箱不能为空</span>`;
			jQuery(".basis_cemail_div .input_label").append(errorHtml);
		}
		if (basis_contact == '') {
			jQuery("#basis_contact").addClass("error_input");
			isError = 1;
			var errorHtml=`<span class="file_error">联系方式不能为空</span>`;
			jQuery(".basis_contact_div .input_label").append(errorHtml);
		}
	}


	
	
	//resource
	for (var i of itemArray){
		var pool_name = jQuery("#r_pool_name_item"+i).val();
		var company = jQuery("#r_company_item"+i).val();
		var pool_country = jQuery("#r_pool_country_item"+i).val();
		var pool_region = jQuery("#r_pool_region_item"+i).val();
		var pool_address = jQuery("#r_pool_address_item"+i).val();
		var pool_type = jQuery("#r_pool_type_item"+i).val();
		var pool_status = jQuery("#r_pool_status_item"+i).val();
		var water_cost = jQuery("#r_water_cost_item"+i).val();
		var electric_form = jQuery("#r_electric_form_item"+i).val();
		var electric_price = jQuery("#r_electric_price_item"+i).val();
		var total_load = jQuery("#r_total_load_item"+i).val();
		var available_load = jQuery("#r_available_load_item"+i).val();
		var available_time = jQuery("#r_available_time_item"+i).val();
		var expand_load = jQuery("#r_expand_load_item"+i).val();
		var electric_type = jQuery("#r_electric_type_item"+i).val();
		var electric_cost = jQuery("#r_electric_cost_item"+i).val();
		var water_type = jQuery("#r_water_type_item"+i).val();
		var available_water = jQuery("#r_available_water_item"+i).val();
		
		var pool_introduce = jQuery(".file_basic_item"+i).get(0).files[0];
		var electric_contract = jQuery(".file_electric_item"+i).get(0).files[0];
		var land_contract = jQuery(".file_land_item"+i).get(0).files[0];
		var remark = jQuery("#remark_item"+i).val();
		
		//表单验证
		if (lan == "en") {
			if (pool_name == '') {
				jQuery("#r_pool_name_item"+i).addClass("error_input");
				isError = 1;
				var errorHtml=`<span class="file_error">Data Center Name is required</span>`;
				jQuery(".r_pool_name_div_item"+i+" .input_label").append(errorHtml);
			}

			if (company == '') {
				jQuery("#r_company_item"+i).addClass("error_input");
				isError = 1;
				var errorHtml=`<span class="file_error">Site Operator is required</span>`;
				jQuery(".r_company_div_item"+i+" .input_label").append(errorHtml);
			}

			if (pool_country == '') {
				jQuery(".r_pool_country_select_item"+i+" input").addClass("error_input");
				isError = 1;
				var errorHtml=`<span class="file_error">Data Center Country/Region is required</span>`;
				jQuery(".r_pool_country_div_item"+i+" .input_label").append(errorHtml);
			}

			if (pool_region == '') {
				jQuery("#r_pool_region_item"+i).addClass("error_input");
				isError = 1;
				var errorHtml=`<span class="file_error">Data Center State is required</span>`;
				jQuery(".r_pool_region_div_item"+i+" .input_label").append(errorHtml);
			}

			if (pool_address == '') {
				jQuery("#r_pool_address_item"+i).addClass("error_input");
				isError = 1;
				var errorHtml=`<span class="file_error">Data Center Address is required</span>`;
				jQuery(".r_pool_address_div_item"+i+" .input_label").append(errorHtml);
			}

			if (pool_status == '') {
				jQuery(".r_pool_status_select_item"+ i + " input").addClass("error_input");
				isError = 1;
				var errorHtml=`<span class="file_error">Mine Status is required</span>`;
				jQuery(".r_pool_status_div_item"+i+" .input_label").append(errorHtml);
			}

			if (electric_price == '') {
				jQuery("#r_electric_price_item"+i).addClass("error_input");
				isError = 1;
				var errorHtml=`<span class="file_error">Intended Hosted Cost Electricity is required</span>`;
				jQuery(".r_electric_price_div_item"+i+" .input_label").append(errorHtml);
			}else {
				if (!(!isNaN(parseFloat(electric_price)) && isFinite(electric_price)) || electric_price <= 0) {
					isError = 1;
					jQuery("#r_electric_price_item"+i).addClass("error_input");
					var errorHtml=`<span class="file_error">Please enter a number greater than 0</span>`;
					jQuery(".r_electric_price_div_item"+i+" .input_label").append(errorHtml);
				}
			}

			if (total_load == '') {
				jQuery("#r_total_load_item"+i).addClass("error_input");
				isError = 1;
				var errorHtml=`<span class="file_error">Total Capacity is required</span>`;
				jQuery(".r_total_load_div_item"+i+" .input_label").append(errorHtml);
			}else {
				if (!(!isNaN(parseFloat(total_load)) && isFinite(total_load)) || total_load <= 0) {
					isError = 1;
					jQuery("#r_total_load_item"+i).addClass("error_input");
					var errorHtml=`<span class="file_error">Please enter a number greater than 0</span>`;
					jQuery(".r_total_load_div_item"+i+" .input_label").append(errorHtml);
				}
			}

			if (available_load == '') {
				jQuery("#r_available_load_item"+i).addClass("error_input");
				isError = 1;
				var errorHtml=`<span class="file_error">Available Capacity is required</span>`;
				jQuery(".r_available_load_div_item"+i+" .input_label").append(errorHtml);
			}else {
				if (!(!isNaN(parseFloat(available_load)) && isFinite(available_load)) || available_load <= 0) {
					isError = 1;
					jQuery("#r_available_load_item"+i).addClass("error_input");
					var errorHtml=`<span class="file_error">Please enter a number above 0</span>`;
					jQuery(".r_available_load_div_item"+i+" .input_label").append(errorHtml);
				}
			}

			if (electric_type == '') {
				jQuery(".r_electric_type_select_item"+i+" input").addClass("error_input");
				isError = 1;
				var errorHtml=`<span class="file_error">Energy Source(s) is required</span>`;
				jQuery(".r_electric_type_div_item"+i+" .input_label").append(errorHtml);
			}

			if (pool_introduce == '' || pool_introduce == undefined || pool_introduce == null) {
				isError = 1;
				var errorHtml=`<div class="error_input file_error">Mining Farm Basic Introduction is required</div>`;
				jQuery(".form_file_basic_item"+i+" .input_label").append(errorHtml);
			}



			if (water_cost!=''){
				if (!(!isNaN(parseFloat(water_cost)) && isFinite(water_cost)) || water_cost <= 0) {
					jQuery(".r_water_cost_item"+i).addClass("error_input");
					isError = 1;
					var errorHtml=`<span class="file_error">Please enter a number greater than 0</span>`;
					jQuery(".r_water_cost_item"+i).parent().parent().find('.input_label').append(errorHtml);
				}
			}


			

			if (expand_load!=''){
				if (!(!isNaN(parseFloat(expand_load)) && isFinite(expand_load)) || expand_load <= 0) {
					jQuery(".r_expand_load_item"+i).addClass("error_input");
					isError = 1;
					var errorHtml=`<span class="file_error">Please enter a number greater than 0</span>`;
					jQuery(".r_expand_load_item"+i).parent().parent().find('.input_label').append(errorHtml);
				}
			}

			if (electric_cost!=''){
				if (!(!isNaN(parseFloat(electric_cost)) && isFinite(electric_cost)) || electric_cost <= 0) {
					jQuery(".r_electric_cost_item"+i).addClass("error_input");
					isError = 1;
					var errorHtml=`<span class="file_error">Please enter a number greater than 0</span>`;
					jQuery(".r_electric_cost_item"+i).parent().parent().find('.input_label').append(errorHtml);
				}
			}

			if (available_water!='') {
				if (!(!isNaN(parseFloat(available_water)) && isFinite(available_water)) || available_water <= 0) {
					jQuery(".r_available_water_item"+i).addClass("error_input");
					isError = 1;
					var errorHtml=`<span class="file_error">Please enter a number above 0</span>`;
					jQuery(".r_available_water_item"+i).parent().parent().find('.input_label').append(errorHtml);
				}
			}
		} else {
			if (pool_name == '') {
				jQuery("#r_pool_name_item"+i).addClass("error_input");
				isError = 1;
				var errorHtml=`<span class="file_error">矿场名称不能为空</span>`;
				jQuery(".r_pool_name_div_item"+i+" .input_label").append(errorHtml);
			}

			if (company == '') {
				jQuery("#r_company_item"+i).addClass("error_input");
				isError = 1;
				var errorHtml=`<span class="file_error">所属公司不能为空</span>`;
				jQuery(".r_company_div_item"+i+" .input_label").append(errorHtml);
			}

			if (pool_country == '') {
				jQuery(".r_pool_country_select_item"+i+" input").addClass("error_input");
				isError = 1;
				var errorHtml=`<span class="file_error">矿场所在国家/地区不能为空</span>`;
				jQuery(".r_pool_country_div_item"+i+" .input_label").append(errorHtml);
			}

			if (pool_region == '') {
				jQuery("#r_pool_region_item"+i).addClass("error_input");
				isError = 1;
				var errorHtml=`<span class="file_error">矿场所在地区不能为空</span>`;
				jQuery(".r_pool_region_div_item"+i+" .input_label").append(errorHtml);
			}

			if (pool_address == '') {
				jQuery("#r_pool_address_item"+i).addClass("error_input");
				isError = 1;
				var errorHtml=`<span class="file_error">矿场具体地址不能为空</span>`;
				jQuery(".r_pool_address_div_item"+i+" .input_label").append(errorHtml);
			}

			if (pool_status == '') {
				jQuery(".r_pool_status_select_item"+ i + " input").addClass("error_input");
				isError = 1;
				var errorHtml=`<span class="file_error">矿场状态不能为空</span>`;
				jQuery(".r_pool_status_div_item"+i+" .input_label").append(errorHtml);
			}

			if (electric_price == '') {
				jQuery("#r_electric_price_item"+i).addClass("error_input");
				isError = 1;
				var errorHtml=`<span class="file_error">意向托管电价不能为空</span>`;
				jQuery(".r_electric_price_div_item"+i+" .input_label").append(errorHtml);
			}else {
				if (!(!isNaN(parseFloat(electric_price)) && isFinite(electric_price)) || electric_price <= 0) {
					isError = 1;
					jQuery("#r_electric_price_item"+i).addClass("error_input");
					var errorHtml=`<span class="file_error">请输入大于0的数字</span>`;
					jQuery(".r_electric_price_div_item"+i+" .input_label").append(errorHtml);
				}
			}

			if (total_load == '') {
				jQuery("#r_total_load_item"+i).addClass("error_input");
				isError = 1;
				var errorHtml=`<span class="file_error">总负荷不能为空</span>`;
				jQuery(".r_total_load_div_item"+i+" .input_label").append(errorHtml);
			}else {
				if (!(!isNaN(parseFloat(total_load)) && isFinite(total_load)) || total_load <= 0) {
					isError = 1;
					jQuery("#r_total_load_item"+i).addClass("error_input");
					var errorHtml=`<span class="file_error">请输入大于0的数字</span>`;
					jQuery(".r_total_load_div_item"+i+" .input_label").append(errorHtml);
				}
			}

			if (available_load == '') {
				jQuery("#r_available_load_item"+i).addClass("error_input");
				isError = 1;
				var errorHtml=`<span class="file_error">可用负荷不能为空</span>`;
				jQuery(".r_available_load_div_item"+i+" .input_label").append(errorHtml);
			}else {
				if (!(!isNaN(parseFloat(available_load)) && isFinite(available_load)) || available_load <= 0) {
					isError = 1;
					jQuery("#r_available_load_item"+i).addClass("error_input");
					var errorHtml=`<span class="file_error">请输入大于0的数字</span>`;
					jQuery(".r_available_load_div_item"+i+" .input_label").append(errorHtml);
				}
			}

			if (electric_type == '') {
				jQuery(".r_electric_type_select_item"+i+" input").addClass("error_input");
				isError = 1;
				var errorHtml=`<span class="file_error">电力类型不能为空</span>`;
				jQuery(".r_electric_type_div_item"+i+" .input_label").append(errorHtml);
			}

			if (pool_introduce == '' || pool_introduce == undefined || pool_introduce == null) {
				isError = 1;
				var errorHtml=`<div class="error_input file_error">矿场基本介绍不能为空</div>`;
				jQuery(".form_file_basic_item"+i+" .input_label").append(errorHtml);
			}



			if (water_cost!=''){
				if (!(!isNaN(parseFloat(water_cost)) && isFinite(water_cost)) || water_cost <= 0) {
					jQuery(".r_water_cost_item"+i).addClass("error_input");
					isError = 1;
					var errorHtml=`<span class="file_error">请输入大于0的数字</span>`;
					jQuery(".r_water_cost_item"+i).parent().parent().find('.input_label').append(errorHtml);
				}
			}	

			if (expand_load!=''){
				if (!(!isNaN(parseFloat(expand_load)) && isFinite(expand_load)) || expand_load <= 0) {
					jQuery(".r_expand_load_item"+i).addClass("error_input");
					isError = 1;
					var errorHtml=`<span class="file_error">请输入大于0的数字</span>`;
					jQuery(".r_expand_load_item"+i).parent().parent().find('.input_label').append(errorHtml);
				}
			}

			if (electric_cost!=''){
				if (!(!isNaN(parseFloat(electric_cost)) && isFinite(electric_cost)) || electric_cost <= 0) {
					jQuery(".r_electric_cost_item"+i).addClass("error_input");
					isError = 1;
					var errorHtml=`<span class="file_error">请输入大于0的数字</span>`;
					jQuery(".r_electric_cost_item"+i).parent().parent().find('.input_label').append(errorHtml);
				}
			}

			if (available_water!='') {
				if (!(!isNaN(parseFloat(available_water)) && isFinite(available_water)) || available_water <= 0) {
					jQuery(".r_available_water_item"+i).addClass("error_input");
					isError = 1;
					var errorHtml=`<span class="file_error">请输入大于0的数字</span>`;
					jQuery(".r_available_water_item"+i).parent().parent().find('.input_label').append(errorHtml);
				}
			}
		}
		
		
		
	
		
		

		data.append("pool_name_"+i,pool_name);
		data.append("company_"+i,company);
		data.append("pool_country_"+i,pool_country);
		data.append("pool_region_"+i,pool_region);
		data.append("pool_address_"+i,pool_address);
		data.append("pool_type_"+i,pool_type);
		data.append("pool_status_"+i,pool_status);
		data.append("water_cost_"+i,water_cost);
		data.append("electric_form_"+i,electric_form);
		data.append("electric_price_"+i,electric_price);
		data.append("total_load_"+i,total_load);
		data.append("available_load_"+i,available_load);
		data.append("available_time_"+i,available_time);
		data.append("expand_load_"+i,expand_load);
		data.append("electric_type_"+i,electric_type);
		data.append("electric_cost_"+i,electric_cost);
		data.append("water_type_"+i,water_type);
		data.append("available_water_"+i,available_water);
		data.append("remark_"+i,remark);
		data.append("pool_introduce_"+i,pool_introduce);
		data.append("electric_contract_"+i,electric_contract);
		data.append("land_contract_"+i,land_contract);
		
	}

	

	
	var isFileError = 0;
	for (var fi of itemArray) {
		var temp = "pool_pic|" + fi +"|";
		var isHave = 0;
		for (let [key, value] of filelist_g.entries()) {
			if (key.indexOf(temp)!==-1){
				isHave = 1;
			}
		}
		
		if (isHave != 1){
			if (lan == 'en'){
				var errorHtml=`<div class="error_input file_error">Photo of Data Center is required</div>`;
			}else {
				var errorHtml=`<div class="error_input file_error">矿场照片不能为空</div>`;
			}
			jQuery(".form_file_pool_item"+fi+" .input_label").append(errorHtml);
			isFileError = 1;
		}
	}
	
	if (isError == 1) {
		setTimeout(function () {
			jQuery(".mining_form_main").unblock();
		}, 100);
		
		setTimeout(function() {
			var higth = jQuery(".error_input").offset().top;
			jQuery(document).scrollTop(higth-150);
			
		},100);
		
		return;
	}
	
	if (isFileError == 1) {
		setTimeout(function () {
			jQuery(".mining_form_main").unblock();
		}, 100);
		setTimeout(function() {
			var higth = jQuery(".error_input").offset().top;
			jQuery(document).scrollTop(higth-150);

		},100);
		return;
	}
	
	if (isNumError == 1){
		setTimeout(function () {
			jQuery(".mining_form_main").unblock();
		}, 100);
		setTimeout(function() {
			var higth = jQuery(".error_input").offset().top;
			jQuery(document).scrollTop(higth-150);

		},100);
		jQuery(".num_error1").css('display','block');
		return;
	}

	
	
	data.append('action','save_mining_farm');
	
	for (let [key, value] of filelist_g.entries()) {
		data.append(key, value);	
	}
	data.append("itemArray",itemArray);
	
	
	
	
	jQuery.ajax({
		type: 'POST',
		async: true,
		url: my_ajaxurl,
		processData: false,
		contentType: false,
		data: data,
		success: function (response) {
			// Handle success response
			setTimeout(function () {
				jQuery(".mining_form_main").unblock();
			}, 100);
			if (response.data.code == 0) {
				jQuery("#miningSubmitModal").modal('toggle');
			} else {
				alertMsg(response.data.message);
			}
		},
		error: function (response) {
			setTimeout(function () {
				jQuery(".mining_form_main").unblock();
			}, 100);
			// Handle error response
			alertMsg(response.data.message);
		}
	});
}


//contact us
const contactUs = function() {
	if (lan == 'en'){
		window.location.href = '/mining-farm/?t=1';
	}else {
		window.location.href = '/zh/mining-farm/?t=1';
	}
}


//随机数
const generateRandomString = (num) => {
	const characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
	let result1 = ' ';
	const charactersLength = characters.length;
	for (let i = 0; i < num; i++) {
		result1 += characters.charAt(Math.floor(Math.random() * charactersLength));
	}

	return result1;
}

function alertMsg(msg) {
	jQuery("#form_msg").html(msg);
	jQuery("#miningMsgModal").modal('toggle');
}



window.onbeforeunload = function() {
	document.documentElement.scrollTop = 0;
	document.body.scrollTop = 0;
}

function getQueryVariable(variable) {
	var query = window.location.search.substring(1);
	var vars = query.split("&");
	for (var i = 0; i < vars.length; i++) {
		var pair = vars[i].split("=");
		if (pair[0] == variable) {
			return pair[1];
		}
	}
	return (false);
}

